/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.commands;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.data.ReaderWriter;

public class DropTableCommand
implements Command {
    private long eventId;
    private String dbName = null;
    private String tableName = null;
    private boolean isReplicatedEvent = false;

    public DropTableCommand(String dbName, String tableName, boolean isReplicatedEvent, long eventId) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.isReplicatedEvent = isReplicatedEvent;
        this.eventId = eventId;
    }

    public DropTableCommand() {
    }

    @Override
    public List<String> get() {
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE IF EXISTS ");
        sb.append(this.dbName);
        sb.append('.');
        sb.append(this.tableName);
        if (this.isReplicatedEvent) {
            sb.append(" FOR REPLICATION('");
            sb.append(this.eventId);
            sb.append("')");
        }
        return Collections.singletonList(sb.toString());
    }

    @Override
    public boolean isRetriable() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public List<String> getUndo() {
        throw new UnsupportedOperationException("getUndo called on command that does returned false for isUndoable");
    }

    @Override
    public List<String> cleanupLocationsPerRetry() {
        return Collections.emptyList();
    }

    @Override
    public List<String> cleanupLocationsAfterEvent() {
        return Collections.emptyList();
    }

    @Override
    public long getEventId() {
        return this.eventId;
    }

    public void write(DataOutput dataOutput) throws IOException {
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.dbName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.tableName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.isReplicatedEvent);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.eventId);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.dbName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.tableName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.isReplicatedEvent = (Boolean)ReaderWriter.readDatum((DataInput)dataInput);
        this.eventId = (Long)ReaderWriter.readDatum((DataInput)dataInput);
    }
}

