/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTestUtils {
    private static Logger LOG = LoggerFactory.getLogger((String)CommandTestUtils.class.getName());

    public static void compareCommands(Command expected, Command actual, boolean ignoreSortOrder) {
        junit.framework.Assert.assertEquals(expected.getClass(), actual.getClass());
        junit.framework.Assert.assertEquals((long)expected.getEventId(), (long)actual.getEventId());
        junit.framework.Assert.assertEquals((boolean)expected.isUndoable(), (boolean)actual.isUndoable());
        junit.framework.Assert.assertEquals((boolean)expected.isRetriable(), (boolean)actual.isRetriable());
        junit.framework.Assert.assertEquals((int)expected.get().size(), (int)actual.get().size());
        Iterator actualIter = actual.get().iterator();
        for (String s : expected.get()) {
            if (ignoreSortOrder) {
                CommandTestUtils.assertSortedEquals(s, (String)actualIter.next());
                continue;
            }
            junit.framework.Assert.assertEquals((String)s, (String)((String)actualIter.next()));
        }
        if (expected.isUndoable()) {
            Iterator actualUndoIter = actual.getUndo().iterator();
            for (String s : expected.getUndo()) {
                if (ignoreSortOrder) {
                    CommandTestUtils.assertSortedEquals(s, (String)actualUndoIter.next());
                    continue;
                }
                junit.framework.Assert.assertEquals((String)s, (String)((String)actualIter.next()));
            }
        }
    }

    private static void assertSortedEquals(String expected, String actual) {
        char[] expectedChars = expected.toCharArray();
        Arrays.sort(expectedChars);
        char[] actualChars = actual.toCharArray();
        Arrays.sort(actualChars);
        junit.framework.Assert.assertEquals((String)String.valueOf(expectedChars), (String)String.valueOf(actualChars));
    }

    public static void testCommandSerialization(Command cmd) {
        String serializedCmd = null;
        try {
            serializedCmd = ReplicationUtils.serializeCommand((Command)cmd);
        }
        catch (IOException e) {
            LOG.error("Serialization error", (Throwable)e);
            Assert.assertNull((Object)e);
        }
        Command cmd2 = null;
        try {
            cmd2 = ReplicationUtils.deserializeCommand((String)serializedCmd);
        }
        catch (IOException e) {
            LOG.error("Serialization error", (Throwable)e);
            Assert.assertNull((Object)e);
        }
        junit.framework.Assert.assertEquals(cmd.getClass(), cmd2.getClass());
        junit.framework.Assert.assertEquals((long)cmd.getEventId(), (long)cmd2.getEventId());
        junit.framework.Assert.assertEquals((Object)cmd.get(), (Object)cmd2.get());
        junit.framework.Assert.assertEquals((boolean)cmd.isUndoable(), (boolean)cmd2.isUndoable());
        if (cmd.isUndoable()) {
            junit.framework.Assert.assertEquals((Object)cmd.getUndo(), (Object)cmd2.getUndo());
        }
        junit.framework.Assert.assertEquals((boolean)cmd.isRetriable(), (boolean)cmd2.isRetriable());
    }
}

