/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl;

import com.google.common.base.Function;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.StagingDirectoryProvider;
import org.apache.hive.hcatalog.messaging.MessageFactory;

@InterfaceStability.Evolving
public abstract class ReplicationTask {
    protected HCatNotificationEvent event;
    protected StagingDirectoryProvider srcStagingDirProvider = null;
    protected StagingDirectoryProvider dstStagingDirProvider = null;
    protected Function<String, String> tableNameMapping = null;
    protected Function<String, String> dbNameMapping = null;
    protected static MessageFactory messageFactory = MessageFactory.getInstance();
    private static Factory factoryInstance = null;
    private static String factoryClassName = null;

    private static Factory getFactoryInstance(HCatClient client) {
        if (factoryInstance == null) {
            ReplicationTask.createFactoryInstance(client);
        }
        return factoryInstance;
    }

    private static synchronized void createFactoryInstance(HCatClient client) {
        if (factoryInstance == null) {
            if (factoryClassName == null) {
                factoryClassName = client.getConfVal(HiveConf.ConfVars.HIVE_REPL_TASK_FACTORY.varname, "");
            }
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                factoryInstance = (Factory)factoryClass.newInstance();
            }
            catch (Exception e) {
                factoryInstance = new Factory(){

                    @Override
                    public ReplicationTask create(HCatClient client, HCatNotificationEvent event) {
                        throw new IllegalStateException("Error instantiating ReplicationTask.Factory " + HiveConf.ConfVars.HIVE_REPL_TASK_FACTORY.varname + "=" + factoryClassName + ". Call resetFactory() if you need to reset to a valid one.");
                    }
                };
            }
        }
    }

    public static void resetFactory(Class<? extends Factory> factoryClass) {
        factoryClassName = factoryClass != null ? factoryClass.getName() : null;
        factoryInstance = null;
    }

    public static ReplicationTask create(HCatClient client, HCatNotificationEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event should not be null");
        }
        return ReplicationTask.getFactoryInstance(client).create(client, event);
    }

    protected ReplicationTask(HCatNotificationEvent event) {
        this.event = event;
    }

    public HCatNotificationEvent getEvent() {
        return this.event;
    }

    public abstract boolean needsStagingDirs();

    public boolean isActionable() {
        if (!this.needsStagingDirs()) {
            return true;
        }
        return this.srcStagingDirProvider != null && this.dstStagingDirProvider != null;
    }

    public ReplicationTask withSrcStagingDirProvider(StagingDirectoryProvider srcStagingDirProvider) {
        this.srcStagingDirProvider = srcStagingDirProvider;
        return this;
    }

    public ReplicationTask withDstStagingDirProvider(StagingDirectoryProvider dstStagingDirProvider) {
        this.dstStagingDirProvider = dstStagingDirProvider;
        return this;
    }

    public ReplicationTask withTableNameMapping(Function<String, String> tableNameMapping) {
        this.tableNameMapping = tableNameMapping;
        return this;
    }

    public ReplicationTask withDbNameMapping(Function<String, String> dbNameMapping) {
        this.dbNameMapping = dbNameMapping;
        return this;
    }

    protected void verifyActionable() {
        if (!this.isActionable()) {
            throw new IllegalStateException("actionable command on task called when ReplicationTask is still not actionable.");
        }
    }

    public abstract Iterable<? extends Command> getSrcWhCommands();

    public abstract Iterable<? extends Command> getDstWhCommands();

    protected void validateEventType(HCatNotificationEvent event, String allowedEventType) {
        if (event == null || !allowedEventType.equals(event.getEventType())) {
            throw new IllegalStateException(this.getClass().getName() + " valid only for " + allowedEventType + " events.");
        }
    }

    public static interface Factory {
        public ReplicationTask create(HCatClient var1, HCatNotificationEvent var2);
    }
}

