/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client.lock;

import java.util.Collection;
import java.util.TimerTask;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HeartbeatTimerTask
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatTimerTask.class);
    private final IMetaStoreClient metaStoreClient;
    private final long lockId;
    private final Long transactionId;
    private final LockFailureListener listener;
    private final Collection<Table> tableDescriptors;

    HeartbeatTimerTask(IMetaStoreClient metaStoreClient, LockFailureListener listener, Long transactionId, Collection<Table> tableDescriptors, long lockId) {
        this.metaStoreClient = metaStoreClient;
        this.listener = listener;
        this.transactionId = transactionId;
        this.tableDescriptors = tableDescriptors;
        this.lockId = lockId;
        LOG.debug("Reporting to listener {}", (Object)listener);
    }

    @Override
    public void run() {
        try {
            this.metaStoreClient.heartbeat(this.transactionId == null ? 0L : this.transactionId, this.lockId);
            LOG.debug("Sent heartbeat for lock={}, transactionId={}", (Object)this.lockId, (Object)this.transactionId);
        }
        catch (NoSuchLockException | NoSuchTxnException | TxnAbortedException e) {
            this.failLock((Exception)e);
        }
        catch (TException e) {
            LOG.warn("Failed to send heartbeat to meta store.", (Throwable)e);
        }
    }

    private void failLock(Exception e) {
        LOG.debug("Lock " + this.lockId + " failed, cancelling heartbeat and notifying listener: " + this.listener, (Throwable)e);
        this.cancel();
        this.listener.lockFailed(this.lockId, this.transactionId, Lock.asStrings(this.tableDescriptors), e);
    }

    public String toString() {
        return "HeartbeatTimerTask [lockId=" + this.lockId + ", transactionId=" + this.transactionId + "]";
    }
}

