/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdException;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.GroupRevisitedException;
import org.apache.hive.hcatalog.streaming.mutate.worker.GroupingValidator;
import org.apache.hive.hcatalog.streaming.mutate.worker.Mutator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordSequenceException;
import org.apache.hive.hcatalog.streaming.mutate.worker.SequenceValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMutatorCoordinator {
    private static final List<String> UNPARTITIONED = Collections.emptyList();
    private static final List<String> PARTITION_B = Arrays.asList("B");
    private static final List<String> PARTITION_A = Arrays.asList("A");
    private static final long WRITE_ID = 2L;
    private static final int BUCKET_ID = 0;
    private static final Path PATH_A = new Path("X");
    private static final Path PATH_B = new Path("B");
    private static final Object RECORD = "RECORD";
    private static final RecordIdentifier ROW__ID_B0_R0 = new RecordIdentifier(10L, 0, 0L);
    private static final RecordIdentifier ROW__ID_B0_R1 = new RecordIdentifier(10L, 0, 1L);
    private static final RecordIdentifier ROW__ID_B1_R0 = new RecordIdentifier(10L, 1, 0L);
    private static final RecordIdentifier ROW__ID_INSERT = new RecordIdentifier(-1L, 0, -1L);
    @Mock
    private MutatorFactory mockMutatorFactory;
    @Mock
    private PartitionHelper mockPartitionHelper;
    @Mock
    private GroupingValidator mockGroupingValidator;
    @Mock
    private SequenceValidator mockSequenceValidator;
    @Mock
    private AcidTable mockAcidTable;
    @Mock
    private RecordInspector mockRecordInspector;
    @Mock
    private BucketIdResolver mockBucketIdResolver;
    @Mock
    private Mutator mockMutator;
    private MutatorCoordinator coordinator;
    private HiveConf configuration = new HiveConf();

    public TestMutatorCoordinator() {
        this.configuration.set("fs.defaultFS", "file:///");
    }

    @Before
    public void createCoordinator() throws Exception {
        Mockito.when((Object)this.mockAcidTable.getOutputFormatName()).thenReturn((Object)OrcOutputFormat.class.getName());
        Mockito.when((Object)this.mockAcidTable.getTotalBuckets()).thenReturn((Object)1);
        Mockito.when((Object)this.mockAcidTable.getWriteId()).thenReturn((Object)2L);
        Mockito.when((Object)this.mockAcidTable.createPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.mockMutatorFactory.newRecordInspector()).thenReturn((Object)this.mockRecordInspector);
        Mockito.when((Object)this.mockMutatorFactory.newBucketIdResolver(ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBucketIdResolver);
        Mockito.when((Object)this.mockMutatorFactory.newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.anyLong(), (Path)ArgumentMatchers.any(Path.class), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockMutator);
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition((List)ArgumentMatchers.any(List.class))).thenReturn((Object)PATH_A);
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_INSERT);
        Mockito.lenient().when((Object)this.mockSequenceValidator.isInSequence((RecordIdentifier)ArgumentMatchers.any(RecordIdentifier.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockGroupingValidator.isInSequence((List)ArgumentMatchers.any(List.class), ArgumentMatchers.anyInt())).thenReturn((Object)true);
        this.coordinator = new MutatorCoordinator(this.configuration, this.mockMutatorFactory, this.mockPartitionHelper, this.mockGroupingValidator, this.mockSequenceValidator, this.mockAcidTable, false);
    }

    @Test
    public void insert() throws Exception {
        this.coordinator.insert(UNPARTITIONED, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(UNPARTITIONED);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((Mutator)Mockito.verify((Object)this.mockMutator)).insert(RECORD);
    }

    @Test
    public void multipleInserts() throws Exception {
        this.coordinator.insert(UNPARTITIONED, RECORD);
        this.coordinator.insert(UNPARTITIONED, RECORD);
        this.coordinator.insert(UNPARTITIONED, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(UNPARTITIONED);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((Mutator)Mockito.verify((Object)this.mockMutator, (VerificationMode)Mockito.times((int)3))).insert(RECORD);
    }

    @Test
    public void insertPartitionChanges() throws Exception {
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition(PARTITION_A)).thenReturn((Object)PATH_A);
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition(PARTITION_B)).thenReturn((Object)PATH_B);
        this.coordinator.insert(PARTITION_A, RECORD);
        this.coordinator.insert(PARTITION_B, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(PARTITION_A);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(PARTITION_B);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_B), ArgumentMatchers.eq((int)0));
        ((Mutator)Mockito.verify((Object)this.mockMutator, (VerificationMode)Mockito.times((int)2))).insert(RECORD);
    }

    @Test
    public void bucketChanges() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0, (Object[])new RecordIdentifier[]{ROW__ID_B1_R0});
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)0, (Object[])new Integer[]{1});
        this.coordinator.update(UNPARTITIONED, RECORD);
        this.coordinator.delete(UNPARTITIONED, RECORD);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)1));
        ((Mutator)Mockito.verify((Object)this.mockMutator)).update(RECORD);
        ((Mutator)Mockito.verify((Object)this.mockMutator)).delete(RECORD);
    }

    @Test
    public void partitionThenBucketChanges() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0, (Object[])new RecordIdentifier[]{ROW__ID_B0_R1, ROW__ID_B1_R0, ROW__ID_INSERT});
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)0, (Object[])new Integer[]{0, 1, 0});
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition(PARTITION_A)).thenReturn((Object)PATH_A);
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition(PARTITION_B)).thenReturn((Object)PATH_B);
        this.coordinator.update(PARTITION_A, RECORD);
        this.coordinator.insert(PARTITION_B, RECORD);
        this.coordinator.delete(PARTITION_B, RECORD);
        this.coordinator.update(PARTITION_B, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(PARTITION_B);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory, (VerificationMode)Mockito.times((int)2))).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_B), ArgumentMatchers.eq((int)0));
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_B), ArgumentMatchers.eq((int)1));
        ((Mutator)Mockito.verify((Object)this.mockMutator, (VerificationMode)Mockito.times((int)2))).update(RECORD);
        ((Mutator)Mockito.verify((Object)this.mockMutator)).delete(RECORD);
        ((Mutator)Mockito.verify((Object)this.mockMutator)).insert(RECORD);
        ((SequenceValidator)Mockito.verify((Object)this.mockSequenceValidator, (VerificationMode)Mockito.times((int)4))).reset();
    }

    @Test
    public void partitionThenBucketChangesNoCreateAsPartitionEstablished() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0, (Object[])new RecordIdentifier[]{ROW__ID_INSERT});
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)0, (Object[])new Integer[]{0});
        Mockito.when((Object)this.mockPartitionHelper.getPathForPartition(PARTITION_B)).thenReturn((Object)PATH_B);
        this.coordinator.delete(PARTITION_B, RECORD);
        this.coordinator.insert(PARTITION_B, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper, (VerificationMode)Mockito.never())).createPartitionIfNotExists(ArgumentMatchers.anyList());
    }

    @Test(expected=RecordSequenceException.class)
    public void outOfSequence() throws Exception {
        Mockito.when((Object)this.mockSequenceValidator.isInSequence((RecordIdentifier)ArgumentMatchers.any(RecordIdentifier.class))).thenReturn((Object)false);
        this.coordinator.update(UNPARTITIONED, RECORD);
        this.coordinator.delete(UNPARTITIONED, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(UNPARTITIONED);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((Mutator)Mockito.verify((Object)this.mockMutator)).update(RECORD);
        ((Mutator)Mockito.verify((Object)this.mockMutator)).delete(RECORD);
    }

    @Test(expected=GroupRevisitedException.class)
    public void revisitGroup() throws Exception {
        Mockito.when((Object)this.mockGroupingValidator.isInSequence((List)ArgumentMatchers.any(List.class), ArgumentMatchers.anyInt())).thenReturn((Object)false);
        this.coordinator.update(UNPARTITIONED, RECORD);
        this.coordinator.delete(UNPARTITIONED, RECORD);
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).createPartitionIfNotExists(UNPARTITIONED);
        ((MutatorFactory)Mockito.verify((Object)this.mockMutatorFactory)).newMutator((AcidOutputFormat)ArgumentMatchers.any(OrcOutputFormat.class), ArgumentMatchers.eq((long)2L), (Path)ArgumentMatchers.eq((Object)PATH_A), ArgumentMatchers.eq((int)0));
        ((Mutator)Mockito.verify((Object)this.mockMutator)).update(RECORD);
        ((Mutator)Mockito.verify((Object)this.mockMutator)).delete(RECORD);
    }

    @Test(expected=BucketIdException.class)
    public void insertWithBadBucket() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0);
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)1);
        this.coordinator.insert(UNPARTITIONED, RECORD);
    }

    @Test(expected=BucketIdException.class)
    public void updateWithBadBucket() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0);
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)1);
        this.coordinator.update(UNPARTITIONED, RECORD);
    }

    @Test
    public void deleteWithBadBucket() throws Exception {
        Mockito.when((Object)this.mockRecordInspector.extractRecordIdentifier(RECORD)).thenReturn((Object)ROW__ID_B0_R0);
        Mockito.when((Object)this.mockBucketIdResolver.computeBucketId(RECORD)).thenReturn((Object)1);
        this.coordinator.delete(UNPARTITIONED, RECORD);
    }

    @Test
    public void closeNoRecords() throws Exception {
        this.coordinator.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMutator});
    }

    @Test
    public void closeUsedCoordinator() throws Exception {
        this.coordinator.insert(UNPARTITIONED, RECORD);
        this.coordinator.close();
        ((Mutator)Mockito.verify((Object)this.mockMutator)).close();
        ((PartitionHelper)Mockito.verify((Object)this.mockPartitionHelper)).close();
    }
}

