/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.mutate.client.Transaction;
import org.apache.hive.hcatalog.streaming.mutate.client.TransactionException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestTransaction {
    private static final String USER = "user";
    private static final long TRANSACTION_ID = 10L;
    @Mock
    private Lock mockLock;
    @Mock
    private IMetaStoreClient mockMetaStoreClient;
    private Transaction transaction;

    @Before
    public void createTransaction() throws Exception {
        Mockito.when((Object)this.mockLock.getUser()).thenReturn((Object)USER);
        Mockito.when((Object)this.mockMetaStoreClient.openTxn(USER)).thenReturn((Object)10L);
        this.transaction = new Transaction(this.mockMetaStoreClient, this.mockLock);
    }

    @Test
    public void testInitialState() {
        Assert.assertThat((Object)this.transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.INACTIVE));
        Assert.assertThat((Object)this.transaction.getTransactionId(), (Matcher)CoreMatchers.is((Object)10L));
    }

    @Test
    public void testBegin() throws Exception {
        this.transaction.begin();
        ((Lock)Mockito.verify((Object)this.mockLock)).acquire(10L);
        Assert.assertThat((Object)this.transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.OPEN));
    }

    @Test
    public void testBeginLockFails() throws Exception {
        ((Lock)Mockito.doThrow((Throwable[])new Throwable[]{new LockException("")}).when((Object)this.mockLock)).acquire(10L);
        try {
            this.transaction.begin();
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.INACTIVE));
    }

    @Test
    public void testCommit() throws Exception {
        this.transaction.commit();
        ((Lock)Mockito.verify((Object)this.mockLock)).release();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).commitTxn(10L);
        Assert.assertThat((Object)this.transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
    }

    @Test(expected=TransactionException.class)
    public void testCommitLockFails() throws Exception {
        ((Lock)Mockito.doThrow((Throwable[])new Throwable[]{new LockException("")}).when((Object)this.mockLock)).release();
        this.transaction.commit();
    }

    @Test
    public void testAbort() throws Exception {
        this.transaction.abort();
        ((Lock)Mockito.verify((Object)this.mockLock)).release();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).rollbackTxn(10L);
        Assert.assertThat((Object)this.transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.ABORTED));
    }

    @Test(expected=TransactionException.class)
    public void testAbortLockFails() throws Exception {
        ((Lock)Mockito.doThrow((Throwable[])new Throwable[]{new LockException("")}).when((Object)this.mockLock)).release();
        this.transaction.abort();
    }
}

