/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.streaming.mutate.HiveConfFactory;
import org.apache.hive.hcatalog.streaming.mutate.UgiMetaStoreClientFactory;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.worker.MetaStorePartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.WarehousePartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.WorkerException;

@Deprecated
public class MutatorCoordinatorBuilder {
    private HiveConf configuration;
    private MutatorFactory mutatorFactory;
    private UserGroupInformation authenticatedUser;
    private String metaStoreUri;
    private AcidTable table;
    private boolean deleteDeltaIfExists;

    public MutatorCoordinatorBuilder configuration(HiveConf configuration) {
        this.configuration = configuration;
        return this;
    }

    public MutatorCoordinatorBuilder authenticatedUser(UserGroupInformation authenticatedUser) {
        this.authenticatedUser = authenticatedUser;
        return this;
    }

    public MutatorCoordinatorBuilder metaStoreUri(String metaStoreUri) {
        this.metaStoreUri = metaStoreUri;
        return this;
    }

    public MutatorCoordinatorBuilder table(AcidTable table) {
        this.table = table;
        return this;
    }

    public MutatorCoordinatorBuilder deleteDeltaIfExists() {
        this.deleteDeltaIfExists = true;
        return this;
    }

    public MutatorCoordinatorBuilder mutatorFactory(MutatorFactory mutatorFactory) {
        this.mutatorFactory = mutatorFactory;
        return this;
    }

    public MutatorCoordinator build() throws WorkerException, MetaException {
        this.configuration = HiveConfFactory.newInstance((Configuration)this.configuration, this.getClass(), this.metaStoreUri);
        PartitionHelper partitionHelper = this.table.createPartitions() ? this.newMetaStorePartitionHelper() : this.newWarehousePartitionHelper();
        return new MutatorCoordinator(this.configuration, this.mutatorFactory, partitionHelper, this.table, this.deleteDeltaIfExists);
    }

    private PartitionHelper newWarehousePartitionHelper() throws MetaException, WorkerException {
        String location = this.table.getTable().getSd().getLocation();
        Path tablePath = new Path(location);
        List partitionFields = this.table.getTable().getPartitionKeys();
        ArrayList<String> partitionColumns = new ArrayList<String>(partitionFields.size());
        for (FieldSchema field : partitionFields) {
            partitionColumns.add(field.getName());
        }
        return new WarehousePartitionHelper((Configuration)this.configuration, tablePath, partitionColumns);
    }

    private PartitionHelper newMetaStorePartitionHelper() throws MetaException, WorkerException {
        String user = this.authenticatedUser == null ? System.getProperty("user.name") : this.authenticatedUser.getShortUserName();
        boolean secureMode = this.authenticatedUser == null ? false : this.authenticatedUser.hasKerberosCredentials();
        try {
            IMetaStoreClient metaStoreClient = new UgiMetaStoreClientFactory(this.metaStoreUri, this.configuration, this.authenticatedUser, user, secureMode).newInstance(HCatUtil.getHiveMetastoreClient((HiveConf)this.configuration));
            String tableLocation = this.table.getTable().getSd().getLocation();
            Path tablePath = new Path(tableLocation);
            return new MetaStorePartitionHelper(metaStoreClient, this.table.getDatabaseName(), this.table.getTableName(), tablePath);
        }
        catch (IOException e) {
            throw new WorkerException("Could not create meta store client.", e);
        }
    }
}

