/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client.lock;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.HeartbeatTimerTask;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;
import org.apache.thrift.TException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHeartbeatTimerTask {
    private static final long TRANSACTION_ID = 10L;
    private static final long LOCK_ID = 1L;
    private static final List<Table> TABLES = TestHeartbeatTimerTask.createTable();
    @Mock
    private IMetaStoreClient mockMetaStoreClient;
    @Mock
    private LockFailureListener mockListener;
    private HeartbeatTimerTask task;

    @Before
    public void create() throws Exception {
        this.task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(10L), TABLES, 1L);
    }

    @Test
    public void testRun() throws Exception {
        this.task.run();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).heartbeat(10L, 1L);
    }

    @Test
    public void testRunNullTransactionId() throws Exception {
        this.task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, null, TABLES, 1L);
        this.task.run();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).heartbeat(0L, 1L);
    }

    @Test
    public void testRunHeartbeatFailsNoSuchLockException() throws Exception {
        NoSuchLockException exception = new NoSuchLockException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockMetaStoreClient)).heartbeat(10L, 1L);
        this.task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(1L, Long.valueOf(10L), Arrays.asList("DB.TABLE"), (Throwable)exception);
    }

    @Test
    public void testRunHeartbeatFailsNoSuchTxnException() throws Exception {
        NoSuchTxnException exception = new NoSuchTxnException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockMetaStoreClient)).heartbeat(10L, 1L);
        this.task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(1L, Long.valueOf(10L), Arrays.asList("DB.TABLE"), (Throwable)exception);
    }

    @Test
    public void testRunHeartbeatFailsTxnAbortedException() throws Exception {
        TxnAbortedException exception = new TxnAbortedException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockMetaStoreClient)).heartbeat(10L, 1L);
        this.task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(1L, Long.valueOf(10L), Arrays.asList("DB.TABLE"), (Throwable)exception);
    }

    @Test
    public void testRunHeartbeatFailsTException() throws Exception {
        TException exception = new TException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockMetaStoreClient)).heartbeat(10L, 1L);
        this.task.run();
    }

    private static List<Table> createTable() {
        Table table = new Table();
        table.setDbName("DB");
        table.setTableName("TABLE");
        return Arrays.asList(table);
    }
}

