/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdException;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.GroupRevisitedException;
import org.apache.hive.hcatalog.streaming.mutate.worker.GroupingValidator;
import org.apache.hive.hcatalog.streaming.mutate.worker.Mutator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;
import org.apache.hive.hcatalog.streaming.mutate.worker.OperationType;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordSequenceException;
import org.apache.hive.hcatalog.streaming.mutate.worker.SequenceValidator;
import org.apache.hive.hcatalog.streaming.mutate.worker.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MutatorCoordinator
implements Closeable,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(MutatorCoordinator.class);
    private final MutatorFactory mutatorFactory;
    private final GroupingValidator groupingValidator;
    private final SequenceValidator sequenceValidator;
    private final AcidTable table;
    private final RecordInspector recordInspector;
    private final PartitionHelper partitionHelper;
    private final AcidOutputFormat<?, ?> outputFormat;
    private final BucketIdResolver bucketIdResolver;
    private final HiveConf configuration;
    private final boolean deleteDeltaIfExists;
    private int bucketId;
    private List<String> partitionValues;
    private Path partitionPath;
    private Mutator mutator;

    MutatorCoordinator(HiveConf configuration, MutatorFactory mutatorFactory, PartitionHelper partitionHelper, AcidTable table, boolean deleteDeltaIfExists) throws WorkerException {
        this(configuration, mutatorFactory, partitionHelper, new GroupingValidator(), new SequenceValidator(), table, deleteDeltaIfExists);
    }

    MutatorCoordinator(HiveConf configuration, MutatorFactory mutatorFactory, PartitionHelper partitionHelper, GroupingValidator groupingValidator, SequenceValidator sequenceValidator, AcidTable table, boolean deleteDeltaIfExists) throws WorkerException {
        this.configuration = configuration;
        this.mutatorFactory = mutatorFactory;
        this.partitionHelper = partitionHelper;
        this.groupingValidator = groupingValidator;
        this.sequenceValidator = sequenceValidator;
        this.table = table;
        this.deleteDeltaIfExists = deleteDeltaIfExists;
        this.recordInspector = this.mutatorFactory.newRecordInspector();
        this.bucketIdResolver = this.mutatorFactory.newBucketIdResolver(table.getTotalBuckets());
        this.bucketId = -1;
        this.outputFormat = this.createOutputFormat(table.getOutputFormatName(), configuration);
    }

    public void insert(List<String> partitionValues, Object record) throws WorkerException {
        this.reconfigureState(OperationType.INSERT, partitionValues, record);
        try {
            this.mutator.insert(record);
            LOG.debug("Inserted into partition={}, record={}", partitionValues, record);
        }
        catch (IOException e) {
            throw new WorkerException("Failed to insert record '" + record + " using mutator '" + this.mutator + "'.", e);
        }
    }

    public void update(List<String> partitionValues, Object record) throws WorkerException {
        this.reconfigureState(OperationType.UPDATE, partitionValues, record);
        try {
            this.mutator.update(record);
            LOG.debug("Updated in partition={}, record={}", partitionValues, record);
        }
        catch (IOException e) {
            throw new WorkerException("Failed to update record '" + record + " using mutator '" + this.mutator + "'.", e);
        }
    }

    public void delete(List<String> partitionValues, Object record) throws WorkerException {
        this.reconfigureState(OperationType.DELETE, partitionValues, record);
        try {
            this.mutator.delete(record);
            LOG.debug("Deleted from partition={}, record={}", partitionValues, record);
        }
        catch (IOException e) {
            throw new WorkerException("Failed to delete record '" + record + " using mutator '" + this.mutator + "'.", e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.mutator != null) {
                this.mutator.close();
            }
        }
        finally {
            this.partitionHelper.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mutator != null) {
            this.mutator.flush();
        }
    }

    private void reconfigureState(OperationType operationType, List<String> newPartitionValues, Object record) throws WorkerException {
        RecordIdentifier newRecordIdentifier = this.extractRecordIdentifier(operationType, newPartitionValues, record);
        int newBucketId = newRecordIdentifier.getBucketProperty();
        if (newPartitionValues == null) {
            newPartitionValues = Collections.emptyList();
        }
        try {
            if (this.partitionHasChanged(newPartitionValues)) {
                if (this.table.createPartitions() && operationType == OperationType.INSERT) {
                    this.partitionHelper.createPartitionIfNotExists(newPartitionValues);
                }
                Path newPartitionPath = this.partitionHelper.getPathForPartition(newPartitionValues);
                this.resetMutator(newBucketId, newPartitionValues, newPartitionPath);
            } else if (this.bucketIdHasChanged(newBucketId)) {
                this.resetMutator(newBucketId, this.partitionValues, this.partitionPath);
            } else {
                this.validateRecordSequence(operationType, newRecordIdentifier);
            }
        }
        catch (IOException e) {
            throw new WorkerException("Failed to reset mutator when performing " + operationType + " of record: " + record, e);
        }
    }

    private RecordIdentifier extractRecordIdentifier(OperationType operationType, List<String> newPartitionValues, Object record) throws BucketIdException {
        RecordIdentifier recordIdentifier = this.recordInspector.extractRecordIdentifier(record);
        int bucketIdFromRecord = BucketCodec.determineVersion((int)recordIdentifier.getBucketProperty()).decodeWriterId(recordIdentifier.getBucketProperty());
        int computedBucketId = this.bucketIdResolver.computeBucketId(record);
        if (operationType != OperationType.DELETE && bucketIdFromRecord != computedBucketId) {
            throw new BucketIdException("RecordIdentifier.bucketId != computed bucketId (" + computedBucketId + ") for record " + recordIdentifier + " in partition " + newPartitionValues + ".");
        }
        return recordIdentifier;
    }

    private void resetMutator(int newBucketId, List<String> newPartitionValues, Path newPartitionPath) throws IOException, GroupRevisitedException {
        if (this.mutator != null) {
            this.mutator.close();
        }
        this.validateGrouping(newPartitionValues, newBucketId);
        this.sequenceValidator.reset();
        if (this.deleteDeltaIfExists) {
            this.deleteDeltaIfExists(newPartitionPath, this.table.getWriteId(), newBucketId);
        }
        this.mutator = this.mutatorFactory.newMutator(this.outputFormat, this.table.getWriteId(), newPartitionPath, newBucketId);
        this.bucketId = newBucketId;
        this.partitionValues = newPartitionValues;
        this.partitionPath = newPartitionPath;
        LOG.debug("Reset mutator: bucketId={}, partition={}, partitionPath={}", new Object[]{this.bucketId, this.partitionValues, this.partitionPath});
    }

    private boolean partitionHasChanged(List<String> newPartitionValues) {
        boolean partitionHasChanged;
        boolean bl = partitionHasChanged = !Objects.equals(this.partitionValues, newPartitionValues);
        if (partitionHasChanged) {
            LOG.debug("Partition changed from={}, to={}", this.partitionValues, newPartitionValues);
        }
        return partitionHasChanged;
    }

    private boolean bucketIdHasChanged(int newBucketId) {
        boolean bucketIdHasChanged;
        boolean bl = bucketIdHasChanged = this.bucketId != newBucketId;
        if (bucketIdHasChanged) {
            LOG.debug("Bucket ID changed from={}, to={}", (Object)this.bucketId, (Object)newBucketId);
        }
        return bucketIdHasChanged;
    }

    private void validateGrouping(List<String> newPartitionValues, int newBucketId) throws GroupRevisitedException {
        if (!this.groupingValidator.isInSequence(newPartitionValues, this.bucketId)) {
            throw new GroupRevisitedException("Group out of sequence: state=" + this.groupingValidator + ", partition=" + newPartitionValues + ", bucketId=" + newBucketId);
        }
    }

    private void validateRecordSequence(OperationType operationType, RecordIdentifier newRecordIdentifier) throws RecordSequenceException {
        boolean identiferOutOfSequence;
        boolean bl = identiferOutOfSequence = operationType != OperationType.INSERT && !this.sequenceValidator.isInSequence(newRecordIdentifier);
        if (identiferOutOfSequence) {
            throw new RecordSequenceException("Records not in sequence: state=" + this.sequenceValidator + ", recordIdentifier=" + newRecordIdentifier);
        }
    }

    private AcidOutputFormat<?, ?> createOutputFormat(String outputFormatName, HiveConf configuration) throws WorkerException {
        try {
            return (AcidOutputFormat)ReflectionUtils.newInstance((Class)JavaUtils.loadClass((String)outputFormatName), (Configuration)configuration);
        }
        catch (ClassNotFoundException e) {
            throw new WorkerException("Could not locate class for '" + outputFormatName + "'.", e);
        }
    }

    private void deleteDeltaIfExists(Path partitionPath, long writeId, int bucketId) throws IOException {
        Path deltaPath = AcidUtils.createFilename((Path)partitionPath, (AcidOutputFormat.Options)new AcidOutputFormat.Options((Configuration)this.configuration).bucket(bucketId).minimumWriteId(writeId).maximumWriteId(writeId));
        FileSystem fileSystem = deltaPath.getFileSystem((Configuration)this.configuration);
        if (fileSystem.exists(deltaPath)) {
            LOG.info("Deleting existing delta path: {}", (Object)deltaPath);
            fileSystem.delete(deltaPath, false);
        }
    }
}

