/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.thrift.TException;
import org.junit.Assert;

public class StreamingAssert {
    private Table table;
    private List<String> partition;
    private IMetaStoreClient metaStoreClient;
    private AcidUtils.Directory dir;
    private ValidWriteIdList writeIds;
    private List<AcidUtils.ParsedDelta> currentDeltas;
    private long min;
    private long max;
    private Path partitionLocation;

    StreamingAssert(IMetaStoreClient metaStoreClient, HiveConf conf, Table table, List<String> partition) throws Exception {
        this.metaStoreClient = metaStoreClient;
        this.table = table;
        this.partition = partition;
        this.writeIds = metaStoreClient.getValidWriteIds(AcidUtils.getFullTableName((String)table.getDbName(), (String)table.getTableName()));
        this.partitionLocation = this.getPartitionLocation();
        this.dir = AcidUtils.getAcidState((Path)this.partitionLocation, (Configuration)conf, (ValidWriteIdList)this.writeIds);
        Assert.assertEquals((long)0L, (long)this.dir.getObsolete().size());
        Assert.assertEquals((long)0L, (long)this.dir.getOriginalFiles().size());
        this.currentDeltas = this.dir.getCurrentDirectories();
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        System.out.println("Files found: ");
        for (AcidUtils.ParsedDelta parsedDelta : this.currentDeltas) {
            System.out.println(parsedDelta.getPath().toString());
            this.max = Math.max(parsedDelta.getMaxWriteId(), this.max);
            this.min = Math.min(parsedDelta.getMinWriteId(), this.min);
        }
    }

    public void assertExpectedFileCount(int expectedFileCount) {
        Assert.assertEquals((long)expectedFileCount, (long)this.currentDeltas.size());
    }

    public void assertNothingWritten() {
        this.assertExpectedFileCount(0);
    }

    public void assertMinWriteId(long expectedMinWriteId) {
        if (this.currentDeltas.isEmpty()) {
            throw new AssertionError((Object)"No data");
        }
        Assert.assertEquals((long)expectedMinWriteId, (long)this.min);
    }

    public void assertMaxWriteId(long expectedMaxWriteId) {
        if (this.currentDeltas.isEmpty()) {
            throw new AssertionError((Object)"No data");
        }
        Assert.assertEquals((long)expectedMaxWriteId, (long)this.max);
    }

    List<Record> readRecords() throws Exception {
        return this.readRecords(1);
    }

    List<Record> readRecords(int numSplitsExpected) throws Exception {
        if (this.currentDeltas.isEmpty()) {
            throw new AssertionError((Object)"No data");
        }
        OrcInputFormat inputFormat = new OrcInputFormat();
        JobConf job = new JobConf();
        job.set("mapred.input.dir", this.partitionLocation.toString());
        job.set("bucket_count", Integer.toString(this.table.getSd().getNumBuckets()));
        job.set("schema.evolution.columns", "id,msg");
        job.set("schema.evolution.columns.types", "bigint:string");
        AcidUtils.setAcidOperationalProperties((Configuration)job, (boolean)true, null);
        job.setBoolean("transactional", true);
        job.set("hive.txn.valid.writeids", this.writeIds.toString());
        InputSplit[] splits = inputFormat.getSplits(job, 1);
        Assert.assertEquals((long)numSplitsExpected, (long)splits.length);
        ArrayList<Record> records = new ArrayList<Record>();
        for (InputSplit is : splits) {
            AcidInputFormat.AcidRecordReader recordReader = (AcidInputFormat.AcidRecordReader)inputFormat.getRecordReader(is, job, Reporter.NULL);
            NullWritable key = (NullWritable)recordReader.createKey();
            OrcStruct value = (OrcStruct)recordReader.createValue();
            while (recordReader.next((Object)key, (Object)value)) {
                RecordIdentifier recordIdentifier = recordReader.getRecordIdentifier();
                Record record = new Record(new RecordIdentifier(recordIdentifier.getWriteId(), recordIdentifier.getBucketProperty(), recordIdentifier.getRowId()), value.toString());
                System.out.println(record);
                records.add(record);
            }
            recordReader.close();
        }
        return records;
    }

    private Path getPartitionLocation() throws NoSuchObjectException, MetaException, TException {
        Path partitionLocacation;
        if (this.partition.isEmpty()) {
            partitionLocacation = new Path(this.table.getSd().getLocation());
        } else {
            List partitionEntries = this.metaStoreClient.listPartitions(this.table.getDbName(), this.table.getTableName(), this.partition, (short)1);
            partitionLocacation = new Path(((Partition)partitionEntries.get(0)).getSd().getLocation());
        }
        return partitionLocacation;
    }

    public static class Record {
        private RecordIdentifier recordIdentifier;
        private String row;

        Record(RecordIdentifier recordIdentifier, String row) {
            this.recordIdentifier = recordIdentifier;
            this.row = row;
        }

        public RecordIdentifier getRecordIdentifier() {
            return this.recordIdentifier;
        }

        public String getRow() {
            return this.row;
        }

        public String toString() {
            return "Record [recordIdentifier=" + this.recordIdentifier + ", row=" + this.row + "]";
        }
    }

    public static class Factory {
        private IMetaStoreClient metaStoreClient;
        private final HiveConf conf;

        public Factory(IMetaStoreClient metaStoreClient, HiveConf conf) {
            this.metaStoreClient = metaStoreClient;
            this.conf = conf;
        }

        public StreamingAssert newStreamingAssert(Table table) throws Exception {
            return this.newStreamingAssert(table, Collections.emptyList());
        }

        public StreamingAssert newStreamingAssert(Table table, List<String> partition) throws Exception {
            return new StreamingAssert(this.metaStoreClient, this.conf, table, partition);
        }
    }
}

