/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hive.hcatalog.streaming.mutate.MutableRecord;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolverImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestBucketIdResolverImpl {
    private static final int TOTAL_BUCKETS = 12;
    private static final int RECORD_ID_COLUMN = 2;
    private static final int[] BUCKET_COLUMN_INDEXES = new int[]{0};
    private BucketIdResolver capturingBucketIdResolver = new BucketIdResolverImpl(ObjectInspectorFactory.getReflectionObjectInspector(MutableRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA), 2, 12, BUCKET_COLUMN_INDEXES);

    @Test
    public void testAttachBucketIdToRecord() {
        MutableRecord record = new MutableRecord(1, "hello");
        this.capturingBucketIdResolver.attachBucketIdToRecord((Object)record);
        Assert.assertThat((Object)record.rowId, (Matcher)CoreMatchers.is((Object)new RecordIdentifier(-1L, BucketCodec.V1.encode(new AcidOutputFormat.Options(null).bucket(1)), -1L)));
        Assert.assertThat((Object)record.id, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)record.msg.toString(), (Matcher)CoreMatchers.is((Object)"hello"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoBucketColumns() {
        new BucketIdResolverImpl(ObjectInspectorFactory.getReflectionObjectInspector(MutableRecord.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA), 2, 12, new int[0]);
    }
}

