/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.WarehousePartitionHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestWarehousePartitionHelper {
    private static final HiveConf CONFIGURATION = new HiveConf();
    private static final Path TABLE_PATH = new Path("table");
    private static final List<String> UNPARTITIONED_COLUMNS = Collections.emptyList();
    private static final List<String> UNPARTITIONED_VALUES = Collections.emptyList();
    private static final List<String> PARTITIONED_COLUMNS = Arrays.asList("A", "B");
    private static final List<String> PARTITIONED_VALUES = Arrays.asList("1", "2");
    private final PartitionHelper unpartitionedHelper = new WarehousePartitionHelper((Configuration)CONFIGURATION, TABLE_PATH, UNPARTITIONED_COLUMNS);
    private final PartitionHelper partitionedHelper = new WarehousePartitionHelper((Configuration)CONFIGURATION, TABLE_PATH, PARTITIONED_COLUMNS);

    @Test(expected=UnsupportedOperationException.class)
    public void createNotSupported() throws Exception {
        this.unpartitionedHelper.createPartitionIfNotExists(UNPARTITIONED_VALUES);
    }

    @Test
    public void getPathForUnpartitionedTable() throws Exception {
        Path path = this.unpartitionedHelper.getPathForPartition(UNPARTITIONED_VALUES);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)TABLE_PATH));
    }

    @Test
    public void getPathForPartitionedTable() throws Exception {
        Path path = this.partitionedHelper.getPathForPartition(PARTITIONED_VALUES);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)new Path(TABLE_PATH, "A=1/B=2")));
    }

    @Test
    public void closeSucceeds() throws IOException {
        this.partitionedHelper.close();
        this.unpartitionedHelper.close();
    }
}

