/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.thrift.TException;

public class StreamingTestUtils {
    public HiveConf newHiveConf(String metaStoreUri) {
        HiveConf conf = new HiveConf(this.getClass());
        conf.set("fs.default.name", "file:///");
        conf.set("fs.raw.impl", RawFileSystem.class.getName());
        if (metaStoreUri != null) {
            conf.setVar(HiveConf.ConfVars.METASTOREURIS, metaStoreUri);
        }
        conf.setBoolVar(HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        return conf;
    }

    public void prepareTransactionDatabase(HiveConf conf) throws Exception {
        TxnDbUtil.setConfValues((HiveConf)conf);
        TxnDbUtil.cleanDb((HiveConf)conf);
        TxnDbUtil.prepDb((HiveConf)conf);
    }

    public IMetaStoreClient newMetaStoreClient(HiveConf conf) throws Exception {
        return new HiveMetaStoreClient(conf);
    }

    public static DatabaseBuilder databaseBuilder(File warehouseFolder) {
        return new DatabaseBuilder(warehouseFolder);
    }

    public static TableBuilder tableBuilder(Database database) {
        return new TableBuilder(database);
    }

    public static class TableBuilder {
        private Table table;
        private StorageDescriptor sd;
        private SerDeInfo serDeInfo;
        private Database database;
        private List<List<String>> partitions;
        private List<String> columnNames;
        private List<String> columnTypes;
        private List<String> partitionKeys;

        public TableBuilder(Database database) {
            this.database = database;
            this.partitions = new ArrayList<List<String>>();
            this.columnNames = new ArrayList<String>();
            this.columnTypes = new ArrayList<String>();
            this.partitionKeys = Collections.emptyList();
            this.table = new Table();
            this.table.setDbName(database.getName());
            this.table.setTableType(TableType.MANAGED_TABLE.toString());
            HashMap<String, String> tableParams = new HashMap<String, String>();
            tableParams.put("transactional", Boolean.TRUE.toString());
            this.table.setParameters(tableParams);
            this.sd = new StorageDescriptor();
            this.sd.setInputFormat(OrcInputFormat.class.getName());
            this.sd.setOutputFormat(OrcOutputFormat.class.getName());
            this.sd.setNumBuckets(1);
            this.table.setSd(this.sd);
            this.serDeInfo = new SerDeInfo();
            this.serDeInfo.setParameters(new HashMap());
            this.serDeInfo.getParameters().put("serialization.format", "1");
            this.serDeInfo.setSerializationLib(OrcSerde.class.getName());
            this.sd.setSerdeInfo(this.serDeInfo);
        }

        public TableBuilder name(String name) {
            this.sd.setLocation(this.database.getLocationUri() + "/" + name);
            this.table.setTableName(name);
            this.serDeInfo.setName(name);
            return this;
        }

        public TableBuilder buckets(int buckets) {
            this.sd.setNumBuckets(buckets);
            return this;
        }

        public TableBuilder bucketCols(List<String> columnNames) {
            this.sd.setBucketCols(columnNames);
            return this;
        }

        public TableBuilder addColumn(String columnName, String columnType) {
            this.columnNames.add(columnName);
            this.columnTypes.add(columnType);
            return this;
        }

        public TableBuilder partitionKeys(String ... partitionKeys) {
            this.partitionKeys = Arrays.asList(partitionKeys);
            return this;
        }

        public TableBuilder addPartition(String ... partitionValues) {
            this.partitions.add(Arrays.asList(partitionValues));
            return this;
        }

        public TableBuilder addPartition(List<String> partitionValues) {
            this.partitions.add(partitionValues);
            return this;
        }

        public Table create(IMetaStoreClient metaStoreClient) throws Exception {
            if (metaStoreClient == null) {
                throw new IllegalArgumentException();
            }
            return this.internalCreate(metaStoreClient);
        }

        public Table build() throws Exception {
            return this.internalCreate(null);
        }

        private Table internalCreate(IMetaStoreClient metaStoreClient) throws Exception {
            ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>(this.columnNames.size());
            for (int i = 0; i < this.columnNames.size(); ++i) {
                fields.add(new FieldSchema(this.columnNames.get(i), this.columnTypes.get(i), ""));
            }
            this.sd.setCols(fields);
            if (!this.partitionKeys.isEmpty()) {
                ArrayList<FieldSchema> partitionFields = new ArrayList<FieldSchema>();
                for (String partitionKey : this.partitionKeys) {
                    partitionFields.add(new FieldSchema(partitionKey, "string", ""));
                }
                this.table.setPartitionKeys(partitionFields);
            }
            if (metaStoreClient != null) {
                metaStoreClient.createTable(this.table);
            }
            for (List<String> partitionValues : this.partitions) {
                Partition partition = new Partition();
                partition.setDbName(this.database.getName());
                partition.setTableName(this.table.getTableName());
                StorageDescriptor partitionSd = new StorageDescriptor(this.table.getSd());
                partitionSd.setLocation(this.table.getSd().getLocation() + "/" + Warehouse.makePartName((List)this.table.getPartitionKeys(), partitionValues));
                partition.setSd(partitionSd);
                partition.setValues(partitionValues);
                if (metaStoreClient == null) continue;
                metaStoreClient.add_partition(partition);
            }
            return this.table;
        }
    }

    public static class DatabaseBuilder {
        private Database database;
        private File warehouseFolder;

        public DatabaseBuilder(File warehouseFolder) {
            this.warehouseFolder = warehouseFolder;
            this.database = new Database();
        }

        public DatabaseBuilder name(String name) {
            this.database.setName(name);
            File databaseFolder = new File(this.warehouseFolder, name + ".db");
            String databaseLocation = "raw://" + databaseFolder.toURI().getPath();
            this.database.setLocationUri(databaseLocation);
            return this;
        }

        public Database dropAndCreate(IMetaStoreClient metaStoreClient) throws Exception {
            if (metaStoreClient == null) {
                throw new IllegalArgumentException();
            }
            try {
                for (String table : metaStoreClient.listTableNamesByFilter(this.database.getName(), "", (short)-1)) {
                    metaStoreClient.dropTable(this.database.getName(), table, true, true);
                }
                metaStoreClient.dropDatabase(this.database.getName());
            }
            catch (TException tException) {
                // empty catch block
            }
            metaStoreClient.createDatabase(this.database);
            return this.database;
        }

        public Database build() {
            return this.database;
        }
    }

    public static class RawFileSystem
    extends RawLocalFileSystem {
        private static final URI NAME;

        public URI getUri() {
            return NAME;
        }

        public FileStatus getFileStatus(Path path) throws IOException {
            File file = this.pathToFile(path);
            if (!file.exists()) {
                throw new FileNotFoundException("Can't find " + path);
            }
            short mod = 0;
            if (file.canRead()) {
                mod = (short)(mod | 0x124);
            }
            if (file.canWrite()) {
                mod = (short)(mod | 0x80);
            }
            if (file.canExecute()) {
                mod = (short)(mod | 0x49);
            }
            return new FileStatus(file.length(), file.isDirectory(), 1, 1024L, file.lastModified(), file.lastModified(), FsPermission.createImmutable((short)mod), "owen", "users", path);
        }

        static {
            try {
                NAME = new URI("raw:///");
            }
            catch (URISyntaxException se) {
                throw new IllegalArgumentException("bad uri", se);
            }
        }
    }
}

