/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.mutate.MutableRecord;
import org.apache.hive.hcatalog.streaming.mutate.ReflectiveMutatorFactory;
import org.apache.hive.hcatalog.streaming.mutate.StreamingAssert;
import org.apache.hive.hcatalog.streaming.mutate.StreamingTestUtils;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClient;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClientBuilder;
import org.apache.hive.hcatalog.streaming.mutate.client.Transaction;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinatorBuilder;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMutations {
    private static final List<String> EUROPE_FRANCE = Arrays.asList("Europe", "France");
    private static final List<String> EUROPE_UK = Arrays.asList("Europe", "UK");
    private static final List<String> ASIA_INDIA = Arrays.asList("Asia", "India");
    private static final int[] BUCKET_COLUMN_INDEXES = new int[]{0};
    private static final int RECORD_ID_COLUMN = 2;
    @Rule
    public TemporaryFolder warehouseFolder = new TemporaryFolder();
    private StreamingTestUtils testUtils = new StreamingTestUtils();
    private HiveConf conf = this.testUtils.newHiveConf(this.metaStoreUri);
    private IMetaStoreClient metaStoreClient;
    private String metaStoreUri;
    private Database database;
    private StreamingTestUtils.TableBuilder partitionedTableBuilder;
    private StreamingTestUtils.TableBuilder unpartitionedTableBuilder;
    private StreamingAssert.Factory assertionFactory;

    public TestMutations() throws Exception {
        this.testUtils.prepareTransactionDatabase(this.conf);
        this.metaStoreClient = this.testUtils.newMetaStoreClient(this.conf);
        this.assertionFactory = new StreamingAssert.Factory(this.metaStoreClient, this.conf);
    }

    @Before
    public void setup() throws Exception {
        this.database = StreamingTestUtils.databaseBuilder(this.warehouseFolder.getRoot()).name("testing").dropAndCreate(this.metaStoreClient);
        this.partitionedTableBuilder = StreamingTestUtils.tableBuilder(this.database).name("partitioned").addColumn("id", "int").addColumn("msg", "string").partitionKeys("continent", "country").bucketCols(Collections.singletonList("string"));
        this.unpartitionedTableBuilder = StreamingTestUtils.tableBuilder(this.database).name("unpartitioned").addColumn("id", "int").addColumn("msg", "string").bucketCols(Collections.singletonList("string"));
    }

    @Test
    public void testTransactionBatchEmptyCommitPartitioned() throws Exception {
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        transaction.begin();
        transaction.commit();
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        client.close();
    }

    @Test
    public void testTransactionBatchEmptyCommitUnpartitioned() throws Exception {
        Table table = this.unpartitionedTableBuilder.create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), false).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        transaction.begin();
        transaction.commit();
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        client.close();
    }

    @Test
    public void testTransactionBatchEmptyAbortPartitioned() throws Exception {
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        coordinator.close();
        transaction.abort();
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.ABORTED));
        client.close();
    }

    @Test
    public void testTransactionBatchEmptyAbortUnartitioned() throws Exception {
        Table table = this.unpartitionedTableBuilder.create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), false).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        coordinator.close();
        transaction.abort();
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.ABORTED));
        client.close();
    }

    @Test
    public void testTransactionBatchCommitPartitioned() throws Exception {
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        BucketIdResolver bucketIdAppender = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord record = (MutableRecord)bucketIdAppender.attachBucketIdToRecord((Object)new MutableRecord(1, "Hello streaming"));
        coordinator.insert(ASIA_INDIA, (Object)record);
        coordinator.close();
        transaction.commit();
        StreamingAssert streamingAssertions = this.assertionFactory.newStreamingAssert(table, ASIA_INDIA);
        streamingAssertions.assertMinTransactionId(1L);
        streamingAssertions.assertMaxTransactionId(1L);
        streamingAssertions.assertExpectedFileCount(1);
        List<StreamingAssert.Record> readRecords = streamingAssertions.readRecords();
        Assert.assertThat((Object)readRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)readRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{1, Hello streaming}"));
        Assert.assertThat((Object)readRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        client.close();
    }

    @Test
    public void testMulti() throws Exception {
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        BucketIdResolver bucketIdResolver = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord asiaIndiaRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(1, "Hello streaming"));
        MutableRecord europeUkRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(2, "Hello streaming"));
        MutableRecord europeFranceRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(3, "Hello streaming"));
        MutableRecord europeFranceRecord2 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(4, "Bonjour streaming"));
        coordinator.insert(ASIA_INDIA, (Object)asiaIndiaRecord1);
        coordinator.insert(EUROPE_UK, (Object)europeUkRecord1);
        coordinator.insert(EUROPE_FRANCE, (Object)europeFranceRecord1);
        coordinator.insert(EUROPE_FRANCE, (Object)europeFranceRecord2);
        coordinator.close();
        transaction.commit();
        StreamingAssert streamingAssertions = this.assertionFactory.newStreamingAssert(table, ASIA_INDIA);
        streamingAssertions.assertMinTransactionId(1L);
        streamingAssertions.assertMaxTransactionId(1L);
        streamingAssertions.assertExpectedFileCount(1);
        List<StreamingAssert.Record> readRecords = streamingAssertions.readRecords();
        Assert.assertThat((Object)readRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)readRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{1, Hello streaming}"));
        Assert.assertThat((Object)readRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        streamingAssertions = this.assertionFactory.newStreamingAssert(table, EUROPE_UK);
        streamingAssertions.assertMinTransactionId(1L);
        streamingAssertions.assertMaxTransactionId(1L);
        streamingAssertions.assertExpectedFileCount(1);
        readRecords = streamingAssertions.readRecords();
        Assert.assertThat((Object)readRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)readRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{2, Hello streaming}"));
        Assert.assertThat((Object)readRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        streamingAssertions = this.assertionFactory.newStreamingAssert(table, EUROPE_FRANCE);
        streamingAssertions.assertMinTransactionId(1L);
        streamingAssertions.assertMaxTransactionId(1L);
        streamingAssertions.assertExpectedFileCount(1);
        readRecords = streamingAssertions.readRecords();
        Assert.assertThat((Object)readRecords.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)readRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{3, Hello streaming}"));
        Assert.assertThat((Object)readRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        Assert.assertThat((Object)readRecords.get(1).getRow(), (Matcher)CoreMatchers.is((Object)"{4, Bonjour streaming}"));
        Assert.assertThat((Object)readRecords.get(1).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 1L)));
        client.close();
    }

    @Test
    public void testTransactionBatchCommitUnpartitioned() throws Exception {
        Table table = this.unpartitionedTableBuilder.create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), false).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        BucketIdResolver bucketIdResolver = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord record = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(1, "Hello streaming"));
        coordinator.insert(Collections.emptyList(), (Object)record);
        coordinator.close();
        transaction.commit();
        StreamingAssert streamingAssertions = this.assertionFactory.newStreamingAssert(table);
        streamingAssertions.assertMinTransactionId(1L);
        streamingAssertions.assertMaxTransactionId(1L);
        streamingAssertions.assertExpectedFileCount(1);
        List<StreamingAssert.Record> readRecords = streamingAssertions.readRecords();
        Assert.assertThat((Object)readRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)readRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{1, Hello streaming}"));
        Assert.assertThat((Object)readRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        client.close();
    }

    @Test
    public void testTransactionBatchAbort() throws Exception {
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction transaction = client.newTransaction();
        List destinations = client.getTables();
        transaction.begin();
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        BucketIdResolver bucketIdResolver = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord record1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(1, "Hello streaming"));
        MutableRecord record2 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(2, "Welcome to streaming"));
        coordinator.insert(ASIA_INDIA, (Object)record1);
        coordinator.insert(ASIA_INDIA, (Object)record2);
        coordinator.close();
        transaction.abort();
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.ABORTED));
        client.close();
        StreamingAssert streamingAssertions = this.assertionFactory.newStreamingAssert(table, ASIA_INDIA);
        streamingAssertions.assertNothingWritten();
    }

    @Test
    public void testUpdatesAndDeletes() throws Exception {
        ReflectiveMutatorFactory mutatorFactory = new ReflectiveMutatorFactory((Configuration)this.conf, MutableRecord.class, 2, BUCKET_COLUMN_INDEXES);
        Table table = this.partitionedTableBuilder.addPartition(ASIA_INDIA).addPartition(EUROPE_FRANCE).create(this.metaStoreClient);
        MutatorClient client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction insertTransaction = client.newTransaction();
        List destinations = client.getTables();
        insertTransaction.begin();
        MutatorCoordinator insertCoordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        BucketIdResolver bucketIdResolver = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord asiaIndiaRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(1, "Namaste streaming 1"));
        MutableRecord asiaIndiaRecord2 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(2, "Namaste streaming 2"));
        MutableRecord europeUkRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(3, "Hello streaming 1"));
        MutableRecord europeUkRecord2 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(4, "Hello streaming 2"));
        MutableRecord europeFranceRecord1 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(5, "Bonjour streaming 1"));
        MutableRecord europeFranceRecord2 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(6, "Bonjour streaming 2"));
        insertCoordinator.insert(ASIA_INDIA, (Object)asiaIndiaRecord1);
        insertCoordinator.insert(ASIA_INDIA, (Object)asiaIndiaRecord2);
        insertCoordinator.insert(EUROPE_UK, (Object)europeUkRecord1);
        insertCoordinator.insert(EUROPE_UK, (Object)europeUkRecord2);
        insertCoordinator.insert(EUROPE_FRANCE, (Object)europeFranceRecord1);
        insertCoordinator.insert(EUROPE_FRANCE, (Object)europeFranceRecord2);
        insertCoordinator.close();
        insertTransaction.commit();
        Assert.assertThat((Object)insertTransaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        client.close();
        client = new MutatorClientBuilder().addSinkTable(table.getDbName(), table.getTableName(), true).metaStoreUri(this.metaStoreUri).build();
        client.connect();
        Transaction mutateTransaction = client.newTransaction();
        destinations = client.getTables();
        mutateTransaction.begin();
        MutatorCoordinator mutateCoordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)destinations.get(0)).mutatorFactory((MutatorFactory)mutatorFactory).build();
        bucketIdResolver = mutatorFactory.newBucketIdResolver(((AcidTable)destinations.get(0)).getTotalBuckets());
        MutableRecord asiaIndiaRecord3 = (MutableRecord)bucketIdResolver.attachBucketIdToRecord((Object)new MutableRecord(20, "Namaste streaming 3"));
        mutateCoordinator.update(ASIA_INDIA, (Object)new MutableRecord(2, "UPDATED: Namaste streaming 2", new RecordIdentifier(1L, 0, 1L)));
        mutateCoordinator.insert(ASIA_INDIA, (Object)asiaIndiaRecord3);
        mutateCoordinator.delete(EUROPE_UK, (Object)new MutableRecord(3, "Hello streaming 1", new RecordIdentifier(1L, 0, 0L)));
        mutateCoordinator.delete(EUROPE_FRANCE, (Object)new MutableRecord(5, "Bonjour streaming 1", new RecordIdentifier(1L, 0, 0L)));
        mutateCoordinator.update(EUROPE_FRANCE, (Object)new MutableRecord(6, "UPDATED: Bonjour streaming 2", new RecordIdentifier(1L, 0, 1L)));
        mutateCoordinator.close();
        mutateTransaction.commit();
        Assert.assertThat((Object)mutateTransaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.COMMITTED));
        StreamingAssert indiaAssertions = this.assertionFactory.newStreamingAssert(table, ASIA_INDIA);
        indiaAssertions.assertMinTransactionId(1L);
        indiaAssertions.assertMaxTransactionId(2L);
        List<StreamingAssert.Record> indiaRecords = indiaAssertions.readRecords();
        Assert.assertThat((Object)indiaRecords.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)indiaRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{1, Namaste streaming 1}"));
        Assert.assertThat((Object)indiaRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 0L)));
        Assert.assertThat((Object)indiaRecords.get(1).getRow(), (Matcher)CoreMatchers.is((Object)"{2, UPDATED: Namaste streaming 2}"));
        Assert.assertThat((Object)indiaRecords.get(1).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 1L)));
        Assert.assertThat((Object)indiaRecords.get(2).getRow(), (Matcher)CoreMatchers.is((Object)"{20, Namaste streaming 3}"));
        Assert.assertThat((Object)indiaRecords.get(2).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(2L, 0, 0L)));
        StreamingAssert ukAssertions = this.assertionFactory.newStreamingAssert(table, EUROPE_UK);
        ukAssertions.assertMinTransactionId(1L);
        ukAssertions.assertMaxTransactionId(2L);
        List<StreamingAssert.Record> ukRecords = ukAssertions.readRecords();
        Assert.assertThat((Object)ukRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)ukRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{4, Hello streaming 2}"));
        Assert.assertThat((Object)ukRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 1L)));
        StreamingAssert franceAssertions = this.assertionFactory.newStreamingAssert(table, EUROPE_FRANCE);
        franceAssertions.assertMinTransactionId(1L);
        franceAssertions.assertMaxTransactionId(2L);
        List<StreamingAssert.Record> franceRecords = franceAssertions.readRecords();
        Assert.assertThat((Object)franceRecords.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)franceRecords.get(0).getRow(), (Matcher)CoreMatchers.is((Object)"{6, UPDATED: Bonjour streaming 2}"));
        Assert.assertThat((Object)franceRecords.get(0).getRecordIdentifier(), (Matcher)CoreMatchers.is((Object)new RecordIdentifier(1L, 0, 1L)));
        client.close();
    }
}

