/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolverImpl;
import org.apache.hive.hcatalog.streaming.mutate.worker.Mutator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorImpl;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordInspectorImpl;

public class ReflectiveMutatorFactory
implements MutatorFactory {
    private final int recordIdColumn;
    private final ObjectInspector objectInspector;
    private final Configuration configuration;
    private final int[] bucketColumnIndexes;

    public ReflectiveMutatorFactory(Configuration configuration, Class<?> recordClass, int recordIdColumn, int[] bucketColumnIndexes) {
        this.configuration = configuration;
        this.recordIdColumn = recordIdColumn;
        this.bucketColumnIndexes = bucketColumnIndexes;
        this.objectInspector = ObjectInspectorFactory.getReflectionObjectInspector(recordClass, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    public Mutator newMutator(AcidOutputFormat<?, ?> outputFormat, long transactionId, Path partitionPath, int bucketId) throws IOException {
        return new MutatorImpl(this.configuration, this.recordIdColumn, this.objectInspector, outputFormat, transactionId, partitionPath, bucketId);
    }

    public RecordInspector newRecordInspector() {
        return new RecordInspectorImpl(this.objectInspector, this.recordIdColumn);
    }

    public BucketIdResolver newBucketIdResolver(int totalBuckets) {
        return new BucketIdResolverImpl(this.objectInspector, this.recordIdColumn, totalBuckets, this.bucketColumnIndexes);
    }
}

