/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;
import org.apache.hive.hcatalog.messaging.AlterPartitionMessage;
import org.apache.hive.hcatalog.messaging.AlterTableMessage;
import org.apache.hive.hcatalog.messaging.CreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.CreateFunctionMessage;
import org.apache.hive.hcatalog.messaging.CreateTableMessage;
import org.apache.hive.hcatalog.messaging.DropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.DropFunctionMessage;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;
import org.apache.hive.hcatalog.messaging.DropTableMessage;
import org.apache.hive.hcatalog.messaging.HCatEventMessage;
import org.apache.hive.hcatalog.messaging.InsertMessage;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class MessageDeserializer {
    public HCatEventMessage getHCatEventMessage(String eventTypeString, String messageBody) {
        switch (HCatEventMessage.EventType.valueOf(eventTypeString)) {
            case CREATE_DATABASE: {
                return this.getCreateDatabaseMessage(messageBody);
            }
            case DROP_DATABASE: {
                return this.getDropDatabaseMessage(messageBody);
            }
            case CREATE_TABLE: {
                return this.getCreateTableMessage(messageBody);
            }
            case ALTER_TABLE: {
                return this.getAlterTableMessage(messageBody);
            }
            case DROP_TABLE: {
                return this.getDropTableMessage(messageBody);
            }
            case ADD_PARTITION: {
                return this.getAddPartitionMessage(messageBody);
            }
            case ALTER_PARTITION: {
                return this.getAlterPartitionMessage(messageBody);
            }
            case DROP_PARTITION: {
                return this.getDropPartitionMessage(messageBody);
            }
            case CREATE_FUNCTION: {
                return this.getCreateFunctionMessage(messageBody);
            }
            case DROP_FUNCTION: {
                return this.getDropFunctionMessage(messageBody);
            }
            case INSERT: {
                return this.getInsertMessage(messageBody);
            }
        }
        throw new IllegalArgumentException("Unsupported event-type: " + eventTypeString);
    }

    public abstract CreateDatabaseMessage getCreateDatabaseMessage(String var1);

    public abstract DropDatabaseMessage getDropDatabaseMessage(String var1);

    public abstract CreateTableMessage getCreateTableMessage(String var1);

    public abstract AlterTableMessage getAlterTableMessage(String var1);

    public abstract DropTableMessage getDropTableMessage(String var1);

    public abstract AddPartitionMessage getAddPartitionMessage(String var1);

    public abstract AlterPartitionMessage getAlterPartitionMessage(String var1);

    public abstract DropPartitionMessage getDropPartitionMessage(String var1);

    public abstract CreateFunctionMessage getCreateFunctionMessage(String var1);

    public abstract DropFunctionMessage getDropFunctionMessage(String var1);

    public abstract InsertMessage getInsertMessage(String var1);

    protected MessageDeserializer() {
    }
}

