/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.pig;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.pig.HCatBaseStorer;
import org.apache.hive.hcatalog.pig.PigHCatUtil;
import org.apache.pig.PigException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HCatStorer
extends HCatBaseStorer {
    private static final Logger LOG = LoggerFactory.getLogger(HCatStorer.class);
    public static final String INNER_SIGNATURE = "hcatstorer.inner.signature";
    public static final String INNER_SIGNATURE_PREFIX = "hcatstorer_inner_signature";
    private static Map<String, Credentials> jobCredentials = new HashMap<String, Credentials>();
    private static final Options validOptions = new Options();
    private static final CommandLineParser parser;

    public HCatStorer(String partSpecs, String pigSchema, String optString) throws Exception {
        super(partSpecs, pigSchema);
        CommandLine configuredOptions;
        String[] optsArr = optString.split(" ");
        try {
            configuredOptions = parser.parse(validOptions, optsArr);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("[-onOutOfRangeValue]", validOptions);
            throw e;
        }
        Properties udfProps = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign});
        udfProps.put("hcat.pig.store.onoutofrangevalue", configuredOptions.getOptionValue("onOutOfRangeValue", HCatStorer.getDefaultValue().name()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting " + configuredOptions.getOptionValue("onOutOfRangeValue"));
        }
        HCatStorer.isValidOOROption((String)udfProps.get("hcat.pig.store.onoutofrangevalue"));
    }

    public HCatStorer(String partSpecs, String pigSchema) throws Exception {
        this(partSpecs, pigSchema, "");
    }

    public HCatStorer(String partSpecs) throws Exception {
        this(partSpecs, null, "");
    }

    public HCatStorer() throws Exception {
        this(null, null, "");
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new HCatOutputFormat();
    }

    private static void populateValidOptions() {
        validOptions.addOption("onOutOfRangeValue", true, "Controls how store operation handles Pig values which are out of range for the target columnin Hive table.  Default is to throw an exception.");
    }

    private static void isValidOOROption(String optVal) throws FrontendException {
        boolean found = false;
        for (HCatBaseStorer.OOR_VALUE_OPT_VALUES v : HCatBaseStorer.OOR_VALUE_OPT_VALUES.values()) {
            if (!v.name().equalsIgnoreCase(optVal)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new FrontendException("Unexpected value for 'onOutOfRangeValue' found: " + optVal);
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration config = job.getConfiguration();
        config.set(INNER_SIGNATURE, "hcatstorer_inner_signature_" + this.sign);
        Properties udfProps = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.sign});
        String[] userStr = location.split("\\.");
        if (udfProps.containsKey("hcat.pig.storer.location.set")) {
            Enumeration<Object> emr = udfProps.keys();
            while (emr.hasMoreElements()) {
                PigHCatUtil.getConfigFromUDFProperties(udfProps, config, emr.nextElement().toString());
            }
            Credentials crd = jobCredentials.get("hcatstorer_inner_signature_" + this.sign);
            if (crd != null) {
                job.getCredentials().addAll(crd);
            }
        } else {
            OutputJobInfo outputJobInfo;
            Job clone = new Job(job.getConfiguration());
            if (userStr.length == 2) {
                outputJobInfo = OutputJobInfo.create((String)userStr[0], (String)userStr[1], (Map)this.partitions);
            } else if (userStr.length == 1) {
                outputJobInfo = OutputJobInfo.create(null, (String)userStr[0], (Map)this.partitions);
            } else {
                throw new FrontendException("location " + location + " is invalid. It must be of the form [db.]table", 1115);
            }
            Schema schema = (Schema)ObjectSerializer.deserialize((String)udfProps.getProperty("hcat.pig.store.schema"));
            if (schema != null) {
                this.pigSchema = schema;
            }
            if (this.pigSchema == null) {
                throw new FrontendException("Schema for data cannot be determined.", 1115);
            }
            String externalLocation = udfProps.getProperty("hcat.pig.storer.external.location");
            if (externalLocation != null) {
                outputJobInfo.setLocation(externalLocation);
            }
            try {
                HCatOutputFormat.setOutput((Job)job, (OutputJobInfo)outputJobInfo);
            }
            catch (HCatException he) {
                throw new PigException(he.getMessage(), 1115, (Throwable)he);
            }
            HCatSchema hcatTblSchema = HCatOutputFormat.getTableSchema((Configuration)job.getConfiguration());
            try {
                this.doSchemaValidations(this.pigSchema, hcatTblSchema);
            }
            catch (HCatException he) {
                throw new FrontendException(he.getMessage(), 1115, (Throwable)he);
            }
            this.computedSchema = this.convertPigSchemaToHCatSchema(this.pigSchema, hcatTblSchema);
            HCatOutputFormat.setSchema((Job)job, (HCatSchema)this.computedSchema);
            udfProps.setProperty("hcat.output.schema", ObjectSerializer.serialize((Serializable)this.computedSchema));
            for (Map.Entry keyValue : job.getConfiguration()) {
                String oldValue = clone.getConfiguration().getRaw((String)keyValue.getKey());
                if (oldValue != null && ((String)keyValue.getValue()).equals(oldValue)) continue;
                udfProps.put(keyValue.getKey(), keyValue.getValue());
            }
            jobCredentials.put("hcatstorer_inner_signature_" + this.sign, job.getCredentials());
            udfProps.put("hcat.pig.storer.location.set", (Object)true);
        }
    }

    public void storeSchema(ResourceSchema schema, String arg1, Job job) throws IOException {
        ShimLoader.getHadoopShims().getHCatShim().commitJob(this.getOutputFormat(), job);
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        ShimLoader.getHadoopShims().getHCatShim().abortJob(this.getOutputFormat(), job);
    }

    static {
        try {
            HCatStorer.populateValidOptions();
        }
        catch (Throwable t) {
            LOG.error("Failed to build option list: ", t);
            throw new RuntimeException(t);
        }
        parser = new GnuParser();
    }
}

