/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;

public class THBaseThreadPoolExecutor
extends ThreadPoolExecutor {
    private ThriftMetrics metrics;

    public THBaseThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThriftMetrics metrics) {
        this(corePoolSize, maxPoolSize, keepAliveTime, unit, workQueue, null, metrics);
    }

    public THBaseThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, ThriftMetrics metrics) {
        super(corePoolSize, maxPoolSize, keepAliveTime, unit, workQueue);
        if (threadFactory != null) {
            this.setThreadFactory(threadFactory);
        }
        this.metrics = metrics;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.metrics.incActiveWorkerCount();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.metrics.decActiveWorkerCount();
        super.afterExecute(r, t);
    }
}

