/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.File;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.thrift.TestThriftHttpServer;
import org.apache.hadoop.hbase.thrift.TestThriftServer;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.JaasKrbUtil;
import org.apache.kerby.kerberos.kerb.server.SimpleKdcServer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestThriftSpnegoHttpServer
extends TestThriftHttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(TestThriftSpnegoHttpServer.class);
    private static SimpleKdcServer kdc;
    private static File serverKeytab;
    private static File spnegoServerKeytab;
    private static File clientKeytab;
    private static String clientPrincipal;
    private static String serverPrincipal;
    private static String spnegoServerPrincipal;

    private static void setupUser(SimpleKdcServer kdc, File keytab, String principal) throws KrbException {
        kdc.createPrincipal(principal);
        kdc.exportPrincipal(principal, keytab);
    }

    private static SimpleKdcServer buildMiniKdc() throws Exception {
        SimpleKdcServer kdc = new SimpleKdcServer();
        File target = new File(System.getProperty("user.dir"), "target");
        File kdcDir = new File(target, TestThriftSpnegoHttpServer.class.getSimpleName());
        if (kdcDir.exists()) {
            FileUtils.deleteDirectory((File)kdcDir);
        }
        kdcDir.mkdirs();
        kdc.setWorkDir(kdcDir);
        kdc.setKdcHost("localhost");
        int kdcPort = HBaseTestingUtility.randomFreePort();
        kdc.setAllowTcp(true);
        kdc.setAllowUdp(false);
        kdc.setKdcTcpPort(kdcPort);
        LOG.info("Starting KDC server at localhost:" + kdcPort);
        kdc.init();
        return kdc;
    }

    private static void addSecurityConfigurations(Configuration conf) {
        KerberosName.setRules((String)"DEFAULT");
        HBaseKerberosUtils.setKeytabFileForTesting((String)serverKeytab.getAbsolutePath());
        HBaseKerberosUtils.setPrincipalForTesting((String)serverPrincipal);
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf);
        conf.set("dfs.namenode.kerberos.principal", serverPrincipal);
        conf.set("dfs.namenode.keytab.file", serverKeytab.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", serverPrincipal);
        conf.set("dfs.datanode.keytab.file", serverKeytab.getAbsolutePath());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoServerPrincipal);
        conf.set("dfs.web.authentication.kerberos.keytab", spnegoServerKeytab.getAbsolutePath());
        conf.setBoolean("ignore.secure.ports.for.testing", true);
        conf.setBoolean("hbase.thrift.support.proxyuser", true);
        conf.setBoolean("hbase.regionserver.thrift.http", true);
        conf.set("hadoop.proxyuser.hbase.hosts", "*");
        conf.set("hadoop.proxyuser.hbase.groups", "*");
        conf.set("hbase.thrift.kerberos.principal", serverPrincipal);
        conf.set("hbase.thrift.keytab.file", serverKeytab.getAbsolutePath());
        conf.set("hbase.thrift.spnego.principal", spnegoServerPrincipal);
        conf.set("hbase.thrift.spnego.keytab.file", spnegoServerKeytab.getAbsolutePath());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        File target = new File(System.getProperty("user.dir"), "target");
        Assert.assertTrue((boolean)target.exists());
        File keytabDir = new File(target, TestThriftSpnegoHttpServer.class.getSimpleName() + "_keytabs");
        if (keytabDir.exists()) {
            FileUtils.deleteDirectory((File)keytabDir);
        }
        keytabDir.mkdirs();
        kdc = TestThriftSpnegoHttpServer.buildMiniKdc();
        kdc.start();
        clientPrincipal = "client@" + kdc.getKdcConfig().getKdcRealm();
        clientKeytab = new File(keytabDir, clientPrincipal + ".keytab");
        TestThriftSpnegoHttpServer.setupUser(kdc, clientKeytab, clientPrincipal);
        serverPrincipal = "hbase/localhost@" + kdc.getKdcConfig().getKdcRealm();
        serverKeytab = new File(keytabDir, serverPrincipal.replace('/', '_') + ".keytab");
        TestThriftSpnegoHttpServer.setupUser(kdc, serverKeytab, serverPrincipal);
        spnegoServerPrincipal = "HTTP/localhost@" + kdc.getKdcConfig().getKdcRealm();
        spnegoServerKeytab = new File(keytabDir, spnegoServerPrincipal.replace('/', '_') + ".keytab");
        TestThriftSpnegoHttpServer.setupUser(kdc, spnegoServerKeytab, spnegoServerPrincipal);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.thrift.http", true);
        TEST_UTIL.getConfiguration().setBoolean("hbase.table.sanity.checks", false);
        TestThriftSpnegoHttpServer.addSecurityConfigurations(TEST_UTIL.getConfiguration());
        TestThriftHttpServer.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestThriftHttpServer.tearDownAfterClass();
        try {
            if (null != kdc) {
                kdc.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop mini KDC", (Throwable)e);
        }
    }

    void talkToThriftServer(String url, int customHeaderSize) throws Exception {
        try (CloseableHttpClient httpClient = this.createHttpClient();
             THttpClient tHttpClient = new THttpClient(url, (HttpClient)httpClient);){
            tHttpClient.open();
            if (customHeaderSize > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < customHeaderSize; ++i) {
                    sb.append("a");
                }
                tHttpClient.setCustomHeader("User-Agent", sb.toString());
            }
            TBinaryProtocol prot = new TBinaryProtocol((TTransport)tHttpClient);
            Hbase.Client client = new Hbase.Client((TProtocol)prot);
            if (!tableCreated) {
                TestThriftServer.createTestTables((Hbase.Iface)client);
                tableCreated = true;
            }
            TestThriftServer.checkTableList((Hbase.Iface)client);
        }
    }

    private CloseableHttpClient createHttpClient() throws Exception {
        Subject clientSubject = JaasKrbUtil.loginUsingKeytab((String)clientPrincipal, (File)clientKeytab);
        Set<Principal> clientPrincipals = clientSubject.getPrincipals();
        Assert.assertFalse((boolean)clientPrincipals.isEmpty());
        Set<KerberosTicket> privateCredentials = clientSubject.getPrivateCredentials(KerberosTicket.class);
        Assert.assertFalse((boolean)privateCredentials.isEmpty());
        KerberosTicket tgt = privateCredentials.iterator().next();
        Assert.assertNotNull((Object)tgt);
        final String clientPrincipalName = clientPrincipals.iterator().next().getName();
        return Subject.doAs(clientSubject, new PrivilegedExceptionAction<CloseableHttpClient>(){

            @Override
            public CloseableHttpClient run() throws Exception {
                GSSManager gssManager = GSSManager.getInstance();
                Oid oid = new Oid("1.2.840.113554.1.2.2");
                GSSName gssClient = gssManager.createName(clientPrincipalName, GSSName.NT_USER_NAME);
                GSSCredential credential = gssManager.createCredential(gssClient, 0, oid, 1);
                Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
                return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            }
        });
    }
}

