/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.spark.AvroHBaseKeyRecord;
import org.apache.hadoop.hbase.spark.AvroHBaseKeyRecord$;
import org.apache.hadoop.hbase.spark.DefaultSourceStaticUtils$;
import org.apache.hadoop.hbase.spark.DefaultSourceSuite$;
import org.apache.hadoop.hbase.spark.DynamicLogicExpression;
import org.apache.hadoop.hbase.spark.ExecutionRuleForUnitTesting;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRecord;
import org.apache.hadoop.hbase.spark.HBaseRecord$;
import org.apache.hadoop.hbase.spark.ScanRange;
import org.apache.hadoop.hbase.spark.datasources.HBaseSparkConf$;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.datasources.hbase.HBaseTableCatalog$;
import org.apache.spark.sql.functions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0010!\u0001-BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004E\u0001\u0001\u0006IA\u0010\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0011\u001da\u0005\u00011A\u0005\u00025CaA\u0016\u0001!B\u00139\u0005bB.\u0001\u0001\u0004%\t\u0001\u0018\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0011\u0019!\u0007\u0001)Q\u0005;\"9Q\r\u0001b\u0001\n\u00031\u0007BB8\u0001A\u0003%q\rC\u0004q\u0001\t\u0007I\u0011\u00014\t\rE\u0004\u0001\u0015!\u0003h\u0011\u001d\u0011\bA1A\u0005\u0002\u0019Daa\u001d\u0001!\u0002\u00139\u0007b\u0002;\u0001\u0001\u0004%\t!\u001e\u0005\by\u0002\u0001\r\u0011\"\u0001~\u0011\u0019y\b\u0001)Q\u0005m\"I\u0011\u0011\u0001\u0001A\u0002\u0013\u0005\u00111\u0001\u0005\n\u0003S\u0001\u0001\u0019!C\u0001\u0003WA\u0001\"a\f\u0001A\u0003&\u0011Q\u0001\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t)\u0004\u0001C!\u0003gAq!a\u000e\u0001\t\u0003\n\u0019\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u00111\u000b\u0001\u0005\u0002\u0005m\u0002bBA+\u0001\u0011\u0005\u00111\b\u0005\b\u0003/\u0002A\u0011AA\u001e\u0011\u001d\tI\u0006\u0001C\u0001\u00037\u0012!\u0003R3gCVdGoU8ve\u000e,7+^5uK*\u0011\u0011EI\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0011\nQ\u0001\u001b2bg\u0016T!!\n\u0014\u0002\r!\fGm\\8q\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\f\u001a6!\ti\u0003'D\u0001/\u0015\ty\u0003&A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011G\f\u0002\t\rVt7+^5uKB\u0011QfM\u0005\u0003i9\u0012!CQ3g_J,\u0017I\u001c3BMR,'/R1dQB\u0011QFN\u0005\u0003o9\u0012\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m\u0003\u0019a\u0014N\\5u}Q\t!\b\u0005\u0002<\u00015\t\u0001%\u0001\u0004m_\u001e<WM]\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tK\u0001\u0006g24GG[\u0005\u0003\u0007\u0002\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0003g\u000e,\u0012a\u0012\t\u0003\u0011*k\u0011!\u0013\u0006\u0003C\u0019J!aS%\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\rM\u001cw\fJ3r)\tqE\u000b\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006K\u0001\u0003V]&$\bbB+\u0006\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0014aA:dA!\u0012a\u0001\u0017\t\u0003\u001ffK!A\u0017)\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!\u0003+F'R{V\u000bV%M+\u0005i\u0006C\u00010`\u001b\u0005\u0011\u0013B\u00011#\u0005MA%)Y:f)\u0016\u001cH/\u001b8h+RLG.\u001b;z\u00035!Vi\u0015+`+RKEj\u0018\u0013fcR\u0011aj\u0019\u0005\b+\"\t\t\u00111\u0001^\u0003)!Vi\u0015+`+RKE\nI\u0001\fiF\"\u0016M\u00197f\u001d\u0006lW-F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0003mC:<'\"\u00017\u0002\t)\fg/Y\u0005\u0003]&\u0014aa\u0015;sS:<\u0017\u0001\u0004;2)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\u0003;3)\u0006\u0014G.\u001a(b[\u0016\fA\u0002\u001e\u001aUC\ndWMT1nK\u0002\nAbY8mk6tg)Y7jYf\fQbY8mk6tg)Y7jYf\u0004\u0013AC:rY\u000e{g\u000e^3yiV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002z\u0013\u0006\u00191/\u001d7\n\u0005mD(AC*R\u0019\u000e{g\u000e^3yi\u0006q1/\u001d7D_:$X\r\u001f;`I\u0015\fHC\u0001(\u007f\u0011\u001d)\u0016#!AA\u0002Y\f1b]9m\u0007>tG/\u001a=uA\u0005\u0011AMZ\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002$9!\u0011\u0011BA\u0010\u001d\u0011\tY!!\b\u000f\t\u00055\u00111\u0004\b\u0005\u0003\u001f\tIB\u0004\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BK\u0001\u0007yI|w\u000e\u001e \n\u0003%J!a\n\u0015\n\u0005\u00052\u0013BA=J\u0013\r\t\t\u0003_\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)#a\n\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA\u0011q\u00061AMZ0%KF$2ATA\u0017\u0011!)F#!AA\u0002\u0005\u0015\u0011a\u00013gA\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002\u001d\u0006A\u0011M\u001a;fe\u0006cG.\u0001\u0006cK\u001a|'/Z#bG\"\fAb\u001e:ji\u0016\u001c\u0015\r^1m_\u001e,\"!!\u0010\u0011\t\u0005}\u0012q\t\b\u0005\u0003\u0003\n\u0019\u0005E\u0002\u0002\u0012AK1!!\u0012Q\u0003\u0019\u0001&/\u001a3fM&\u0019a.!\u0013\u000b\u0007\u0005\u0015\u0003+A\u0006xSRD7)\u0019;bY><G\u0003BA\u0003\u0003\u001fBq!!\u0015\u001b\u0001\u0004\ti$A\u0002dCR\f\u0001#\u0019<s_^\u0013\u0018\u000e^3DCR\fGn\\4\u0002\u0017\u00054(o\\\"bi\u0006dwnZ\u0001\u0012CZ\u0014xnQ1uC2|w-\u00138tKJ$\u0018aD<ji\"\feO]8DCR\fGn\\4\u0015\t\u0005\u0015\u0011Q\f\u0005\b\u0003#r\u0002\u0019AA\u001f\u0001")
public class DefaultSourceSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final Logger logger;
    private transient SparkContext sc;
    private HBaseTestingUtility TEST_UTIL;
    private final String t1TableName;
    private final String t2TableName;
    private final String columnFamily;
    private SQLContext sqlContext;
    private Dataset<Row> df;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public HBaseTestingUtility TEST_UTIL() {
        return this.TEST_UTIL;
    }

    public void TEST_UTIL_$eq(HBaseTestingUtility x$1) {
        this.TEST_UTIL = x$1;
    }

    public String t1TableName() {
        return this.t1TableName;
    }

    public String t2TableName() {
        return this.t2TableName;
    }

    public String columnFamily() {
        return this.columnFamily;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public void df_$eq(Dataset<Row> x$1) {
        this.df = x$1;
    }

    public void beforeAll() {
        this.TEST_UTIL().startMiniCluster();
        this.logger().info(" - minicluster started");
        try {
            this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.t1TableName()));
        }
        catch (Exception e) {
            this.logger().info(new StringBuilder(18).append(" - no table ").append(this.t1TableName()).append(" found").toString());
        }
        try {
            this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.t2TableName()));
        }
        catch (Exception e) {
            this.logger().info(new StringBuilder(18).append(" - no table ").append(this.t2TableName()).append(" found").toString());
        }
        this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.t1TableName()).toString());
        this.TEST_UTIL().createTable(TableName.valueOf((String)this.t1TableName()), Bytes.toBytes((String)this.columnFamily()));
        this.logger().info(" - created table");
        this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.t2TableName()).toString());
        this.TEST_UTIL().createTable(TableName.valueOf((String)this.t2TableName()), Bytes.toBytes((String)this.columnFamily()));
        this.logger().info(" - created table");
        SparkConf sparkConf = new SparkConf();
        sparkConf.set(HBaseSparkConf$.MODULE$.BLOCK_CACHE_ENABLE(), "true");
        sparkConf.set(HBaseSparkConf$.MODULE$.BATCH_NUM(), "100");
        sparkConf.set(HBaseSparkConf$.MODULE$.CACHE_SIZE(), "100");
        this.sc_$eq(new SparkContext("local", "test", sparkConf));
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.TEST_UTIL().getConfiguration());){
            try (Table t1Table = connection.getTable(TableName.valueOf((String)"t1"));){
                Put put = new Put(Bytes.toBytes((String)"get1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)1));
                t1Table.put(put);
                put = new Put(Bytes.toBytes((String)"get2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)4));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"z"), Bytes.toBytes((String)"FOO"));
                t1Table.put(put);
                put = new Put(Bytes.toBytes((String)"get3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"8"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)8));
                t1Table.put(put);
                put = new Put(Bytes.toBytes((String)"get4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"10"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)10));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"z"), Bytes.toBytes((String)"BAR"));
                t1Table.put(put);
                put = new Put(Bytes.toBytes((String)"get5"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo5"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"8"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)8));
                t1Table.put(put);
            }
            try (Table t2Table = connection.getTable(TableName.valueOf((String)"t2"));){
                Put put = new Put(Bytes.toBytes((int)1));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"1"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)1));
                t2Table.put(put);
                put = new Put(Bytes.toBytes((int)2));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo2"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)4));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"z"), Bytes.toBytes((String)"FOO"));
                t2Table.put(put);
                put = new Put(Bytes.toBytes((int)3));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo3"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"8"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)8));
                t2Table.put(put);
                put = new Put(Bytes.toBytes((int)4));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo4"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"10"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)10));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"z"), Bytes.toBytes((String)"BAR"));
                t2Table.put(put);
                put = new Put(Bytes.toBytes((int)5));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"foo5"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"8"));
                put.addColumn(Bytes.toBytes((String)this.columnFamily()), Bytes.toBytes((String)"i"), Bytes.toBytes((int)8));
                t2Table.put(put);
            }
        }
        new HBaseContext(this.sc(), this.TEST_UTIL().getConfiguration(), HBaseContext$.MODULE$.$lessinit$greater$default$3());
        this.sqlContext_$eq(new SQLContext(this.sc()));
        this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)DefaultSourceSuite.hbaseTable1Catalog$1())}))));
        this.df().registerTempTable("hbaseTable1");
        this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)DefaultSourceSuite.hbaseTable2Catalog$1())}))));
        this.df().registerTempTable("hbaseTable2");
    }

    public void afterAll() {
        this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.t1TableName()));
        this.logger().info("shuting down minicluster");
        this.TEST_UTIL().shutdownMiniCluster();
        this.sc().stop();
    }

    public void beforeEach() {
        DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().clear();
    }

    public String writeCatalog() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n                    |\"table\":{\"namespace\":\"default\", \"name\":\"table1\"},\n                    |\"rowkey\":\"key\",\n                    |\"columns\":{\n                    |\"col0\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n                    |\"col1\":{\"cf\":\"cf1\", \"col\":\"col1\", \"type\":\"boolean\"},\n                    |\"col2\":{\"cf\":\"cf2\", \"col\":\"col2\", \"type\":\"double\"},\n                    |\"col3\":{\"cf\":\"cf3\", \"col\":\"col3\", \"type\":\"float\"},\n                    |\"col4\":{\"cf\":\"cf4\", \"col\":\"col4\", \"type\":\"int\"},\n                    |\"col5\":{\"cf\":\"cf5\", \"col\":\"col5\", \"type\":\"bigint\"},\n                    |\"col6\":{\"cf\":\"cf6\", \"col\":\"col6\", \"type\":\"smallint\"},\n                    |\"col7\":{\"cf\":\"cf7\", \"col\":\"col7\", \"type\":\"string\"},\n                    |\"col8\":{\"cf\":\"cf8\", \"col\":\"col8\", \"type\":\"tinyint\"}\n                    |}\n                    |}")).stripMargin();
    }

    public Dataset<Row> withCatalog(String cat) {
        return this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)cat)}))).format("org.apache.hadoop.hbase.spark").load();
    }

    public String avroWriteCatalog() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n                             |\"table\":{\"namespace\":\"default\", \"name\":\"avrotable\"},\n                             |\"rowkey\":\"key\",\n                             |\"columns\":{\n                             |\"col0\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"binary\"},\n                             |\"col1\":{\"cf\":\"cf1\", \"col\":\"col1\", \"type\":\"binary\"}\n                             |}\n                             |}")).stripMargin();
    }

    public String avroCatalog() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n                        |\"table\":{\"namespace\":\"default\", \"name\":\"avrotable\"},\n                        |\"rowkey\":\"key\",\n                        |\"columns\":{\n                        |\"col0\":{\"cf\":\"rowkey\", \"col\":\"key\",  \"avro\":\"avroSchema\"},\n                        |\"col1\":{\"cf\":\"cf1\", \"col\":\"col1\", \"avro\":\"avroSchema\"}\n                        |}\n                        |}")).stripMargin();
    }

    public String avroCatalogInsert() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n                              |\"table\":{\"namespace\":\"default\", \"name\":\"avrotableInsert\"},\n                              |\"rowkey\":\"key\",\n                              |\"columns\":{\n                              |\"col0\":{\"cf\":\"rowkey\", \"col\":\"key\", \"avro\":\"avroSchema\"},\n                              |\"col1\":{\"cf\":\"cf1\", \"col\":\"col1\", \"avro\":\"avroSchema\"}\n                              |}\n                              |}")).stripMargin();
    }

    public Dataset<Row> withAvroCatalog(String cat) {
        return this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avroSchema"), (Object)AvroHBaseKeyRecord$.MODULE$.schemaString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.avroCatalog())}))).format("org.apache.hadoop.hbase.spark").load();
    }

    private static final String hbaseTable1Catalog$1() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
    }

    private static final String hbaseTable2Catalog$1() {
        return new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t2\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"int\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
    }

    public DefaultSourceSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.logger = LoggerFactory.getLogger(DefaultSourceSuite.class);
        this.sc = null;
        this.TEST_UTIL = new HBaseTestingUtility();
        this.t1TableName = "t1";
        this.t2TableName = "t2";
        this.columnFamily = "c";
        this.sqlContext = null;
        this.df = null;
        this.test("Test rowKey point only rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE (KEY_FIELD = 'get1' or KEY_FIELD = 'get2' or KEY_FIELD = 'get3')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( KEY_FIELD == 0 OR KEY_FIELD == 1 ) OR KEY_FIELD == 2 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( KEY_FIELD == 0 OR KEY_FIELD == 1 ) OR KEY_FIELD == 2 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("Test cell point only rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE (B_FIELD = '4' or B_FIELD = '10' or A_FIELD = 'foo1')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( B_FIELD == 0 OR B_FIELD == 1 ) OR A_FIELD == 2 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( B_FIELD == 0 OR B_FIELD == 1 ) OR A_FIELD == 2 )\")", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("Test two range rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE ( KEY_FIELD < 'get2' or KEY_FIELD > 'get3')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( KEY_FIELD < 0 OR KEY_FIELD > 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( KEY_FIELD < 0 OR KEY_FIELD > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.upperBound(), (byte[])Bytes.toBytes((String)"get2")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get2\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            ScanRange scanRange2 = (ScanRange)executionRules.rowKeyFilter().ranges().get(1).get();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange2.lowerBound(), (byte[])Bytes.toBytes((String)"get3")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange2.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get3\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            byte[] $org_scalatest_assert_macro_left4 = scanRange2.upperBound();
            Object $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, $org_scalatest_assert_macro_left4 == null, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(scanRange2.isLowerBoundEqualTo(), "scanRange2.isLowerBoundEqualTo", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(scanRange2.isUpperBoundEqualTo(), "scanRange2.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("Test two range rowKey query where the rowKey is Int and there is a range over lap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable2 WHERE ( KEY_FIELD < 4 or KEY_FIELD > 2)").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( KEY_FIELD < 0 OR KEY_FIELD > 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( KEY_FIELD < 0 OR KEY_FIELD > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
            MutableList $org_scalatest_assert_macro_left = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            Row[] $org_scalatest_assert_macro_left3 = results;
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        this.test("Test two range rowKey query where the rowKey is Int and the ranges don't over lap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable2 WHERE ( KEY_FIELD < 2 or KEY_FIELD > 4)").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( KEY_FIELD < 0 OR KEY_FIELD > 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( KEY_FIELD < 0 OR KEY_FIELD > 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            MutableList $org_scalatest_assert_macro_left = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.upperBound(), (byte[])Bytes.toBytes((int)2)), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(2))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            ScanRange scanRange2 = (ScanRange)executionRules.rowKeyFilter().ranges().get(1).get();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange2.isUpperBoundEqualTo(), "scanRange2.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            Row[] $org_scalatest_assert_macro_left3 = results;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("Test one combined range rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE (KEY_FIELD <= 'get3' and KEY_FIELD >= 'get2')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( KEY_FIELD <= 0 AND KEY_FIELD >= 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( KEY_FIELD <= 0 AND KEY_FIELD >= 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"get2")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get2\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.upperBound(), (byte[])Bytes.toBytes((String)"get3")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get3\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("Test select only query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results;
            Row[] $org_scalatest_assert_macro_left = results = (Row[])this.df().select("KEY_FIELD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).take(10);
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            DynamicLogicExpression $org_scalatest_assert_macro_left2 = executionRules.dynamicLogicExpression();
            Object $org_scalatest_assert_macro_right2 = null;
            DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left2;
            Object var9_8 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var9_8) : var9_8 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.test("Test SQL point and range combo", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD FROM hbaseTable1 WHERE (KEY_FIELD = 'get1' and B_FIELD < '3') or (KEY_FIELD >= 'get3' and B_FIELD = '8')").take(5);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( KEY_FIELD == 0 AND B_FIELD < 1 ) OR ( KEY_FIELD >= 2 AND B_FIELD == 3 ) )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( KEY_FIELD == 0 AND B_FIELD < 1 ) OR ( KEY_FIELD >= 2 AND B_FIELD == 3 ) )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            MutableList $org_scalatest_assert_macro_left = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"get3")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get3\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
            byte[] $org_scalatest_assert_macro_left3 = scanRange1.upperBound();
            Object $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", null, $org_scalatest_assert_macro_left3 == null, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            Row[] $org_scalatest_assert_macro_left4 = results;
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("Test two complete range non merge rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results;
            Row[] $org_scalatest_assert_macro_left = results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable2 WHERE ( KEY_FIELD >= 1 and KEY_FIELD <= 2) or( KEY_FIELD > 3 and KEY_FIELD <= 5)").take(10);
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( KEY_FIELD >= 0 AND KEY_FIELD <= 1 ) OR ( KEY_FIELD > 2 AND KEY_FIELD <= 3 ) )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( KEY_FIELD >= 0 AND KEY_FIELD <= 1 ) OR ( KEY_FIELD > 2 AND KEY_FIELD <= 3 ) )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((int)1)), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(1))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.upperBound(), (byte[])Bytes.toBytes((int)2)), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(2))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
            ScanRange scanRange2 = (ScanRange)executionRules.rowKeyFilter().ranges().get(1).get();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange2.lowerBound(), (byte[])Bytes.toBytes((int)3)), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange2.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(3))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange2.upperBound(), (byte[])Bytes.toBytes((int)5)), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange2.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(5))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(scanRange2.isLowerBoundEqualTo(), "scanRange2.isLowerBoundEqualTo", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(scanRange2.isUpperBoundEqualTo(), "scanRange2.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
        this.test("Test two complete range merge rowKey query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE ( KEY_FIELD >= 'get1' and KEY_FIELD <= 'get2') or( KEY_FIELD > 'get3' and KEY_FIELD <= 'get5')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( KEY_FIELD >= 0 AND KEY_FIELD <= 1 ) OR ( KEY_FIELD > 2 AND KEY_FIELD <= 3 ) )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( KEY_FIELD >= 0 AND KEY_FIELD <= 1 ) OR ( KEY_FIELD > 2 AND KEY_FIELD <= 3 ) )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"get1")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get1\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.upperBound(), (byte[])Bytes.toBytes((String)"get2")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get2\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            ScanRange scanRange2 = (ScanRange)executionRules.rowKeyFilter().ranges().get(1).get();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange2.lowerBound(), (byte[])Bytes.toBytes((String)"get3")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange2.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get3\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange2.upperBound(), (byte[])Bytes.toBytes((String)"get5")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange2.upperBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"get5\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(scanRange2.isLowerBoundEqualTo(), "scanRange2.isLowerBoundEqualTo", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(scanRange2.isUpperBoundEqualTo(), "scanRange2.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("Test OR logic with a one RowKey and One column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE ( KEY_FIELD >= 'get1' or A_FIELD <= 'foo2') or( KEY_FIELD > 'get3' or B_FIELD <= '4')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( KEY_FIELD >= 0 OR A_FIELD <= 1 ) OR ( KEY_FIELD > 2 OR B_FIELD <= 3 ) )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( KEY_FIELD >= 0 OR A_FIELD <= 1 ) OR ( KEY_FIELD > 2 OR B_FIELD <= 3 ) )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            byte[] $org_scalatest_assert_macro_left4 = scanRange1.upperBound();
            Object $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, $org_scalatest_assert_macro_left4 == null, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        this.test("Test OR logic with a two columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE ( B_FIELD > '4' or A_FIELD <= 'foo2') or( A_FIELD > 'foo2' or B_FIELD < '4')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( ( B_FIELD > 0 OR A_FIELD <= 1 ) OR ( A_FIELD > 2 OR B_FIELD < 3 ) )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( ( B_FIELD > 0 OR A_FIELD <= 1 ) OR ( A_FIELD > 2 OR B_FIELD < 3 ) )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
            byte[] $org_scalatest_assert_macro_left4 = scanRange1.upperBound();
            Object $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, $org_scalatest_assert_macro_left4 == null, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
        this.test("Test single RowKey Or Column logic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseTable1 WHERE ( KEY_FIELD >= 'get4' or A_FIELD <= 'foo2' )").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( KEY_FIELD >= 0 OR A_FIELD <= 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( KEY_FIELD >= 0 OR A_FIELD <= 1 )\")", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
            MutableList $org_scalatest_assert_macro_left2 = executionRules.rowKeyFilter().points();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
            MutableList $org_scalatest_assert_macro_left3 = executionRules.rowKeyFilter().ranges();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
            ScanRange scanRange1 = (ScanRange)executionRules.rowKeyFilter().ranges().get(0).get();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.equals((byte[])scanRange1.lowerBound(), (byte[])Bytes.toBytes((String)"")), "org.apache.hadoop.hbase.util.Bytes.equals(scanRange1.lowerBound, org.apache.hadoop.hbase.util.Bytes.toBytes(\"\"))", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            byte[] $org_scalatest_assert_macro_left4 = scanRange1.upperBound();
            Object $org_scalatest_assert_macro_right4 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, $org_scalatest_assert_macro_left4 == null, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(scanRange1.isLowerBoundEqualTo(), "scanRange1.isLowerBoundEqualTo", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(scanRange1.isUpperBoundEqualTo(), "scanRange1.isUpperBoundEqualTo", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        this.test("Test table that doesn't exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1NotThere\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"c\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
                this.df().registerTempTable("hbaseNonExistingTmp");
                return this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseNonExistingTmp WHERE ( KEY_FIELD >= 'get1' and KEY_FIELD <= 'get3') or( KEY_FIELD > 'get3' and KEY_FIELD <= 'get5')").count();
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            return (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        this.test("Test table with column that doesn't exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"},\n              |\"C_FIELD\":{\"cf\":\"c\", \"col\":\"c\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
            this.df().registerTempTable("hbaseFactColumnTmp");
            Dataset result = this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseFactColumnTmp");
            long $org_scalatest_assert_macro_left = result.count();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            DynamicLogicExpression $org_scalatest_assert_macro_left2 = executionRules.dynamicLogicExpression();
            Object $org_scalatest_assert_macro_right2 = null;
            DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left2;
            Object var11_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var11_9) : var11_9 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        this.test("Test table with INT column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] localResult;
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"},\n              |\"I_FIELD\":{\"cf\":\"c\", \"col\":\"i\", \"type\":\"int\"}\n            |}\n          |}")).stripMargin();
            this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
            this.df().registerTempTable("hbaseIntTmp");
            Dataset result = this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, I_FIELD FROM hbaseIntTmp where I_FIELD > 4 and I_FIELD < 10");
            Row[] $org_scalatest_assert_macro_left = localResult = (Row[])result.take(5);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            int $org_scalatest_assert_macro_left2 = localResult[0].getInt(2);
            int $org_scalatest_assert_macro_right2 = 8;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(executionRules.dynamicLogicExpression().toExpressionString().equals("( I_FIELD > 0 AND I_FIELD < 1 )"), "executionRules.dynamicLogicExpression.toExpressionString.equals(\"( I_FIELD > 0 AND I_FIELD < 1 )\")", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        this.test("Test table with INT column defined at wrong type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] localResult;
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"},\n              |\"I_FIELD\":{\"cf\":\"c\", \"col\":\"i\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
            this.df().registerTempTable("hbaseIntWrongTypeTmp");
            Dataset result = this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, I_FIELD FROM hbaseIntWrongTypeTmp");
            Row[] $org_scalatest_assert_macro_left = localResult = (Row[])result.take(10);
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            DynamicLogicExpression $org_scalatest_assert_macro_left2 = executionRules.dynamicLogicExpression();
            Object $org_scalatest_assert_macro_right2 = null;
            DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left2;
            Object var11_10 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            String $org_scalatest_assert_macro_left3 = localResult[0].getString(2);
            int $org_scalatest_assert_macro_right3 = 4;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            byte $org_scalatest_assert_macro_left4 = (byte)localResult[0].getString(2).charAt(0);
            byte $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
            byte $org_scalatest_assert_macro_left5 = (byte)localResult[0].getString(2).charAt(1);
            byte $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            byte $org_scalatest_assert_macro_left6 = (byte)localResult[0].getString(2).charAt(2);
            byte $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
            byte $org_scalatest_assert_macro_left7 = (byte)localResult[0].getString(2).charAt(3);
            byte $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToByte((byte)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
        this.test("Test bad column type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"FOOBAR\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"I_FIELD\":{\"cf\":\"c\", \"col\":\"i\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                Row[] localResult;
                this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
                this.df().registerTempTable("hbaseIntWrongTypeTmp");
                Dataset result = this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, I_FIELD FROM hbaseIntWrongTypeTmp");
                Row[] $org_scalatest_assert_macro_left = localResult = (Row[])result.take(10);
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
                ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
                DynamicLogicExpression $org_scalatest_assert_macro_left2 = executionRules.dynamicLogicExpression();
                Object $org_scalatest_assert_macro_right2 = null;
                DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left2;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 720));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
        this.test("Test HBaseSparkConf matching", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = this.sqlContext().load("org.apache.hadoop.hbase.spark.HBaseTestSource", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cacheSize"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchNum"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blockCacheingEnable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowNum"), (Object)"10")})));
            long $org_scalatest_assert_macro_left = df.count();
            int $org_scalatest_assert_macro_right = 10;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
            Dataset df1 = this.sqlContext().load("org.apache.hadoop.hbase.spark.HBaseTestSource", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cacheSize"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchNum"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blockCacheingEnable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowNum"), (Object)"10")})));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                long $org_scalatest_assert_macro_left = df1.count();
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
            Dataset df2 = this.sqlContext().load("org.apache.hadoop.hbase.spark.HBaseTestSource", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cacheSize"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchNum"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blockCacheingEnable"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowNum"), (Object)"10")})));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                long $org_scalatest_assert_macro_left = df2.count();
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
            Dataset df3 = this.sqlContext().load("org.apache.hadoop.hbase.spark.HBaseTestSource", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cacheSize"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"batchNum"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blockCacheingEnable"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rowNum"), (Object)"10")})));
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                long $org_scalatest_assert_macro_left = df3.count();
                int $org_scalatest_assert_macro_right = 10;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            }, ClassTag$.MODULE$.apply(Exception.class), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        this.test("Test table with sparse column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Row[] localResult;
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"},\n              |\"Z_FIELD\":{\"cf\":\"c\", \"col\":\"z\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog)}))));
            this.df().registerTempTable("hbaseZTmp");
            Dataset result = this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, Z_FIELD FROM hbaseZTmp");
            Row[] $org_scalatest_assert_macro_left = localResult = (Row[])result.take(10);
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
            String $org_scalatest_assert_macro_left2 = localResult[0].getString(2);
            Object $org_scalatest_assert_macro_right2 = null;
            String string = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
            String $org_scalatest_assert_macro_left3 = localResult[1].getString(2);
            String $org_scalatest_assert_macro_right3 = "FOO";
            String string2 = $org_scalatest_assert_macro_left3;
            String string3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string2 != null ? !string2.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            String $org_scalatest_assert_macro_left4 = localResult[2].getString(2);
            Object $org_scalatest_assert_macro_right4 = null;
            String string4 = $org_scalatest_assert_macro_left4;
            Object var18_17 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", null, !(string4 != null ? !string4.equals(var18_17) : var18_17 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
            String $org_scalatest_assert_macro_left5 = localResult[3].getString(2);
            String $org_scalatest_assert_macro_right5 = "BAR";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            String $org_scalatest_assert_macro_left6 = localResult[4].getString(2);
            Object $org_scalatest_assert_macro_right6 = null;
            String string7 = $org_scalatest_assert_macro_left6;
            Object var26_25 = null;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", null, !(string7 != null ? !string7.equals(var26_25) : var26_25 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            DynamicLogicExpression $org_scalatest_assert_macro_left7 = executionRules.dynamicLogicExpression();
            Object $org_scalatest_assert_macro_right7 = null;
            DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left7;
            Object var31_30 = null;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var31_30) : var31_30 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
        this.test("Test with column logic disabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String catalog = new StringOps(Predef$.MODULE$.augmentString("{\n            |\"table\":{\"namespace\":\"default\", \"name\":\"t1\"},\n            |\"rowkey\":\"key\",\n            |\"columns\":{\n              |\"KEY_FIELD\":{\"cf\":\"rowkey\", \"col\":\"key\", \"type\":\"string\"},\n              |\"A_FIELD\":{\"cf\":\"c\", \"col\":\"a\", \"type\":\"string\"},\n              |\"B_FIELD\":{\"cf\":\"c\", \"col\":\"b\", \"type\":\"string\"},\n              |\"Z_FIELD\":{\"cf\":\"c\", \"col\":\"z\", \"type\":\"string\"}\n            |}\n          |}")).stripMargin();
            this.df_$eq((Dataset<Row>)this.sqlContext().load("org.apache.hadoop.hbase.spark", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)catalog), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.PUSH_DOWN_COLUMN_FILTER()), (Object)"false")}))));
            this.df().registerTempTable("hbaseNoPushDownTmp");
            Row[] results = (Row[])this.sqlContext().sql("SELECT KEY_FIELD, B_FIELD, A_FIELD FROM hbaseNoPushDownTmp WHERE (KEY_FIELD <= 'get3' and KEY_FIELD >= 'get2')").take(10);
            ExecutionRuleForUnitTesting executionRules = (ExecutionRuleForUnitTesting)DefaultSourceStaticUtils$.MODULE$.lastFiveExecutionRules().poll();
            Row[] $org_scalatest_assert_macro_left = results;
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
            DynamicLogicExpression $org_scalatest_assert_macro_left2 = executionRules.dynamicLogicExpression();
            Object $org_scalatest_assert_macro_right2 = null;
            DynamicLogicExpression dynamicLogicExpression = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(dynamicLogicExpression != null ? !dynamicLogicExpression.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        this.test("populate table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            IndexedSeq data = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable & scala.Serializable)i -> HBaseRecord$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)i), "extra"), IndexedSeq$.MODULE$.canBuildFrom());
            SparkContext qual$1 = this.sc();
            IndexedSeq x$1 = data;
            int x$2 = qual$1.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DefaultSourceSuite.class.getClassLoader());
            public final class Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.hadoop.hbase.spark.HBaseRecord").asType().toTypeConstructor();
                }

                public Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator6$1(DefaultSourceSuite $outer) {
                }
            }
            sql.implicits().rddToDatasetHolder(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(HBaseRecord.class)), sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator6$1(null)))).toDF().write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.newTable()), (Object)"5")}))).format("org.apache.hadoop.hbase.spark").save();
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        this.test("empty column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long c;
            Dataset<Row> df = this.withCatalog(this.writeCatalog());
            df.registerTempTable("table0");
            long $org_scalatest_assert_macro_left = c = BoxesRunTime.unboxToLong((Object)((Row[])this.sqlContext().sql("select count(1) from table0").rdd().collect())[0].apply(0));
            int $org_scalatest_assert_macro_right = 256;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849));
        this.test("full query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> df = this.withCatalog(this.writeCatalog());
            df.show();
            long $org_scalatest_assert_macro_left = df.count();
            int $org_scalatest_assert_macro_right = 256;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 856));
        this.test("filtered query0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withCatalog(this.writeCatalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col0"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)"row005")).select("col0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}));
            s.show();
            long $org_scalatest_assert_macro_left = s.count();
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        this.test("Timestamp semantics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Object middleElement200;
            Object oldElement50;
            Object element200;
            Object element50;
            SQLContext sql = this.sqlContext();
            long oldMs = 754869600000L;
            long startMs = System.currentTimeMillis();
            IndexedSeq oldData = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> HBaseRecord$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)i), "old"), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq newData = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(200), 255).map((Function1 & Serializable & scala.Serializable)i -> HBaseRecord$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)i), "new"), IndexedSeq$.MODULE$.canBuildFrom());
            SparkContext qual$2 = this.sc();
            IndexedSeq x$3 = oldData;
            int x$4 = qual$2.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DefaultSourceSuite.class.getClassLoader());
            public final class Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.hadoop.hbase.spark.HBaseRecord").asType().toTypeConstructor();
                }

                public Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator16$1(DefaultSourceSuite $outer) {
                }
            }
            sql.implicits().rddToDatasetHolder(qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(HBaseRecord.class)), sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator16$1(null)))).toDF().write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableName()), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()), (Object)Long.toString(oldMs))}))).format("org.apache.hadoop.hbase.spark").save();
            SparkContext qual$3 = this.sc();
            IndexedSeq x$5 = newData;
            int x$6 = qual$3.parallelize$default$2();
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DefaultSourceSuite.class.getClassLoader());
            public final class Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.hadoop.hbase.spark.HBaseRecord").asType().toTypeConstructor();
                }

                public Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator26$1(DefaultSourceSuite $outer) {
                }
            }
            sql.implicits().rddToDatasetHolder(qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(HBaseRecord.class)), sql.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator26$1(null)))).toDF().write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableName()), (Object)"5")}))).format("org.apache.hadoop.hbase.spark").save();
            Dataset individualTimestamp = this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.TIMESTAMP()), (Object)Long.toString(oldMs))}))).format("org.apache.hadoop.hbase.spark").load();
            long $org_scalatest_assert_macro_left = individualTimestamp.count();
            int $org_scalatest_assert_macro_right = 101;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
            Dataset everything = this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog())}))).format("org.apache.hadoop.hbase.spark").load();
            long $org_scalatest_assert_macro_left2 = everything.count();
            int $org_scalatest_assert_macro_right2 = 256;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
            Object $org_scalatest_assert_macro_left3 = element50 = ((Row[])everything.where(functions$.MODULE$.col("col0").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)"row050"))).select("col7", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].apply(0);
            String $org_scalatest_assert_macro_right3 = "String50: extra";
            Object object = $org_scalatest_assert_macro_left3;
            String string = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(object != null ? !object.equals(string) : string != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
            Object $org_scalatest_assert_macro_left4 = element200 = ((Row[])everything.where(functions$.MODULE$.col("col0").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)"row200"))).select("col7", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].apply(0);
            String $org_scalatest_assert_macro_right4 = "String200: new";
            Object object2 = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(object2 != null ? !object2.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
            Dataset oldRange = this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.MIN_TIMESTAMP()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.MAX_TIMESTAMP()), (Object)Long.toString(oldMs + 100L))}))).format("org.apache.hadoop.hbase.spark").load();
            long $org_scalatest_assert_macro_left5 = oldRange.count();
            int $org_scalatest_assert_macro_right5 = 101;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == (long)$org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 924));
            Object $org_scalatest_assert_macro_left6 = oldElement50 = ((Row[])oldRange.where(functions$.MODULE$.col("col0").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)"row050"))).select("col7", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].apply(0);
            String $org_scalatest_assert_macro_right6 = "String50: old";
            Object object3 = $org_scalatest_assert_macro_left6;
            String string3 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(object3 != null ? !object3.equals(string3) : string3 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
            Dataset middleRange = this.sqlContext().read().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.writeCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.MIN_TIMESTAMP()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseSparkConf$.MODULE$.MAX_TIMESTAMP()), (Object)Long.toString(startMs + 100L))}))).format("org.apache.hadoop.hbase.spark").load();
            long $org_scalatest_assert_macro_left7 = middleRange.count();
            int $org_scalatest_assert_macro_right7 = 256;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            Object $org_scalatest_assert_macro_left8 = middleElement200 = ((Row[])middleRange.where(functions$.MODULE$.col("col0").$eq$eq$eq((Object)functions$.MODULE$.lit((Object)"row200"))).select("col7", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())[0].apply(0);
            String $org_scalatest_assert_macro_right8 = "String200: extra";
            Object object4 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(object4 != null ? !object4.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        this.test("populate avro table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            IndexedSeq data = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable & scala.Serializable)i -> AvroHBaseKeyRecord$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            SparkContext qual$4 = this.sc();
            IndexedSeq x$7 = data;
            int x$8 = qual$4.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DefaultSourceSuite.class.getClassLoader());
            public final class Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.hadoop.hbase.spark.AvroHBaseKeyRecord").asType().toTypeConstructor();
                }

                public Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator36$1(DefaultSourceSuite $outer) {
                }
            }
            sql.implicits().rddToDatasetHolder(qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(AvroHBaseKeyRecord.class)), sql.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hadoop_hbase_spark_DefaultSourceSuite$$typecreator36$1(null)))).toDF().write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.avroWriteCatalog()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.newTable()), (Object)"5")}))).format("org.apache.hadoop.hbase.spark").save();
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
        this.test("avro empty column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long c;
            Dataset<Row> df = this.withAvroCatalog(this.avroCatalog());
            df.registerTempTable("avrotable");
            long $org_scalatest_assert_macro_left = c = BoxesRunTime.unboxToLong((Object)((Row[])this.sqlContext().sql("select count(1) from avrotable").rdd().collect())[0].apply(0));
            int $org_scalatest_assert_macro_right = 256;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
        this.test("avro full query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> df = this.withAvroCatalog(this.avroCatalog());
            df.show();
            df.printSchema();
            long $org_scalatest_assert_macro_left = df.count();
            int $org_scalatest_assert_macro_right = 256;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1008));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
        this.test("avro serialization and deserialization query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset<Row> df = this.withAvroCatalog(this.avroCatalog());
            df.write().options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avroSchema"), (Object)AvroHBaseKeyRecord$.MODULE$.schemaString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.tableCatalog()), (Object)this.avroCatalogInsert()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HBaseTableCatalog$.MODULE$.newTable()), (Object)"5")}))).format("org.apache.hadoop.hbase.spark").save();
            Dataset<Row> newDF = this.withAvroCatalog(this.avroCatalogInsert());
            newDF.show();
            newDF.printSchema();
            long $org_scalatest_assert_macro_left = newDF.count();
            int $org_scalatest_assert_macro_right = 256;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1022));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1011));
        this.test("avro filtered query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withAvroCatalog(this.avroCatalog());
            Dataset r = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.name"}))).$((Seq)Nil$.MODULE$).$eq$eq$eq((Object)"name005").$bar$bar((Object)sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.name"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)"name005"))).select("col0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.favorite_color", "col1.favorite_number"}));
            r.show();
            long $org_scalatest_assert_macro_left = r.count();
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
        this.test("avro Or filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SQLContext sql = this.sqlContext();
            Dataset<Row> df = this.withAvroCatalog(this.avroCatalog());
            Dataset s = df.filter(sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.name"}))).$((Seq)Nil$.MODULE$).$less$eq((Object)"name005").$bar$bar((Object)sql.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.name"}))).$((Seq)Nil$.MODULE$).contains((Object)"name007"))).select("col0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1.favorite_color", "col1.favorite_number"}));
            s.show();
            long $org_scalatest_assert_macro_left = s.count();
            int $org_scalatest_assert_macro_right = 7;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1042));
        }, new Position("DefaultSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1035));
    }
}

