/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import scala.runtime.BoxesRunTime;

public final class AvroSerdes$ {
    public static AvroSerdes$ MODULE$;

    static {
        new AvroSerdes$();
    }

    public byte[] serialize(Object input, Schema schema) {
        byte[] byArray;
        Schema.Type type = schema.getType();
        if (Schema.Type.BOOLEAN.equals(type)) {
            byArray = Bytes.toBytes((boolean)BoxesRunTime.unboxToBoolean((Object)input));
        } else {
            boolean bl = Schema.Type.BYTES.equals(type) ? true : Schema.Type.FIXED.equals(type);
            if (bl) {
                byArray = (byte[])input;
            } else if (Schema.Type.DOUBLE.equals(type)) {
                byArray = Bytes.toBytes((double)BoxesRunTime.unboxToDouble((Object)input));
            } else if (Schema.Type.FLOAT.equals(type)) {
                byArray = Bytes.toBytes((float)BoxesRunTime.unboxToFloat((Object)input));
            } else if (Schema.Type.INT.equals(type)) {
                byArray = Bytes.toBytes((int)BoxesRunTime.unboxToInt((Object)input));
            } else if (Schema.Type.LONG.equals(type)) {
                byArray = Bytes.toBytes((long)BoxesRunTime.unboxToLong((Object)input));
            } else if (Schema.Type.STRING.equals(type)) {
                byArray = Bytes.toBytes((String)((String)input));
            } else if (Schema.Type.RECORD.equals(type)) {
                GenericRecord gr = (GenericRecord)input;
                GenericDatumWriter writer2 = new GenericDatumWriter(schema);
                ByteArrayOutputStream bao2 = new ByteArrayOutputStream();
                BinaryEncoder encoder2 = EncoderFactory.get().directBinaryEncoder((OutputStream)bao2, null);
                writer2.write((Object)gr, (Encoder)encoder2);
                byArray = bao2.toByteArray();
            } else {
                throw new Exception(new StringBuilder(22).append("unsupported data type ").append(schema.getType()).toString());
            }
        }
        return byArray;
    }

    public GenericRecord deserialize(byte[] input, Schema schema) {
        GenericDatumReader reader2 = new GenericDatumReader(schema);
        ByteArrayInputStream bai2 = new ByteArrayInputStream(input);
        BinaryDecoder decoder2 = DecoderFactory.get().directBinaryDecoder((InputStream)bai2, null);
        GenericRecord gr2 = (GenericRecord)reader2.read(null, (Decoder)decoder2);
        return gr2;
    }

    private AvroSerdes$() {
        MODULE$ = this;
    }
}

