/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.spark;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.spark.BulkLoadPartitioner;
import org.apache.hadoop.hbase.spark.ByteArrayWrapper;
import org.apache.hadoop.hbase.spark.FamiliesQualifiersValues;
import org.apache.hadoop.hbase.spark.FamilyHFileWriteOptions;
import org.apache.hadoop.hbase.spark.HBaseContext;
import org.apache.hadoop.hbase.spark.HBaseContext$;
import org.apache.hadoop.hbase.spark.HBaseRDDFunctions$;
import org.apache.hadoop.hbase.spark.KeyFamilyQualifier;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.junit.rules.TemporaryFolder;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4A\u0001F\u000b\u0001A!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB\u001d\u0001A\u0003%1\u0007C\u0004;\u0001\u0001\u0007I\u0011A\u001e\t\u000f\u0005\u0003\u0001\u0019!C\u0001\u0005\"11\n\u0001Q!\nqBq\u0001\u0015\u0001A\u0002\u0013\u0005\u0011\u000bC\u0004W\u0001\u0001\u0007I\u0011A,\t\re\u0003\u0001\u0015)\u0003S\u0011\u001dQ\u0006A1A\u0005\u0002mCa\u0001\u001a\u0001!\u0002\u0013a\u0006bB3\u0001\u0005\u0004%\ta\u0017\u0005\u0007M\u0002\u0001\u000b\u0011\u0002/\t\u000f\u001d\u0004!\u0019!C\u00017\"1\u0001\u000e\u0001Q\u0001\nqCq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001b\u0005\u0006i\u0002!\t%\u001e\u0005\u0006m\u0002!\t%\u001e\u0002\u000e\u0005Vd7\u000eT8bIN+\u0018\u000e^3\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0015A'-Y:f\u0015\tQ2$\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\tsE\u000b\t\u0003E\u0015j\u0011a\t\u0006\u0003Iu\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0019\u001a#\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005\tB\u0013BA\u0015$\u0005I\u0011UMZ8sK\u0006sG-\u00114uKJ,\u0015m\u00195\u0011\u0005\tZ\u0013B\u0001\u0017$\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003U\ta\u0001\\8hO\u0016\u0014X#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Yj\u0012!B:mMRR\u0017B\u0001\u001d6\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013AA:d+\u0005a\u0004CA\u001f@\u001b\u0005q$B\u0001\f\u001c\u0013\t\u0001eH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004tG~#S-\u001d\u000b\u0003\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013A!\u00168ji\"9!*BA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005\u00191o\u0019\u0011)\u0005\u0019i\u0005C\u0001#O\u0013\tyUIA\u0005ue\u0006t7/[3oi\u0006IA+R*U?V#\u0016\nT\u000b\u0002%B\u00111\u000bV\u0007\u0002/%\u0011Qk\u0006\u0002\u0014\u0011\n\u000b7/\u001a+fgRLgnZ+uS2LG/_\u0001\u000e)\u0016\u001bFkX+U\u00132{F%Z9\u0015\u0005\rC\u0006b\u0002&\t\u0003\u0003\u0005\rAU\u0001\u000b)\u0016\u001bFkX+U\u00132\u0003\u0013!\u0003;bE2,g*Y7f+\u0005a\u0006CA/c\u001b\u0005q&BA0a\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\fAA[1wC&\u00111M\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015Q\f'\r\\3OC6,\u0007%A\u0007d_2,XN\u001c$b[&d\u00170M\u0001\u000fG>dW/\u001c8GC6LG._\u0019!\u00035\u0019w\u000e\\;n]\u001a\u000bW.\u001b7ze\u0005q1m\u001c7v[:4\u0015-\\5msJ\u0002\u0013A\u0003;fgR4u\u000e\u001c3feV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006)!/\u001e7fg*\u0011\u0001/H\u0001\u0006UVt\u0017\u000e^\u0005\u0003e6\u0014q\u0002V3na>\u0014\u0018M]=G_2$WM]\u0001\fi\u0016\u001cHOR8mI\u0016\u0014\b%A\u0005cK\u001a|'/Z!mYR\t1)\u0001\u0005bMR,'/\u00117m\u0001")
public class BulkLoadSuite
extends FunSuite
implements BeforeAndAfterEach,
BeforeAndAfterAll {
    private final Logger logger;
    private transient SparkContext sc;
    private HBaseTestingUtility TEST_UTIL;
    private final String tableName;
    private final String columnFamily1;
    private final String columnFamily2;
    private final TemporaryFolder testFolder;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.run$((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    public HBaseTestingUtility TEST_UTIL() {
        return this.TEST_UTIL;
    }

    public void TEST_UTIL_$eq(HBaseTestingUtility x$1) {
        this.TEST_UTIL = x$1;
    }

    public String tableName() {
        return this.tableName;
    }

    public String columnFamily1() {
        return this.columnFamily1;
    }

    public String columnFamily2() {
        return this.columnFamily2;
    }

    public TemporaryFolder testFolder() {
        return this.testFolder;
    }

    public void beforeAll() {
        this.TEST_UTIL().startMiniCluster();
        this.logger().info(" - minicluster started");
        try {
            this.TEST_UTIL().deleteTable(TableName.valueOf((String)this.tableName()));
        }
        catch (Exception e) {
            this.logger().info(new StringBuilder(18).append(" - no table ").append(this.tableName()).append(" found").toString());
        }
        this.logger().info(" - created table");
        scala.collection.immutable.Map envMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Xmx", (Object)"512m")}));
        this.sc_$eq(new SparkContext("local", "test", null, (Seq)Nil$.MODULE$, (Map)envMap));
    }

    public void afterAll() {
        this.logger().info("shuting down minicluster");
        this.TEST_UTIL().shutdownMiniCluster();
        this.logger().info(" - minicluster shut down");
        this.TEST_UTIL().cleanupTestDir();
        this.sc().stop();
    }

    public static final /* synthetic */ Assertion $anonfun$new$7(BulkLoadSuite $this, FileSystem fs$1, FileStatus[] f1FileList$1, Configuration config$1, int i) {
        HFile.Reader reader = HFile.createReader((FileSystem)fs$1, (Path)f1FileList$1[i].getPath(), (CacheConfig)new CacheConfig(config$1), (Configuration)config$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reader.getCompressionAlgorithm().getName().equals("gz"), "reader.getCompressionAlgorithm().getName().equals(\"gz\")", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(reader.getDataBlockEncoding().name().equals("PREFIX"), "reader.getDataBlockEncoding().name().equals(\"PREFIX\")", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
    }

    public static final /* synthetic */ Assertion $anonfun$new$8(BulkLoadSuite $this, FileSystem fs$1, FileStatus[] f2FileList$1, Configuration config$1, int i) {
        HFile.Reader reader = HFile.createReader((FileSystem)fs$1, (Path)f2FileList$1[i].getPath(), (CacheConfig)new CacheConfig(config$1), (Configuration)config$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reader.getCompressionAlgorithm().getName().equals("none"), "reader.getCompressionAlgorithm().getName().equals(\"none\")", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(reader.getDataBlockEncoding().name().equals("NONE"), "reader.getDataBlockEncoding().name().equals(\"NONE\")", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
    }

    public static final /* synthetic */ void $anonfun$new$12(FamiliesQualifiersValues familyQualifiersValues$1, Tuple3 f) {
        byte[] family = (byte[])f._1();
        byte[] qualifier = (byte[])f._2();
        byte[] value = (byte[])f._3();
        familyQualifiersValues$1.$plus$eq(family, qualifier, value);
    }

    public static final /* synthetic */ void $anonfun$new$15(FamiliesQualifiersValues familyQualifiersValues$2, Tuple3 f) {
        byte[] family = (byte[])f._1();
        byte[] qualifier = (byte[])f._2();
        byte[] value = (byte[])f._3();
        familyQualifiersValues$2.$plus$eq(family, qualifier, value);
    }

    public static final /* synthetic */ void $anonfun$new$18(FamiliesQualifiersValues familyQualifiersValues$3, Tuple3 f) {
        byte[] family = (byte[])f._1();
        byte[] qualifier = (byte[])f._2();
        byte[] value = (byte[])f._3();
        familyQualifiersValues$3.$plus$eq(family, qualifier, value);
    }

    public static final /* synthetic */ Assertion $anonfun$new$19(BulkLoadSuite $this, FileSystem fs$2, FileStatus[] f1FileList$2, Configuration config$2, int i) {
        HFile.Reader reader = HFile.createReader((FileSystem)fs$2, (Path)f1FileList$2[i].getPath(), (CacheConfig)new CacheConfig(config$2), (Configuration)config$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reader.getCompressionAlgorithm().getName().equals("gz"), "reader.getCompressionAlgorithm().getName().equals(\"gz\")", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(reader.getDataBlockEncoding().name().equals("PREFIX"), "reader.getDataBlockEncoding().name().equals(\"PREFIX\")", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
    }

    public static final /* synthetic */ Assertion $anonfun$new$20(BulkLoadSuite $this, FileSystem fs$2, FileStatus[] f2FileList$2, Configuration config$2, int i) {
        HFile.Reader reader = HFile.createReader((FileSystem)fs$2, (Path)f2FileList$2[i].getPath(), (CacheConfig)new CacheConfig(config$2), (Configuration)config$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(reader.getCompressionAlgorithm().getName().equals("none"), "reader.getCompressionAlgorithm().getName().equals(\"none\")", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(reader.getDataBlockEncoding().name().equals("NONE"), "reader.getDataBlockEncoding().name().equals(\"NONE\")", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888));
    }

    public BulkLoadSuite() {
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        this.logger = LoggerFactory.getLogger(BulkLoadSuite.class);
        this.sc = null;
        this.TEST_UTIL = new HBaseTestingUtility();
        this.tableName = "t1";
        this.columnFamily1 = "f1";
        this.columnFamily2 = "f2";
        this.testFolder = new TemporaryFolder();
        this.test("Wide Row Bulk Load: Test multi family and multi column tests with all default HFile Configs.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}));
            SparkContext qual$1 = this.sc();
            WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)Bytes.toBytes((String)"5"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            hbaseContext.bulkLoad(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                byte[] rowKey = (byte[])t._1();
                byte[] family = (byte[])((Tuple3)t._2())._1();
                byte[] qualifier = (byte[])((Tuple3)t._2())._2();
                byte[] value = (byte[])((Tuple3)t._2())._3();
                KeyFamilyQualifier keyFamilyQualifier = new KeyFamilyQualifier(rowKey, family, qualifier);
                return ((IterableLike)new .colon.colon((Object)new Tuple2((Object)keyFamilyQualifier, (Object)value), (List)Nil$.MODULE$)).iterator();
            }, stagingFolder.getPath(), hbaseContext.bulkLoad$default$5(), hbaseContext.bulkLoad$default$6(), hbaseContext.bulkLoad$default$7());
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left2 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                java.util.List $org_scalatest_assert_macro_left3 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                java.util.List $org_scalatest_assert_macro_left4 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                java.util.List $org_scalatest_assert_macro_left5 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
                java.util.List $org_scalatest_assert_macro_left6 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Wide Row Bulk Load: Test HBase client: Test Roll Over and using an implicit call to bulk load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}));
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"c"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)Bytes.toBytes((String)"5"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkLoad(hbaseContext, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                byte[] rowKey = (byte[])t._1();
                byte[] family = (byte[])((Tuple3)t._2())._1();
                byte[] qualifier = (byte[])((Tuple3)t._2())._2();
                byte[] value = (byte[])((Tuple3)t._2())._3();
                KeyFamilyQualifier keyFamilyQualifier = new KeyFamilyQualifier(rowKey, family, qualifier);
                return ((IterableLike)new .colon.colon((Object)new Tuple2((Object)keyFamilyQualifier, (Object)value), (List)Nil$.MODULE$)).iterator();
            }, stagingFolder.getPath(), new HashMap(), false, 20L);
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            FileStatus[] $org_scalatest_assert_macro_left2 = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f1").toString()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left3 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
                java.util.List $org_scalatest_assert_macro_left4 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
                java.util.List $org_scalatest_assert_macro_left5 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                java.util.List $org_scalatest_assert_macro_left6 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right6 = 2;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
                java.util.List $org_scalatest_assert_macro_left7 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right7 = 1;
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("Wide Row Bulk Load: Test multi family and multi column tests with one column family with custom configs plus multi region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"2"), Bytes.toBytes((String)"4")};
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}), (byte[][])splitKeys);
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Bytes.toBytes((String)"1"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)Bytes.toBytes((String)"3"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)Bytes.toBytes((String)"5"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)Bytes.toBytes((String)"4"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)Bytes.toBytes((String)"2"), (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$6 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            HashMap<byte[], FamilyHFileWriteOptions> familyHBaseWriterOptions = new HashMap<byte[], FamilyHFileWriteOptions>();
            FamilyHFileWriteOptions f1Options = new FamilyHFileWriteOptions("GZ", "ROW", 128, "PREFIX");
            familyHBaseWriterOptions.put(Bytes.toBytes((String)this.columnFamily1()), f1Options);
            hbaseContext.bulkLoad(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                byte[] rowKey = (byte[])t._1();
                byte[] family = (byte[])((Tuple3)t._2())._1();
                byte[] qualifier = (byte[])((Tuple3)t._2())._2();
                byte[] value = (byte[])((Tuple3)t._2())._3();
                KeyFamilyQualifier keyFamilyQualifier = new KeyFamilyQualifier(rowKey, family, qualifier);
                return ((IterableLike)new .colon.colon((Object)new Tuple2((Object)keyFamilyQualifier, (Object)value), (List)Nil$.MODULE$)).iterator();
            }, stagingFolder.getPath(), familyHBaseWriterOptions, false, 0x280000000L);
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            FileStatus[] f1FileList = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f1").toString()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), f1FileList.length).foreach((Function1 & Serializable & scala.Serializable)i -> BulkLoadSuite.$anonfun$new$7(this, fs, f1FileList, config, BoxesRunTime.unboxToInt((Object)i)));
            int $org_scalatest_assert_macro_left2 = 3;
            int $org_scalatest_assert_macro_right2 = f1FileList.length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
            FileStatus[] f2FileList = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f2").toString()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), f2FileList.length).foreach((Function1 & Serializable & scala.Serializable)i -> BulkLoadSuite.$anonfun$new$8(this, fs, f2FileList, config, BoxesRunTime.unboxToInt((Object)i)));
            int $org_scalatest_assert_macro_left3 = 2;
            int $org_scalatest_assert_macro_right3 = f2FileList.length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left4 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
                java.util.List $org_scalatest_assert_macro_left5 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 430));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436));
                java.util.List $org_scalatest_assert_macro_left6 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
                java.util.List $org_scalatest_assert_macro_left7 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right7 = 2;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
                java.util.List $org_scalatest_assert_macro_left8 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right8 = 1;
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
                Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        this.test("Test partitioner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)""), Bytes.toBytes((String)"3"), Bytes.toBytes((String)"7")};
            BulkLoadPartitioner partitioner = new BulkLoadPartitioner((byte[][])splitKeys);
            int $org_scalatest_assert_macro_left = 0;
            int $org_scalatest_assert_macro_right = partitioner.getPartition((Object)Bytes.toBytes((String)""));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
            int $org_scalatest_assert_macro_left2 = 0;
            int $org_scalatest_assert_macro_right2 = partitioner.getPartition((Object)Bytes.toBytes((String)"1"));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            int $org_scalatest_assert_macro_left3 = 0;
            int $org_scalatest_assert_macro_right3 = partitioner.getPartition((Object)Bytes.toBytes((String)"2"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            int $org_scalatest_assert_macro_left4 = 1;
            int $org_scalatest_assert_macro_right4 = partitioner.getPartition((Object)Bytes.toBytes((String)"3"));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            int $org_scalatest_assert_macro_left5 = 1;
            int $org_scalatest_assert_macro_right5 = partitioner.getPartition((Object)Bytes.toBytes((String)"4"));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 495));
            int $org_scalatest_assert_macro_left6 = 1;
            int $org_scalatest_assert_macro_right6 = partitioner.getPartition((Object)Bytes.toBytes((String)"6"));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            int $org_scalatest_assert_macro_left7 = 2;
            int $org_scalatest_assert_macro_right7 = partitioner.getPartition((Object)Bytes.toBytes((String)"7"));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            int $org_scalatest_assert_macro_left8 = 2;
            int $org_scalatest_assert_macro_right8 = partitioner.getPartition((Object)Bytes.toBytes((String)"8"));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            splitKeys = new byte[][]{Bytes.toBytes((String)"")};
            partitioner = new BulkLoadPartitioner((byte[][])splitKeys);
            int $org_scalatest_assert_macro_left9 = 0;
            int $org_scalatest_assert_macro_right9 = partitioner.getPartition((Object)Bytes.toBytes((String)""));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 506));
            int $org_scalatest_assert_macro_left10 = 0;
            int $org_scalatest_assert_macro_right10 = partitioner.getPartition((Object)Bytes.toBytes((String)"1"));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
            int $org_scalatest_assert_macro_left11 = 0;
            int $org_scalatest_assert_macro_right11 = partitioner.getPartition((Object)Bytes.toBytes((String)"2"));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 == $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            int $org_scalatest_assert_macro_left12 = 0;
            int $org_scalatest_assert_macro_right12 = partitioner.getPartition((Object)Bytes.toBytes((String)"3"));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left12), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 == $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            int $org_scalatest_assert_macro_left13 = 0;
            int $org_scalatest_assert_macro_right13 = partitioner.getPartition((Object)Bytes.toBytes((String)"4"));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13 == $org_scalatest_assert_macro_right13, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
            int $org_scalatest_assert_macro_left14 = 0;
            int $org_scalatest_assert_macro_right14 = partitioner.getPartition((Object)Bytes.toBytes((String)"6"));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            int $org_scalatest_assert_macro_left15 = 0;
            int $org_scalatest_assert_macro_right15 = partitioner.getPartition((Object)Bytes.toBytes((String)"7"));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
            splitKeys = new byte[][]{Bytes.toBytes((String)""), Bytes.toBytes((String)"02"), Bytes.toBytes((String)"04"), Bytes.toBytes((String)"06"), Bytes.toBytes((String)"08"), Bytes.toBytes((String)"10"), Bytes.toBytes((String)"12")};
            partitioner = new BulkLoadPartitioner((byte[][])splitKeys);
            int $org_scalatest_assert_macro_left16 = 0;
            int $org_scalatest_assert_macro_right16 = partitioner.getPartition((Object)Bytes.toBytes((String)""));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left16), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 == $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            int $org_scalatest_assert_macro_left17 = 0;
            int $org_scalatest_assert_macro_right17 = partitioner.getPartition((Object)Bytes.toBytes((String)"01"));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left17), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17 == $org_scalatest_assert_macro_right17, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            int $org_scalatest_assert_macro_left18 = 1;
            int $org_scalatest_assert_macro_right18 = partitioner.getPartition((Object)Bytes.toBytes((String)"02"));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left18), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 == $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            int $org_scalatest_assert_macro_left19 = 1;
            int $org_scalatest_assert_macro_right19 = partitioner.getPartition((Object)Bytes.toBytes((String)"03"));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left19), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19 == $org_scalatest_assert_macro_right19, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            int $org_scalatest_assert_macro_left20 = 2;
            int $org_scalatest_assert_macro_right20 = partitioner.getPartition((Object)Bytes.toBytes((String)"04"));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left20), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20 == $org_scalatest_assert_macro_right20, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 529));
            int $org_scalatest_assert_macro_left21 = 2;
            int $org_scalatest_assert_macro_right21 = partitioner.getPartition((Object)Bytes.toBytes((String)"05"));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left21), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21 == $org_scalatest_assert_macro_right21, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            int $org_scalatest_assert_macro_left22 = 3;
            int $org_scalatest_assert_macro_right22 = partitioner.getPartition((Object)Bytes.toBytes((String)"06"));
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            int $org_scalatest_assert_macro_left23 = 3;
            int $org_scalatest_assert_macro_right23 = partitioner.getPartition((Object)Bytes.toBytes((String)"07"));
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left23), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23 == $org_scalatest_assert_macro_right23, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            int $org_scalatest_assert_macro_left24 = 4;
            int $org_scalatest_assert_macro_right24 = partitioner.getPartition((Object)Bytes.toBytes((String)"08"));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left24), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24 == $org_scalatest_assert_macro_right24, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            int $org_scalatest_assert_macro_left25 = 4;
            int $org_scalatest_assert_macro_right25 = partitioner.getPartition((Object)Bytes.toBytes((String)"09"));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left25), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25 == $org_scalatest_assert_macro_right25, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            int $org_scalatest_assert_macro_left26 = 5;
            int $org_scalatest_assert_macro_right26 = partitioner.getPartition((Object)Bytes.toBytes((String)"10"));
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left26), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26 == $org_scalatest_assert_macro_right26, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
            int $org_scalatest_assert_macro_left27 = 5;
            int $org_scalatest_assert_macro_right27 = partitioner.getPartition((Object)Bytes.toBytes((String)"11"));
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left27), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27 == $org_scalatest_assert_macro_right27, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            int $org_scalatest_assert_macro_left28 = 6;
            int $org_scalatest_assert_macro_right28 = partitioner.getPartition((Object)Bytes.toBytes((String)"12"));
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left28), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28 == $org_scalatest_assert_macro_right28, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
            int $org_scalatest_assert_macro_left29 = 6;
            int $org_scalatest_assert_macro_right29 = partitioner.getPartition((Object)Bytes.toBytes((String)"13"));
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left29), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29 == $org_scalatest_assert_macro_right29, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("Thin Row Bulk Load: Test multi family and multi column tests with all default HFile Configs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}));
            SparkContext qual$4 = this.sc();
            WrappedArray x$7 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)"5", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$8 = qual$4.parallelize$default$2();
            RDD rdd = RDD$.MODULE$.rddToPairRDDFunctions(qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            hbaseContext.bulkLoadThinRows(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                byte[] rowKey = Bytes.toBytes((String)((String)t._1()));
                FamiliesQualifiersValues familyQualifiersValues = new FamiliesQualifiersValues();
                ((IterableLike)t._2()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    BulkLoadSuite.$anonfun$new$12(familyQualifiersValues, f);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)new ByteArrayWrapper(rowKey), (Object)familyQualifiersValues);
            }, stagingFolder.getPath(), hbaseContext.bulkLoadThinRows$default$5(), hbaseContext.bulkLoadThinRows$default$6(), hbaseContext.bulkLoadThinRows$default$7());
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left2 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
                java.util.List $org_scalatest_assert_macro_left3 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
                java.util.List $org_scalatest_assert_macro_left4 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
                java.util.List $org_scalatest_assert_macro_left5 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
                java.util.List $org_scalatest_assert_macro_left6 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("Thin Row Bulk Load: Test HBase client: Test Roll Over and using an implicit call to bulk load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}));
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"c"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)"5", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$10 = qual$5.parallelize$default$2();
            RDD rdd = RDD$.MODULE$.rddToPairRDDFunctions(qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            HBaseRDDFunctions$.MODULE$.GenericHBaseRDDFunctions(rdd).hbaseBulkLoadThinRows(hbaseContext, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                String rowKey = (String)t._1();
                FamiliesQualifiersValues familyQualifiersValues = new FamiliesQualifiersValues();
                ((IterableLike)t._2()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    BulkLoadSuite.$anonfun$new$15(familyQualifiersValues, f);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)new ByteArrayWrapper(Bytes.toBytes((String)rowKey)), (Object)familyQualifiersValues);
            }, stagingFolder.getPath(), new HashMap(), false, 20L);
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 729));
            FileStatus[] $org_scalatest_assert_macro_left2 = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f1").toString()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left3 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
                java.util.List $org_scalatest_assert_macro_left4 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
                java.util.List $org_scalatest_assert_macro_left5 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
                java.util.List $org_scalatest_assert_macro_left6 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right6 = 2;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 769));
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
                java.util.List $org_scalatest_assert_macro_left7 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right7 = 1;
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        this.test("Thin Row Bulk Load: Test multi family and multi column tests with one column family with custom configs plus multi region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            Configuration config = this.TEST_UTIL().getConfiguration();
            byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"2"), Bytes.toBytes((String)"4")};
            this.logger().info(new StringBuilder(18).append(" - creating table ").append(this.tableName()).toString());
            this.TEST_UTIL().createTable(TableName.valueOf((String)this.tableName()), (byte[][])((Object[])new byte[][]{Bytes.toBytes((String)this.columnFamily1()), Bytes.toBytes((String)this.columnFamily2())}), (byte[][])splitKeys);
            SparkContext qual$6 = this.sc();
            WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"1", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo1"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo2.a"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.b"))), new Tuple2((Object)"3", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo2.c"))), new Tuple2((Object)"5", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo3"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"foo.1"))), new Tuple2((Object)"4", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily2()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"foo.2"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"a"), (Object)Bytes.toBytes((String)"bar.1"))), new Tuple2((Object)"2", (Object)new Tuple3((Object)Bytes.toBytes((String)this.columnFamily1()), (Object)Bytes.toBytes((String)"b"), (Object)Bytes.toBytes((String)"bar.2")))});
            int x$12 = qual$6.parallelize$default$2();
            RDD rdd = RDD$.MODULE$.rddToPairRDDFunctions(qual$6.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
            HBaseContext hbaseContext = new HBaseContext(this.sc(), config, HBaseContext$.MODULE$.$lessinit$greater$default$3());
            this.testFolder().create();
            File stagingFolder = this.testFolder().newFolder();
            HashMap<byte[], FamilyHFileWriteOptions> familyHBaseWriterOptions = new HashMap<byte[], FamilyHFileWriteOptions>();
            FamilyHFileWriteOptions f1Options = new FamilyHFileWriteOptions("GZ", "ROW", 128, "PREFIX");
            familyHBaseWriterOptions.put(Bytes.toBytes((String)this.columnFamily1()), f1Options);
            hbaseContext.bulkLoadThinRows(rdd, TableName.valueOf((String)this.tableName()), (Function1 & Serializable & scala.Serializable)t -> {
                String rowKey = (String)t._1();
                FamiliesQualifiersValues familyQualifiersValues = new FamiliesQualifiersValues();
                ((IterableLike)t._2()).foreach((Function1 & Serializable & scala.Serializable)f -> {
                    BulkLoadSuite.$anonfun$new$18(familyQualifiersValues, f);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)new ByteArrayWrapper(Bytes.toBytes((String)rowKey)), (Object)familyQualifiersValues);
            }, stagingFolder.getPath(), familyHBaseWriterOptions, false, 0x280000000L);
            FileSystem fs = FileSystem.get((Configuration)config);
            FileStatus[] $org_scalatest_assert_macro_left = fs.listStatus(new Path(stagingFolder.getPath()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            FileStatus[] f1FileList = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f1").toString()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), f1FileList.length).foreach((Function1 & Serializable & scala.Serializable)i -> BulkLoadSuite.$anonfun$new$19(this, fs, f1FileList, config, BoxesRunTime.unboxToInt((Object)i)));
            int $org_scalatest_assert_macro_left2 = 3;
            int $org_scalatest_assert_macro_right2 = f1FileList.length;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            FileStatus[] f2FileList = fs.listStatus(new Path(new StringBuilder(3).append(stagingFolder.getPath()).append("/f2").toString()));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), f2FileList.length).foreach((Function1 & Serializable & scala.Serializable)i -> BulkLoadSuite.$anonfun$new$20(this, fs, f2FileList, config, BoxesRunTime.unboxToInt((Object)i)));
            int $org_scalatest_assert_macro_left3 = 2;
            int $org_scalatest_assert_macro_right3 = f2FileList.length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 891));
            Connection conn = ConnectionFactory.createConnection((Configuration)config);
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Table table = conn.getTable(TableName.valueOf((String)this.tableName()));
            try {
                java.util.List cells1;
                java.util.List cells2;
                java.util.List cells3;
                java.util.List cells4;
                java.util.List cells5;
                load.doBulkLoad(new Path(stagingFolder.getPath()), conn.getAdmin(), table, conn.getRegionLocator(TableName.valueOf((String)this.tableName())));
                java.util.List $org_scalatest_assert_macro_left4 = cells5 = table.get(new Get(Bytes.toBytes((String)"5"))).listCells();
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells5.get(0)))).equals("foo3"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells5.get(0))).equals(\"foo3\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells5.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells5.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells5.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells5.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
                java.util.List $org_scalatest_assert_macro_left5 = cells4 = table.get(new Get(Bytes.toBytes((String)"4"))).listCells();
                int $org_scalatest_assert_macro_right5 = 2;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(0)))).equals("foo.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(0))).equals(\"foo.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 910));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 911));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells4.get(1)))).equals("foo.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells4.get(1))).equals(\"foo.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells4.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells4.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 914));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells4.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells4.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 915));
                java.util.List $org_scalatest_assert_macro_left6 = cells3 = table.get(new Get(Bytes.toBytes((String)"3"))).listCells();
                int $org_scalatest_assert_macro_right6 = 3;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(0)))).equals("foo2.c"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(0))).equals(\"foo2.c\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 921));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(1)))).equals("foo2.b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(1))).equals(\"foo2.b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 922));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(1)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(1))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(1)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(1))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 924));
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells3.get(2)))).equals("foo2.a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells3.get(2))).equals(\"foo2.a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 925));
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells3.get(2)))).equals("f2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells3.get(2))).equals(\"f2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926));
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells3.get(2)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells3.get(2))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 927));
                java.util.List $org_scalatest_assert_macro_left7 = cells2 = table.get(new Get(Bytes.toBytes((String)"2"))).listCells();
                int $org_scalatest_assert_macro_right7 = 2;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 931));
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(0)))).equals("bar.1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(0))).equals(\"bar.1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 933));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells2.get(1)))).equals("bar.2"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells2.get(1))).equals(\"bar.2\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells2.get(1)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells2.get(1))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells2.get(1)))).equals("b"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells2.get(1))).equals(\"b\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
                java.util.List $org_scalatest_assert_macro_left8 = cells1 = table.get(new Get(Bytes.toBytes((String)"1"))).listCells();
                int $org_scalatest_assert_macro_right8 = 1;
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940));
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells1.get(0)))).equals("foo1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneValue(cells1.get(0))).equals(\"foo1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 941));
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneFamily((Cell)((Cell)cells1.get(0)))).equals("f1"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneFamily(cells1.get(0))).equals(\"f1\")", Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
                Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.simpleMacroBool(Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)((Cell)cells1.get(0)))).equals("a"), "org.apache.hadoop.hbase.util.Bytes.toString(org.apache.hadoop.hbase.CellUtil.cloneQualifier(cells1.get(0))).equals(\"a\")", Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            }
            catch (Throwable throwable) {
                table.close();
                try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                    admin.disableTable(TableName.valueOf((String)this.tableName()));
                    admin.deleteTable(TableName.valueOf((String)this.tableName()));
                }
                fs.delete(new Path(stagingFolder.getPath()), true);
                this.testFolder().delete();
                throw throwable;
            }
            Assertion assertion2 = assertion;
            table.close();
            try (Admin admin = ConnectionFactory.createConnection((Configuration)config).getAdmin();){
                admin.disableTable(TableName.valueOf((String)this.tableName()));
                admin.deleteTable(TableName.valueOf((String)this.tableName()));
            }
            fs.delete(new Path(stagingFolder.getPath()), true);
            this.testFolder().delete();
            return assertion2;
        }, new Position("BulkLoadSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
    }
}

