/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.scram;

import java.io.IOException;
import java.security.AccessControlException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.scram.ScramServerCallbackHandler;
import org.apache.hadoop.hbase.security.scram.TokenAuthMethod;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.scram.CredentialCache;
import org.apache.hadoop.security.scram.ScramCredential;
import org.apache.hadoop.security.scram.ScramFormatter;
import org.apache.hadoop.security.scram.ScramMechanism;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ScramAuthMethod
extends TokenAuthMethod {
    private static final Logger LOG = LoggerFactory.getLogger(ScramAuthMethod.class);
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private String defaultMechanismName = "SCRAM-SHA-256";
    private final String scramPasswordConf = "scram.password";
    private String password;
    private String scramConfig = "scram/scram-site.xml";
    public static final TokenAuthMethod INSTANCE = new ScramAuthMethod();
    CredentialCache credentialCache = null;
    Configuration conf;

    private ScramAuthMethod() {
        super((byte)84, "tokenScram", "SCRAM-SHA-256", UserGroupInformation.AuthenticationMethod.TOKEN);
    }

    private void createCache() {
        this.conf = new Configuration();
        this.conf.addResource(this.scramConfig);
        this.credentialCache = new CredentialCache();
        try {
            this.credentialCache.createCache(this.defaultMechanismName, ScramCredential.class);
            ScramFormatter formatter = new ScramFormatter(ScramMechanism.SCRAM_SHA_256);
            this.password = new String(this.conf.getPassword("scram.password"));
            ScramCredential generatedCred = formatter.generateCredential(this.password, 4096);
            CredentialCache.Cache sha256Cache = this.credentialCache.cache(this.defaultMechanismName, ScramCredential.class);
            sha256Cache.put(UserGroupInformation.getLoginUser().getUserName(), (Object)generatedCred);
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error(FATAL, "Can't find " + this.defaultMechanismName + " algorithm.");
        }
        catch (IOException ex) {
            LOG.error(FATAL, "Exception while getting login user", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public SaslServer createSaslServer(RpcServer.Connection connection, Map<String, Object> saslProperties) throws IOException {
        SecretManager secretManager = (SecretManager)saslProperties.get("org.apache.hadoop.auth.secret.manager");
        if (secretManager == null) {
            throw new AccessControlException("Server is not configured to do SCRAM authentication.");
        }
        if (this.credentialCache == null) {
            this.createCache();
        }
        return Sasl.createSaslServer(this.mechanismName, null, "default", saslProperties, new ScramServerCallbackHandler((CredentialCache.Cache<ScramCredential>)this.credentialCache.cache(this.defaultMechanismName, ScramCredential.class), (SecretManager<TokenIdentifier>)secretManager, connection));
    }
}

