/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper.lock;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hadoop.hbase.MultithreadedTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessReadLock;
import org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessReadWriteLock;
import org.apache.hadoop.hbase.zookeeper.lock.ZKInterProcessWriteLock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZKInterProcessReadWriteLock {
    private static final Log LOG = LogFactory.getLog(TestZKInterProcessReadWriteLock.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_THREADS = 10;
    private static Configuration conf;
    private final AtomicBoolean isLockHeld = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)new DaemonThreadFactory("TestZKInterProcessReadWriteLock-"));

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TEST_UTIL.startMiniZKCluster();
        conf.setInt("zookeeper.session.timeout", 1000);
        ZooKeeperWatcher zkw = TestZKInterProcessReadWriteLock.getZooKeeperWatcher("setup");
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)zkw.tableLockZNode);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDown() {
        this.executor.shutdown();
    }

    private static ZooKeeperWatcher getZooKeeperWatcher(String desc) throws IOException {
        return TEST_UTIL.getZooKeeperWatcher();
    }

    @Test(timeout=30000L)
    public void testWriteLockExcludesWriters() throws Exception {
        String testName = "testWriteLockExcludesWriters";
        final ZKInterProcessReadWriteLock readWriteLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testWriteLockExcludesWriters");
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            final String threadDesc = "testWriteLockExcludesWriters" + i;
            results.add(this.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    ZKInterProcessWriteLock writeLock = readWriteLock.writeLock(Bytes.toBytes((String)threadDesc));
                    try {
                        writeLock.acquire();
                        try {
                            Assert.assertTrue((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.compareAndSet(false, true));
                            Thread.sleep(1000L);
                            Assert.assertTrue((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.compareAndSet(true, false));
                        }
                        finally {
                            TestZKInterProcessReadWriteLock.this.isLockHeld.set(false);
                            writeLock.release();
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)(threadDesc + " interrupted"), (Throwable)e);
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                    return null;
                }
            }));
        }
        MultithreadedTestUtil.assertOnFutures(results);
    }

    @Test(timeout=30000L)
    public void testReadLockDoesNotExcludeReaders() throws Exception {
        String testName = "testReadLockDoesNotExcludeReaders";
        final ZKInterProcessReadWriteLock readWriteLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testReadLockDoesNotExcludeReaders");
        final CountDownLatch locksAcquiredLatch = new CountDownLatch(10);
        final AtomicInteger locksHeld = new AtomicInteger(0);
        ArrayList results = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            final String threadDesc = "testReadLockDoesNotExcludeReaders" + i;
            results.add(this.executor.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ZKInterProcessReadLock readLock = readWriteLock.readLock(Bytes.toBytes((String)threadDesc));
                    readLock.acquire();
                    try {
                        locksHeld.incrementAndGet();
                        locksAcquiredLatch.countDown();
                        Thread.sleep(1000L);
                    }
                    finally {
                        readLock.release();
                        locksHeld.decrementAndGet();
                    }
                    return null;
                }
            }));
        }
        locksAcquiredLatch.await();
        Assert.assertEquals((long)locksHeld.get(), (long)10L);
        MultithreadedTestUtil.assertOnFutures(results);
    }

    @Test(timeout=30000L)
    public void testReadLockExcludesWriters() throws Exception {
        String testName = "testReadLockExcludesWriters";
        ArrayList results = Lists.newArrayList();
        final CountDownLatch readLockAcquiredLatch = new CountDownLatch(1);
        Callable<Void> acquireReadLock = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testReadLockExcludesWriters-acquireReadLock";
                ZKInterProcessReadLock readLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testReadLockExcludesWriters").readLock(Bytes.toBytes((String)"testReadLockExcludesWriters-acquireReadLock"));
                readLock.acquire();
                try {
                    Assert.assertTrue((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.compareAndSet(false, true));
                    readLockAcquiredLatch.countDown();
                    Thread.sleep(1000L);
                }
                finally {
                    TestZKInterProcessReadWriteLock.this.isLockHeld.set(false);
                    readLock.release();
                }
                return null;
            }
        };
        Callable<Void> acquireWriteLock = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testReadLockExcludesWriters-acquireWriteLock";
                ZKInterProcessWriteLock writeLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testReadLockExcludesWriters").writeLock(Bytes.toBytes((String)"testReadLockExcludesWriters-acquireWriteLock"));
                readLockAcquiredLatch.await();
                Assert.assertTrue((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.get());
                writeLock.acquire();
                try {
                    Assert.assertFalse((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.get());
                }
                finally {
                    writeLock.release();
                }
                return null;
            }
        };
        results.add(this.executor.submit(acquireReadLock));
        results.add(this.executor.submit(acquireWriteLock));
        MultithreadedTestUtil.assertOnFutures(results);
    }

    private static ZKInterProcessReadWriteLock getReadWriteLock(String testName) throws IOException {
        InterProcessLock.MetadataHandler handler = new InterProcessLock.MetadataHandler(){

            public void handleMetadata(byte[] ownerMetadata) {
                LOG.info((Object)("Lock info: " + Bytes.toString((byte[])ownerMetadata)));
            }
        };
        ZooKeeperWatcher zkWatcher = TestZKInterProcessReadWriteLock.getZooKeeperWatcher(testName);
        String znode = ZKUtil.joinZNode((String)zkWatcher.tableLockZNode, (String)testName);
        return new ZKInterProcessReadWriteLock(zkWatcher, znode, handler);
    }

    @Test(timeout=30000L)
    public void testWriteLockExcludesReaders() throws Exception {
        String testName = "testReadLockExcludesWriters";
        ArrayList results = Lists.newArrayList();
        final CountDownLatch writeLockAcquiredLatch = new CountDownLatch(1);
        Callable<Void> acquireWriteLock = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testReadLockExcludesWriters-acquireWriteLock";
                ZKInterProcessWriteLock writeLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testReadLockExcludesWriters").writeLock(Bytes.toBytes((String)"testReadLockExcludesWriters-acquireWriteLock"));
                writeLock.acquire();
                try {
                    writeLockAcquiredLatch.countDown();
                    Assert.assertTrue((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.compareAndSet(false, true));
                    Thread.sleep(1000L);
                }
                finally {
                    TestZKInterProcessReadWriteLock.this.isLockHeld.set(false);
                    writeLock.release();
                }
                return null;
            }
        };
        Callable<Void> acquireReadLock = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testReadLockExcludesWriters-acquireReadLock";
                ZKInterProcessReadLock readLock = TestZKInterProcessReadWriteLock.getReadWriteLock("testReadLockExcludesWriters").readLock(Bytes.toBytes((String)"testReadLockExcludesWriters-acquireReadLock"));
                writeLockAcquiredLatch.await();
                readLock.acquire();
                try {
                    Assert.assertFalse((boolean)TestZKInterProcessReadWriteLock.this.isLockHeld.get());
                }
                finally {
                    readLock.release();
                }
                return null;
            }
        };
        results.add(this.executor.submit(acquireWriteLock));
        results.add(this.executor.submit(acquireReadLock));
        MultithreadedTestUtil.assertOnFutures(results);
    }

    @Test(timeout=60000L)
    public void testTimeout() throws Exception {
        String testName = "testTimeout";
        final CountDownLatch lockAcquiredLatch = new CountDownLatch(1);
        Callable<Void> shouldHog = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testTimeout-shouldHog";
                ZKInterProcessWriteLock lock = TestZKInterProcessReadWriteLock.getReadWriteLock("testTimeout").writeLock(Bytes.toBytes((String)"testTimeout-shouldHog"));
                lock.acquire();
                lockAcquiredLatch.countDown();
                Thread.sleep(10000L);
                lock.release();
                return null;
            }
        };
        Callable<Void> shouldTimeout = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testTimeout-shouldTimeout";
                ZKInterProcessWriteLock lock = TestZKInterProcessReadWriteLock.getReadWriteLock("testTimeout").writeLock(Bytes.toBytes((String)"testTimeout-shouldTimeout"));
                lockAcquiredLatch.await();
                Assert.assertFalse((boolean)lock.tryAcquire(5000L));
                return null;
            }
        };
        Callable<Void> shouldAcquireLock = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String threadDesc = "testTimeout-shouldAcquireLock";
                ZKInterProcessWriteLock lock = TestZKInterProcessReadWriteLock.getReadWriteLock("testTimeout").writeLock(Bytes.toBytes((String)"testTimeout-shouldAcquireLock"));
                lockAcquiredLatch.await();
                Assert.assertTrue((boolean)lock.tryAcquire(30000L));
                lock.release();
                return null;
            }
        };
        ArrayList results = Lists.newArrayList();
        results.add(this.executor.submit(shouldHog));
        results.add(this.executor.submit(shouldTimeout));
        results.add(this.executor.submit(shouldAcquireLock));
        MultithreadedTestUtil.assertOnFutures(results);
    }

    @Test(timeout=60000L)
    public void testMultipleClients() throws Exception {
        String testName = "testMultipleClients";
        ZooKeeperWatcher zkWatcher1 = new ZooKeeperWatcher(conf, "testMultipleClients-1", null);
        ZooKeeperWatcher zkWatcher2 = new ZooKeeperWatcher(conf, "testMultipleClients-2", null);
        String znode = ZKUtil.joinZNode((String)zkWatcher1.tableLockZNode, (String)"testMultipleClients");
        ZKInterProcessReadWriteLock clientLock1 = new ZKInterProcessReadWriteLock(zkWatcher1, znode, null);
        ZKInterProcessReadWriteLock clientLock2 = new ZKInterProcessReadWriteLock(zkWatcher2, znode, null);
        ZKInterProcessReadLock lock1 = clientLock1.readLock(Bytes.toBytes((String)"client1"));
        lock1.acquire();
        ZKInterProcessWriteLock lock2 = clientLock2.writeLock(Bytes.toBytes((String)"client2"));
        Assert.assertFalse((boolean)lock2.tryAcquire(1000L));
        lock1.release();
        Assert.assertTrue((boolean)lock2.tryAcquire(5000L));
        lock2.release();
        zkWatcher1.close();
        zkWatcher2.close();
    }
}

