/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;

public abstract class MultiThreadedAction {
    private static final Log LOG = LogFactory.getLog(MultiThreadedAction.class);
    protected final TableName tableName;
    protected final Configuration conf;
    protected final HConnection connection;
    protected int numThreads = 1;
    protected long startKey = 0L;
    protected long endKey = 1L;
    protected AtomicInteger numThreadsWorking = new AtomicInteger();
    protected AtomicLong numKeys = new AtomicLong();
    protected AtomicLong numCols = new AtomicLong();
    protected AtomicLong totalOpTimeMs = new AtomicLong();
    protected boolean verbose = false;
    protected LoadTestDataGenerator dataGenerator = null;
    private String actionLetter;
    private boolean streamingCounters;
    public static final int REPORTING_INTERVAL_MS = 5000;

    public MultiThreadedAction(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, String actionLetter) throws IOException {
        this.conf = conf;
        this.dataGenerator = dataGen;
        this.tableName = tableName;
        this.actionLetter = actionLetter;
        this.connection = HConnectionManager.createConnection((Configuration)conf);
    }

    public void start(long startKey, long endKey, int numThreads) throws IOException {
        this.startKey = startKey;
        this.endKey = endKey;
        this.numThreads = numThreads;
        new Thread((Runnable)new ProgressReporter(this.actionLetter), "MultiThreadedAction-ProgressReporter-" + System.currentTimeMillis()).start();
    }

    private static String formatTime(long elapsedTime) {
        String format = String.format("%%0%dd", 2);
        String seconds = String.format(format, (elapsedTime /= 1000L) % 60L);
        String minutes = String.format(format, elapsedTime % 3600L / 60L);
        String hours = String.format(format, elapsedTime / 3600L);
        String time = hours + ":" + minutes + ":" + seconds;
        return time;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not close the connection: " + ex));
            }
        }
    }

    public void waitForFinish() {
        while (this.numThreadsWorking.get() != 0) {
            Threads.sleepWithoutInterrupt((long)1000L);
        }
        this.close();
    }

    public boolean isDone() {
        return this.numThreadsWorking.get() == 0;
    }

    protected void startThreads(Collection<? extends Thread> threads) {
        this.numThreadsWorking.addAndGet(threads.size());
        for (Thread thread : threads) {
            thread.start();
        }
    }

    public long getEndKey() {
        return this.endKey;
    }

    protected abstract String progressInfo();

    protected static void appendToStatus(StringBuilder sb, String desc, long v) {
        if (v == 0L) {
            return;
        }
        sb.append(", ");
        sb.append(desc);
        sb.append("=");
        sb.append(v);
    }

    protected static void appendToStatus(StringBuilder sb, String desc, String v) {
        sb.append(", ");
        sb.append(desc);
        sb.append("=");
        sb.append(v);
    }

    public boolean verifyResultAgainstDataGenerator(Result result, boolean verifyValues) {
        return this.verifyResultAgainstDataGenerator(result, verifyValues, false);
    }

    public boolean verifyResultAgainstDataGenerator(Result result, boolean verifyValues, boolean verifyCfAndColumnIntegrity) {
        String rowKeyStr = Bytes.toString((byte[])result.getRow());
        if (result.isEmpty()) {
            LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], no data returned"));
            this.printLocations(result);
            return false;
        }
        if (!verifyValues && !verifyCfAndColumnIntegrity) {
            return true;
        }
        byte[][] expectedCfs = this.dataGenerator.getColumnFamilies();
        if (verifyCfAndColumnIntegrity && expectedCfs.length != result.getMap().size()) {
            LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], bad family count: " + result.getMap().size()));
            this.printLocations(result);
            return false;
        }
        for (byte[] cf : result.getMap().keySet()) {
            String cfStr = Bytes.toString((byte[])cf);
            NavigableMap columnValues = result.getFamilyMap(cf);
            if (columnValues == null) {
                LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], no data for family [" + cfStr + "]]"));
                this.printLocations(result);
                return false;
            }
            Map<String, ClientProtos.MutationProto.MutationType> mutateInfo = null;
            if (!verifyCfAndColumnIntegrity && !verifyValues) continue;
            if (!columnValues.containsKey(LoadTestDataGenerator.MUTATE_INFO)) {
                LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [" + Bytes.toString((byte[])LoadTestDataGenerator.MUTATE_INFO) + "]; value is not found"));
                this.printLocations(result);
                return false;
            }
            long cfHash = Arrays.hashCode(cf);
            byte[] mutateInfoValue = (byte[])columnValues.remove(LoadTestDataGenerator.MUTATE_INFO);
            mutateInfo = this.parseMutateInfo(mutateInfoValue);
            for (Map.Entry<String, ClientProtos.MutationProto.MutationType> mutate : mutateInfo.entrySet()) {
                byte[] column;
                long columnHash;
                long hashCode;
                if (mutate.getValue() != ClientProtos.MutationProto.MutationType.DELETE || (hashCode = cfHash + (columnHash = (long)Arrays.hashCode(column = Bytes.toBytes((String)mutate.getKey())))) % 2L != 0L) continue;
                if (columnValues.containsKey(column)) {
                    LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [" + mutate.getKey() + "]; should be deleted"));
                    this.printLocations(result);
                    return false;
                }
                byte[] hashCodeBytes = Bytes.toBytes((long)hashCode);
                columnValues.put(column, hashCodeBytes);
            }
            if (!columnValues.containsKey(LoadTestDataGenerator.INCREMENT)) {
                LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [" + Bytes.toString((byte[])LoadTestDataGenerator.INCREMENT) + "]; value is not found"));
                this.printLocations(result);
                return false;
            }
            long currentValue = Bytes.toLong((byte[])((byte[])columnValues.remove(LoadTestDataGenerator.INCREMENT)));
            if (verifyValues) {
                long amount = mutateInfo.isEmpty() ? 0L : cfHash;
                long originalValue = Arrays.hashCode(result.getRow());
                long extra = currentValue - originalValue;
                if (extra != 0L && (amount == 0L || extra % amount != 0L)) {
                    LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [increment], extra [" + extra + "], amount [" + amount + "]"));
                    this.printLocations(result);
                    return false;
                }
                if (amount != 0L && extra != amount) {
                    LOG.warn((Object)("Warning checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [increment], incremented [" + extra / amount + "] times"));
                }
            }
            if (verifyCfAndColumnIntegrity && !this.dataGenerator.verify(result.getRow(), cf, columnValues.keySet())) {
                Object colsStr = "";
                for (byte[] col : columnValues.keySet()) {
                    if (((String)colsStr).length() > 0) {
                        colsStr = (String)colsStr + ", ";
                    }
                    colsStr = (String)colsStr + "[" + Bytes.toString((byte[])col) + "]";
                }
                LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], bad columns for family [" + cfStr + "]: " + (String)colsStr));
                this.printLocations(result);
                return false;
            }
            if (!verifyValues) continue;
            for (Map.Entry kv : columnValues.entrySet()) {
                String column = Bytes.toString((byte[])((byte[])kv.getKey()));
                ClientProtos.MutationProto.MutationType mutation = mutateInfo.get(column);
                boolean verificationNeeded = true;
                byte[] bytes = (byte[])kv.getValue();
                if (mutation != null) {
                    boolean mutationVerified = true;
                    long columnHash = Arrays.hashCode((byte[])kv.getKey());
                    long hashCode = cfHash + columnHash;
                    byte[] hashCodeBytes = Bytes.toBytes((long)hashCode);
                    if (mutation == ClientProtos.MutationProto.MutationType.APPEND) {
                        int offset = bytes.length - hashCodeBytes.length;
                        boolean bl = mutationVerified = offset > 0 && Bytes.equals((byte[])hashCodeBytes, (int)0, (int)hashCodeBytes.length, (byte[])bytes, (int)offset, (int)hashCodeBytes.length);
                        if (mutationVerified) {
                            int newOffset;
                            int n = 1;
                            while ((newOffset = offset - hashCodeBytes.length) >= 0 && Bytes.equals((byte[])hashCodeBytes, (int)0, (int)hashCodeBytes.length, (byte[])bytes, (int)newOffset, (int)hashCodeBytes.length)) {
                                offset = newOffset;
                                ++n;
                            }
                            if (n > 1) {
                                LOG.warn((Object)("Warning checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [" + column + "], appended [" + n + "] times"));
                            }
                            byte[] dest = new byte[offset];
                            System.arraycopy(bytes, 0, dest, 0, offset);
                            bytes = dest;
                        }
                    } else if (hashCode % 2L == 0L) {
                        mutationVerified = Bytes.equals((byte[])bytes, (byte[])hashCodeBytes);
                        verificationNeeded = false;
                    }
                    if (!mutationVerified) {
                        LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], mutation checking failed for column family [" + cfStr + "], column [" + column + "]; mutation [" + mutation + "], hashCode [" + hashCode + "], verificationNeeded [" + verificationNeeded + "]"));
                        this.printLocations(result);
                        return false;
                    }
                }
                if (!verificationNeeded || this.dataGenerator.verify(result.getRow(), cf, (byte[])kv.getKey(), bytes)) continue;
                LOG.error((Object)("Error checking data for key [" + rowKeyStr + "], column family [" + cfStr + "], column [" + column + "], mutation [" + mutation + "]; value of length " + bytes.length));
                this.printLocations(result);
                return false;
            }
        }
        return true;
    }

    private void printLocations(Result r) {
        HRegionLocation[] locations;
        RegionLocations rl = null;
        if (r == null) {
            LOG.info((Object)"FAILED FOR null Result");
            return;
        }
        LOG.info((Object)("FAILED FOR " + this.resultToString(r) + " Stale " + r.isStale()));
        if (r.getRow() == null) {
            return;
        }
        try {
            rl = ((ClusterConnection)this.connection).locateRegion(this.tableName, r.getRow(), true, true);
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't get locations for row " + Bytes.toString((byte[])r.getRow())));
        }
        if (rl != null && (locations = rl.getRegionLocations()) != null) {
            for (HRegionLocation h : locations) {
                LOG.info((Object)("LOCATION " + h));
            }
        }
    }

    private String resultToString(Result result) {
        StringBuilder sb = new StringBuilder();
        sb.append("cells=");
        if (result.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell cell : result.listCells()) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(CellUtil.toString((Cell)cell, (boolean)true));
        }
        sb.append("}");
        return sb.toString();
    }

    private Map<String, ClientProtos.MutationProto.MutationType> parseMutateInfo(byte[] mutateInfo) {
        HashMap<String, ClientProtos.MutationProto.MutationType> mi = new HashMap<String, ClientProtos.MutationProto.MutationType>();
        if (mutateInfo != null) {
            String[] mutations;
            String mutateInfoStr = Bytes.toString((byte[])mutateInfo);
            for (String mutation : mutations = mutateInfoStr.split("#")) {
                if (mutation.isEmpty()) continue;
                Preconditions.checkArgument((boolean)mutation.contains(":"), (Object)("Invalid mutation info " + mutation));
                int p = mutation.indexOf(":");
                String column = mutation.substring(0, p);
                ClientProtos.MutationProto.MutationType type = ClientProtos.MutationProto.MutationType.valueOf((int)Integer.parseInt(mutation.substring(p + 1)));
                mi.put(column, type);
            }
        }
        return mi;
    }

    private class ProgressReporter
    implements Runnable {
        private String reporterId = "";

        public ProgressReporter(String id) {
            this.reporterId = id;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            long priorNumKeys = 0L;
            long priorCumulativeOpTime = 0L;
            int priorAverageKeysPerSecond = 0;
            Threads.sleep((long)5000L);
            while (MultiThreadedAction.this.numThreadsWorking.get() != 0) {
                String threadsLeft = "[" + this.reporterId + ":" + MultiThreadedAction.this.numThreadsWorking.get() + "] ";
                if (MultiThreadedAction.this.numKeys.get() == 0L) {
                    LOG.info((Object)(threadsLeft + "Number of keys = 0"));
                } else {
                    long numKeys = MultiThreadedAction.this.numKeys.get();
                    long time = System.currentTimeMillis() - startTime;
                    long totalOpTime = MultiThreadedAction.this.totalOpTimeMs.get();
                    long numKeysDelta = numKeys - priorNumKeys;
                    long totalOpTimeDelta = totalOpTime - priorCumulativeOpTime;
                    double averageKeysPerSecond = time > 0L ? (double)(numKeys * 1000L / time) : 0.0;
                    LOG.info((Object)(threadsLeft + "Keys=" + numKeys + ", cols=" + StringUtils.humanReadableInt((long)MultiThreadedAction.this.numCols.get()) + ", time=" + MultiThreadedAction.formatTime(time) + (String)(numKeys > 0L && time > 0L ? " Overall: [keys/s= " + numKeys * 1000L / time + ", latency=" + String.format("%.2f", (double)totalOpTime / (double)numKeys) + " ms]" : "") + (String)(numKeysDelta > 0L ? " Current: [keys/s=" + numKeysDelta * 1000L / 5000L + ", latency=" + String.format("%.2f", (double)totalOpTimeDelta / (double)numKeysDelta) + " ms]" : "") + MultiThreadedAction.this.progressInfo()));
                    if (MultiThreadedAction.this.streamingCounters) {
                        this.printStreamingCounters(numKeysDelta, averageKeysPerSecond - (double)priorAverageKeysPerSecond);
                    }
                    priorNumKeys = numKeys;
                    priorCumulativeOpTime = totalOpTime;
                    priorAverageKeysPerSecond = (int)averageKeysPerSecond;
                }
                Threads.sleep((long)5000L);
            }
        }

        private void printStreamingCounters(long numKeysDelta, double avgKeysPerSecondDelta) {
            System.err.println("reporter:counter:numKeys," + this.reporterId + "," + numKeysDelta);
            System.err.println("reporter:counter:numCols," + this.reporterId + "," + MultiThreadedAction.this.numCols.get());
            System.err.println("reporter:counter:avgKeysPerSecond," + this.reporterId + "," + (long)avgKeysPerSecondDelta);
        }
    }

    public static class DefaultDataGenerator
    extends LoadTestDataGenerator {
        private byte[][] columnFamilies = null;
        private int minColumnsPerKey;
        private int maxColumnsPerKey;
        private final Random random = new Random();

        public DefaultDataGenerator(int minValueSize, int maxValueSize, int minColumnsPerKey, int maxColumnsPerKey, byte[] ... columnFamilies) {
            super(minValueSize, maxValueSize);
            this.columnFamilies = columnFamilies;
            this.minColumnsPerKey = minColumnsPerKey;
            this.maxColumnsPerKey = maxColumnsPerKey;
        }

        public DefaultDataGenerator(byte[] ... columnFamilies) {
            this(256, 1024, 1, 10, columnFamilies);
        }

        @Override
        public byte[] getDeterministicUniqueKey(long keyBase) {
            return LoadTestKVGenerator.md5PrefixedKey((long)keyBase).getBytes();
        }

        @Override
        public byte[][] getColumnFamilies() {
            return this.columnFamilies;
        }

        @Override
        public byte[][] generateColumnsForCf(byte[] rowKey, byte[] cf) {
            int numColumns = this.minColumnsPerKey + this.random.nextInt(this.maxColumnsPerKey - this.minColumnsPerKey + 1);
            byte[][] columns = new byte[numColumns][];
            for (int i = 0; i < numColumns; ++i) {
                columns[i] = Integer.toString(i).getBytes();
            }
            return columns;
        }

        @Override
        public byte[] generateValue(byte[] rowKey, byte[] cf, byte[] column) {
            return this.kvGenerator.generateRandomSizeValue((byte[][])new byte[][]{rowKey, cf, column});
        }

        @Override
        public boolean verify(byte[] rowKey, byte[] cf, byte[] column, byte[] value) {
            return LoadTestKVGenerator.verify((byte[])value, (byte[][])new byte[][]{rowKey, cf, column});
        }

        @Override
        public boolean verify(byte[] rowKey, byte[] cf, Set<byte[]> columnSet) {
            return columnSet.size() >= this.minColumnsPerKey && columnSet.size() <= this.maxColumnsPerKey;
        }
    }
}

