/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.regionserver.KeyValueScanFixture;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueScanFixture
extends TestCase {
    public void testKeyValueScanFixture() throws IOException {
        KeyValue[] kvs = new KeyValue[]{KeyValueTestUtil.create((String)"RowA", (String)"family", (String)"qf1", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-1"), KeyValueTestUtil.create((String)"RowA", (String)"family", (String)"qf2", (long)1L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-2"), KeyValueTestUtil.create((String)"RowB", (String)"family", (String)"qf1", (long)10L, (KeyValue.Type)KeyValue.Type.Put, (String)"value-10")};
        KeyValueScanFixture scan = new KeyValueScanFixture(KeyValue.COMPARATOR, kvs);
        KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowA"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek((Cell)kv));
        Cell res = scan.peek();
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)res);
        kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowB"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek((Cell)kv));
        res = scan.peek();
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)res);
        kv = KeyValueUtil.createFirstOnRow((byte[])Bytes.toBytes((String)"RowA"));
        TestKeyValueScanFixture.assertTrue((boolean)scan.seek((Cell)kv));
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[0], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals((Object)kvs[1], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[1], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals((Object)kvs[2], (Object)scan.next());
        TestKeyValueScanFixture.assertEquals(null, (Object)scan.peek());
        TestKeyValueScanFixture.assertEquals(null, (Object)scan.next());
    }
}

