/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestSnapshotWithAcl
extends SecureTestUtil {
    public TableName TEST_TABLE = TableName.valueOf((String)UUID.randomUUID().toString());
    private static final int ROW_COUNT = 30000;
    private static byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static byte[] TEST_QUALIFIER = Bytes.toBytes((String)"cq");
    private static byte[] TEST_ROW = Bytes.toBytes((int)0);
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    private static HBaseAdmin admin;
    private static User USER_OWNER;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_NONE;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestSnapshotWithAcl.enableSecurity(conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        TestSnapshotWithAcl.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"usernone", (String[])new String[0]);
    }

    @Before
    public void setUp() throws Exception {
        admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitTableEnabled(this.TEST_TABLE);
        TestSnapshotWithAcl.grantOnTable(TEST_UTIL, USER_RW.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestSnapshotWithAcl.grantOnTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() throws IOException {
        try (HTable hTable = new HTable(conf, this.TEST_TABLE);){
            for (int i = 0; i < 30000; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)i));
                hTable.put(put);
            }
            hTable.flushCommits();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRows(TableName tableName) throws IOException {
        try (HTable hTable = new HTable(conf, tableName);){
            Result result;
            Scan scan = new Scan();
            ResultScanner scanner = hTable.getScanner(scan);
            int rowCount = 0;
            while ((result = scanner.next()) != null) {
                byte[] value = result.getValue(TEST_FAMILY, TEST_QUALIFIER);
                Assert.assertArrayEquals((byte[])value, (byte[])Bytes.toBytes((int)rowCount++));
            }
            Assert.assertEquals((long)rowCount, (long)30000L);
        }
    }

    @Test
    public void testRestoreSnapshot() throws Exception {
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RO, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_NONE);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        this.loadData();
        this.verifyRows(this.TEST_TABLE);
        String snapshotName1 = UUID.randomUUID().toString();
        admin.snapshot(snapshotName1, this.TEST_TABLE);
        TableName tableName1 = TableName.valueOf((String)UUID.randomUUID().toString());
        admin.cloneSnapshot(snapshotName1, tableName1, true);
        this.verifyRows(tableName1);
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(tableName1), USER_OWNER, USER_RO, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(tableName1), USER_NONE);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(tableName1), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(tableName1), USER_RO, USER_NONE);
        TableName tableName2 = TableName.valueOf((String)UUID.randomUUID().toString());
        admin.cloneSnapshot(snapshotName1, tableName2, false);
        this.verifyRows(tableName2);
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(tableName2), USER_OWNER);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(tableName2), USER_NONE, USER_RO, USER_RW);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(tableName2), USER_OWNER);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(tableName2), USER_RO, USER_RW, USER_NONE);
        TestSnapshotWithAcl.revokeFromTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE, TEST_FAMILY, null, Permission.Action.READ);
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_RO, USER_NONE);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        admin.disableTable(this.TEST_TABLE);
        admin.restoreSnapshot(snapshotName1, false, false);
        admin.enableTable(this.TEST_TABLE);
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_RO, USER_NONE);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
        admin.disableTable(this.TEST_TABLE);
        admin.restoreSnapshot(snapshotName1, false, true);
        admin.enableTable(this.TEST_TABLE);
        TestSnapshotWithAcl.verifyAllowed(new AccessReadAction(this.TEST_TABLE), USER_OWNER, USER_RO, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessReadAction(this.TEST_TABLE), USER_NONE);
        TestSnapshotWithAcl.verifyAllowed(new AccessWriteAction(this.TEST_TABLE), USER_OWNER, USER_RW);
        TestSnapshotWithAcl.verifyDenied(new AccessWriteAction(this.TEST_TABLE), USER_RO, USER_NONE);
    }

    static {
        admin = null;
    }

    static class AccessWriteAction
    implements SecureTestUtil.AccessTestAction {
        private TableName tableName;

        public AccessWriteAction(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public Object run() throws Exception {
            Put p = new Put(TEST_ROW);
            p.add(TEST_FAMILY, TEST_QUALIFIER, Bytes.toBytes((int)1));
            try (HTable t = new HTable(conf, this.tableName);){
                t.put(p);
            }
            return null;
        }
    }

    static class AccessReadAction
    implements SecureTestUtil.AccessTestAction {
        private TableName tableName;

        public AccessReadAction(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public Object run() throws Exception {
            Get g = new Get(TEST_ROW);
            g.addFamily(TEST_FAMILY);
            try (HTable t = new HTable(conf, this.tableName);){
                t.get(g);
            }
            return null;
        }
    }
}

