/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import org.apache.hadoop.hbase.InterProcessLock;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class TableLockChecker {
    private ZooKeeperWatcher zkWatcher;
    private HBaseFsck.ErrorReporter errorReporter;
    long expireTimeout;

    public TableLockChecker(ZooKeeperWatcher zkWatcher, HBaseFsck.ErrorReporter errorReporter) {
        this.zkWatcher = zkWatcher;
        this.errorReporter = errorReporter;
        this.expireTimeout = zkWatcher.getConfiguration().getLong("hbase.table.lock.expire.ms", 600000L);
    }

    public void checkTableLocks() throws IOException {
        TableLockManager tableLockManager = TableLockManager.createTableLockManager(this.zkWatcher.getConfiguration(), this.zkWatcher, null);
        final long expireDate = EnvironmentEdgeManager.currentTime() - this.expireTimeout;
        InterProcessLock.MetadataHandler handler = new InterProcessLock.MetadataHandler(){

            @Override
            public void handleMetadata(byte[] ownerMetadata) {
                ZooKeeperProtos.TableLock data = TableLockManager.fromBytes(ownerMetadata);
                Object msg = "Table lock acquire attempt found:";
                if (data != null) {
                    msg = (String)msg + String.format("[tableName=%s:%s, lockOwner=%s, threadId=%s, purpose=%s, isShared=%s, createTime=%s]", data.getTableName().getNamespace().toStringUtf8(), data.getTableName().getQualifier().toStringUtf8(), ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getLockOwner()), data.getThreadId(), data.getPurpose(), data.getIsShared(), data.getCreateTime());
                }
                if (data != null && data.hasCreateTime() && data.getCreateTime() < expireDate) {
                    TableLockChecker.this.errorReporter.reportError(HBaseFsck.ErrorReporter.ERROR_CODE.EXPIRED_TABLE_LOCK, (String)msg);
                } else {
                    TableLockChecker.this.errorReporter.print((String)msg);
                }
            }
        };
        tableLockManager.visitAllLocks(handler);
    }

    public void fixExpiredTableLocks() throws IOException {
        TableLockManager tableLockManager = TableLockManager.createTableLockManager(this.zkWatcher.getConfiguration(), this.zkWatcher, null);
        tableLockManager.reapAllExpiredLocks();
    }
}

