/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.replication.ReplicationPeerZKImpl;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.replication.TestReplicationKillRS;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestReplicationConfigTracker
extends TestReplicationBase {
    private static final Log LOG = LogFactory.getLog(TestReplicationKillRS.class);

    @Test
    public void testReplicationConfigTracker() throws Exception {
        int rsToKill1 = utility1.getHBaseCluster().getServerWithMeta() == 0 ? 1 : 0;
        int otherRs = rsToKill1 == 0 ? 1 : 0;
        HRegionServer regionServer = utility1.getHBaseCluster().getRegionServer(otherRs);
        final Thread listenerTracker = TestReplicationConfigTracker.trackListener(utility1, otherRs);
        LOG.info((Object)"Start loading table");
        utility1.loadTable(htable1, famName, true);
        LOG.info((Object)"Done loading table");
        utility1.getHBaseCluster().getRegionServer(rsToKill1).abort("Stopping as part of the test");
        utility1.getHBaseCluster().waitOnRegionServer(rsToKill1);
        while (utility1.getHBaseCluster().getMaster().getServerManager().areDeadServersInProgress()) {
            LOG.info((Object)"Waiting on processing of crashed server before proceeding...");
            Threads.sleep((long)1000L);
        }
        Waiter.waitFor((Configuration)utility1.getConfiguration(), (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return !listenerTracker.isAlive();
            }
        });
        final ReplicationPeerZKImpl.PeerConfigTracker tracker = this.getPeerConfigTracker(regionServer);
        Waiter.waitFor((Configuration)utility1.getConfiguration(), (long)20000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return tracker.getListeners().size() == 1;
            }
        });
    }

    private static Thread trackListener(final HBaseTestingUtility utility, final int rs) {
        Thread trackListener = new Thread(){

            @Override
            public void run() {
                Replication replication = (Replication)utility.getHBaseCluster().getRegionServer(rs).getReplicationSourceService();
                ReplicationSourceManager manager = replication.getReplicationManager();
                ReplicationPeerZKImpl replicationPeerZK = (ReplicationPeerZKImpl)manager.getReplicationPeers().getPeer("2");
                ReplicationPeerZKImpl.PeerConfigTracker peerConfigTracker = replicationPeerZK.getPeerConfigTracker();
                while (peerConfigTracker.getListeners().size() != 2) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"track config failed", (Throwable)e);
                    }
                }
            }
        };
        trackListener.setDaemon(true);
        trackListener.start();
        return trackListener;
    }

    private ReplicationPeerZKImpl.PeerConfigTracker getPeerConfigTracker(HRegionServer rs) {
        Replication replication = (Replication)rs.getReplicationSourceService();
        ReplicationSourceManager manager = replication.getReplicationManager();
        ReplicationPeerZKImpl replicationPeerZK = (ReplicationPeerZKImpl)manager.getReplicationPeers().getPeer("2");
        ReplicationPeerZKImpl.PeerConfigTracker peerConfigTracker = replicationPeerZK.getPeerConfigTracker();
        return peerConfigTracker;
    }
}

