/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLogRollingNoCluster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] EMPTY_1K_ARRAY = new byte[1024];
    private static final int NUM_THREADS = 100;
    private static final int NUM_ENTRIES = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContendedLogRolling() throws Exception {
        int i;
        TEST_UTIL.startMiniDFSCluster(3);
        Path dir = TEST_UTIL.getDataTestDirOnTestFS();
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 100);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        FSUtils.setRootDir((Configuration)conf, (Path)dir);
        conf.set("hbase.regionserver.hlog.writer.impl", HighLatencySyncWriter.class.getName());
        WALFactory wals = new WALFactory(conf, null, TestLogRollingNoCluster.class.getName());
        WAL wal = wals.getWAL(new byte[0], null);
        Appender[] appenders = null;
        int numThreads = 100;
        appenders = new Appender[100];
        try {
            for (i = 0; i < 100; ++i) {
                appenders[i] = new Appender(wal, i, 100);
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].start();
            }
            for (i = 0; i < 100; ++i) {
                appenders[i].join();
            }
        }
        finally {
            wals.close();
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertFalse((boolean)appenders[i].isException());
        }
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    static class Appender
    extends Thread {
        private final Log log;
        private final WAL wal;
        private final int count;
        private Exception e = null;

        Appender(WAL wal, int index, int count) {
            super("" + index);
            this.wal = wal;
            this.count = count;
            this.log = LogFactory.getLog((String)("Appender:" + this.getName()));
        }

        boolean isException() {
            return !this.isAlive() && this.e != null;
        }

        Exception getException() {
            return this.e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.log.info((Object)(this.getName() + " started"));
            MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
            try {
                for (int i = 0; i < this.count; ++i) {
                    long now = System.currentTimeMillis();
                    if (i % 10 == 0) {
                        this.wal.rollWriter();
                    }
                    WALEdit edit = new WALEdit();
                    byte[] bytes = Bytes.toBytes((int)i);
                    edit.add((Cell)new KeyValue(bytes, bytes, bytes, now, EMPTY_1K_ARRAY));
                    HRegionInfo hri = HRegionInfo.FIRST_META_REGIONINFO;
                    FSTableDescriptors fts = new FSTableDescriptors(TEST_UTIL.getConfiguration());
                    HTableDescriptor htd = fts.get(TableName.META_TABLE_NAME);
                    long txid = this.wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), TableName.META_TABLE_NAME, now, mvcc), edit, true);
                    Threads.sleep((long)ThreadLocalRandom.current().nextInt(5));
                    this.wal.sync(txid);
                }
                String msg = this.getName() + " finished";
                if (this.isException()) {
                    this.log.info((Object)msg, (Throwable)this.getException());
                } else {
                    this.log.info((Object)msg);
                }
            }
            catch (Exception e) {
                this.e = e;
                this.log.info((Object)("Caught exception from Appender:" + this.getName()), (Throwable)e);
            }
            finally {
                try {
                    this.wal.sync();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class HighLatencySyncWriter
    extends ProtobufLogWriter {
        public void sync() throws IOException {
            Threads.sleep((long)ThreadLocalRandom.current().nextInt(10));
            super.sync();
            Threads.sleep((long)ThreadLocalRandom.current().nextInt(10));
        }
    }
}

