/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HTestConst;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;
import org.apache.hadoop.hbase.regionserver.ReversedRegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannerHeartbeatMessages {
    private static final Log LOG = LogFactory.getLog(TestScannerHeartbeatMessages.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Table TABLE = null;
    private static TableName TABLE_NAME = TableName.valueOf((String)"testScannerHeartbeatMessagesTable");
    private static int NUM_ROWS = 5;
    private static byte[] ROW = Bytes.toBytes((String)"testRow");
    private static byte[][] ROWS = HTestConst.makeNAscii(ROW, NUM_ROWS);
    private static int NUM_FAMILIES = 4;
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[][] FAMILIES = HTestConst.makeNAscii(FAMILY, NUM_FAMILIES);
    private static int NUM_QUALIFIERS = 3;
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
    private static byte[][] QUALIFIERS = HTestConst.makeNAscii(QUALIFIER, NUM_QUALIFIERS);
    private static int VALUE_SIZE = 128;
    private static byte[] VALUE = Bytes.createMaxByteArray((int)VALUE_SIZE);
    private static int SERVER_TIMEOUT = 60000;
    private static int CLIENT_TIMEOUT = 1000;
    private static int DEFAULT_ROW_SLEEP_TIME = 300;
    private static int DEFAULT_CF_SLEEP_TIME = 300;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ((Log4JLogger)ScannerCallable.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)HeartbeatRPCServices.LOG).getLogger().setLevel(Level.ALL);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.hregion.impl", new String[]{HeartbeatHRegion.class.getName()});
        conf.setStrings("hbase.regionserver.impl", new String[]{HeartbeatHRegionServer.class.getName()});
        conf.setInt("hbase.client.scanner.timeout.period", SERVER_TIMEOUT);
        conf.setInt("hbase.rpc.timeout", SERVER_TIMEOUT);
        conf.setInt("hbase.client.pause", 1);
        conf.setLong("hbase.cells.scanned.per.heartbeat.check", 1L);
        TEST_UTIL.startMiniCluster(1);
        TABLE = TestScannerHeartbeatMessages.createTestTable(TABLE_NAME, ROWS, FAMILIES, QUALIFIERS, VALUE);
    }

    static Table createTestTable(TableName name, byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] cellValue) throws IOException {
        HTable ht = TEST_UTIL.createTable(name, families);
        ArrayList<Put> puts = TestScannerHeartbeatMessages.createPuts(rows, families, qualifiers, cellValue);
        ht.put(puts);
        ht.getConfiguration().setInt("hbase.client.scanner.timeout.period", CLIENT_TIMEOUT);
        return ht;
    }

    static ArrayList<Put> createPuts(byte[][] rows, byte[][] families, byte[][] qualifiers, byte[] value) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int row = 0; row < rows.length; ++row) {
            Put put = new Put(rows[row]);
            for (int fam = 0; fam < families.length; ++fam) {
                for (int qual = 0; qual < qualifiers.length; ++qual) {
                    KeyValue kv = new KeyValue(rows[row], families[fam], qualifiers[qual], (long)qual, value);
                    put.add((Cell)kv);
                }
            }
            puts.add(put);
        }
        return puts;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setupBeforeTest() throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
    }

    @After
    public void teardownAfterTest() throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
    }

    private void testImportanceOfHeartbeats(Callable<Void> testCallable) throws InterruptedException {
        HeartbeatRPCServices.heartbeatsEnabled = true;
        try {
            testCallable.call();
        }
        catch (Exception e) {
            Assert.fail((String)("Heartbeat messages are enabled, exceptions should NOT be thrown. Exception trace:" + ExceptionUtils.getStackTrace((Throwable)e)));
        }
        HeartbeatRPCServices.heartbeatsEnabled = false;
        try {
            testCallable.call();
        }
        catch (Exception e) {
            return;
        }
        finally {
            HeartbeatRPCServices.heartbeatsEnabled = true;
        }
        Assert.fail((String)"Heartbeats messages are disabled, an exception should be thrown. If an exception  is not thrown, the test case is not testing the importance of heartbeat messages");
    }

    @Test
    public void testHeartbeatBetweenRows() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scan, DEFAULT_ROW_SLEEP_TIME, -1, false);
                return null;
            }
        });
    }

    @Test
    public void testHeartbeatBetweenColumnFamilies() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan baseScan = new Scan();
                baseScan.setMaxResultSize(Long.MAX_VALUE);
                baseScan.setCaching(Integer.MAX_VALUE);
                Scan scanCopy = new Scan(baseScan);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scanCopy, -1, DEFAULT_CF_SLEEP_TIME, false);
                scanCopy = new Scan(baseScan);
                TestScannerHeartbeatMessages.this.testEquivalenceOfScanWithHeartbeats(scanCopy, -1, DEFAULT_CF_SLEEP_TIME, true);
                return null;
            }
        });
    }

    @Test
    public void testHeartbeatWithSparseFilter() throws Exception {
        this.testImportanceOfHeartbeats(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Scan scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                scan.setFilter((Filter)new SparseFilter());
                ResultScanner scanner = TABLE.getScanner(scan);
                int num = 0;
                while (scanner.next() != null) {
                    ++num;
                }
                Assert.assertEquals((long)1L, (long)num);
                scanner.close();
                scan = new Scan();
                scan.setMaxResultSize(Long.MAX_VALUE);
                scan.setCaching(Integer.MAX_VALUE);
                scan.setFilter((Filter)new SparseFilter());
                scan.setAllowPartialResults(true);
                scanner = TABLE.getScanner(scan);
                num = 0;
                while (scanner.next() != null) {
                    ++num;
                }
                Assert.assertEquals((long)(NUM_FAMILIES * NUM_QUALIFIERS), (long)num);
                scanner.close();
                return null;
            }
        });
    }

    private void testEquivalenceOfScanWithHeartbeats(Scan scan, int rowSleepTime, int cfSleepTime, boolean sleepBeforeCf) throws Exception {
        TestScannerHeartbeatMessages.disableSleeping();
        ResultScanner scanner = TABLE.getScanner(scan);
        ResultScanner scannerWithHeartbeats = TABLE.getScanner(scan);
        Result r1 = null;
        Result r2 = null;
        while ((r1 = scanner.next()) != null) {
            TestScannerHeartbeatMessages.configureSleepTime(rowSleepTime, cfSleepTime, sleepBeforeCf);
            r2 = scannerWithHeartbeats.next();
            TestScannerHeartbeatMessages.disableSleeping();
            Assert.assertTrue((r2 != null ? 1 : 0) != 0);
            try {
                Result.compareResults((Result)r1, (Result)r2);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
        Assert.assertTrue((scannerWithHeartbeats.next() == null ? 1 : 0) != 0);
        scanner.close();
        scannerWithHeartbeats.close();
    }

    private static void configureSleepTime(int rowSleepTime, int cfSleepTime, boolean sleepBeforeCf) {
        HeartbeatHRegion.sleepBetweenRows = rowSleepTime > 0;
        HeartbeatHRegion.rowSleepTime = rowSleepTime;
        HeartbeatHRegion.sleepBetweenColumnFamilies = cfSleepTime > 0;
        HeartbeatHRegion.columnFamilySleepTime = cfSleepTime;
        HeartbeatHRegion.sleepBeforeColumnFamily = sleepBeforeCf;
    }

    private static void disableSleeping() {
        HeartbeatHRegion.sleepBetweenRows = false;
        HeartbeatHRegion.sleepBetweenColumnFamilies = false;
    }

    private static final class HeartbeatReversedKVHeap
    extends ReversedKeyValueHeap {
        public HeartbeatReversedKVHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
            super(scanners, comparator);
        }

        public boolean next(List<Cell> result, ScannerContext context) throws IOException {
            if (HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            boolean moreRows = super.next(result, context);
            if (!HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            return moreRows;
        }
    }

    private static final class HeartbeatKVHeap
    extends KeyValueHeap {
        public HeartbeatKVHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
            super(scanners, comparator);
        }

        HeartbeatKVHeap(List<? extends KeyValueScanner> scanners, KeyValueHeap.KVScannerComparator comparator) throws IOException {
            super(scanners, comparator);
        }

        public boolean next(List<Cell> result, ScannerContext context) throws IOException {
            if (HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            boolean moreRows = super.next(result, context);
            if (!HeartbeatHRegion.sleepBeforeColumnFamily) {
                HeartbeatHRegion.columnFamilySleep();
            }
            return moreRows;
        }
    }

    private static class HeartbeatRegionScanner
    extends HRegion.RegionScannerImpl {
        HeartbeatRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            HRegion hRegion = region;
            Objects.requireNonNull(hRegion);
            super(hRegion, scan, additionalScanners, region);
        }

        public boolean nextRaw(List<Cell> outResults, ScannerContext context) throws IOException {
            boolean moreRows = super.nextRaw(outResults, context);
            HeartbeatHRegion.rowSleep();
            return moreRows;
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new HeartbeatKVHeap(scanners, region.getComparator());
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new HeartbeatKVHeap(joinedScanners, region.getComparator());
            }
        }
    }

    private static class HeartbeatReversedRegionScanner
    extends ReversedRegionScannerImpl {
        HeartbeatReversedRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            super(scan, additionalScanners, region);
        }

        public boolean nextRaw(List<Cell> outResults, ScannerContext context) throws IOException {
            boolean moreRows = super.nextRaw(outResults, context);
            HeartbeatHRegion.rowSleep();
            return moreRows;
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new HeartbeatReversedKVHeap(scanners, region.getComparator());
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new HeartbeatReversedKVHeap(joinedScanners, region.getComparator());
            }
        }
    }

    private static class HeartbeatHRegion
    extends HRegion {
        private static volatile int rowSleepTime = DEFAULT_ROW_SLEEP_TIME;
        private static volatile boolean sleepBetweenRows = false;
        private static volatile boolean sleepBeforeColumnFamily = false;
        private static volatile int columnFamilySleepTime = DEFAULT_CF_SLEEP_TIME;
        private static volatile boolean sleepBetweenColumnFamilies = false;

        public HeartbeatHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
            super(tableDir, wal, fs, confParam, regionInfo, htd, rsServices);
        }

        public HeartbeatHRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, HTableDescriptor htd, RegionServerServices rsServices) {
            super(fs, wal, confParam, htd, rsServices);
        }

        private static void columnFamilySleep() {
            if (sleepBetweenColumnFamilies) {
                Threads.sleepWithoutInterrupt((long)columnFamilySleepTime);
            }
        }

        private static void rowSleep() {
            if (sleepBetweenRows) {
                Threads.sleepWithoutInterrupt((long)rowSleepTime);
            }
        }

        protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners, long nonceGroup, long nonce) throws IOException {
            if (scan.isReversed()) {
                if (scan.getFilter() != null) {
                    scan.getFilter().setReversed(true);
                }
                return new HeartbeatReversedRegionScanner(scan, additionalScanners, this);
            }
            return new HeartbeatRegionScanner(scan, additionalScanners, this);
        }
    }

    private static class HeartbeatRPCServices
    extends RSRpcServices {
        private static volatile boolean heartbeatsEnabled = true;

        public HeartbeatRPCServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder((ClientProtos.ScanRequest)request);
            builder.setClientHandlesHeartbeats(heartbeatsEnabled);
            return super.scan(controller, builder.build());
        }
    }

    private static class HeartbeatHRegionServer
    extends HRegionServer {
        public HeartbeatHRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        public HeartbeatHRegionServer(Configuration conf, CoordinatedStateManager csm) throws IOException, InterruptedException {
            super(conf, csm);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new HeartbeatRPCServices(this);
        }
    }

    public static class SparseFilter
    extends FilterBase {
        public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
            try {
                Thread.sleep(CLIENT_TIMEOUT / 2 + 100);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return Bytes.equals((byte[])CellUtil.cloneRow((Cell)v), (byte[])ROWS[NUM_ROWS - 1]) ? Filter.ReturnCode.INCLUDE : Filter.ReturnCode.SKIP;
        }

        public static Filter parseFrom(byte[] pbBytes) {
            return new SparseFilter();
        }
    }
}

