/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestMasterAddressTracker {
    private static final Log LOG = LogFactory.getLog(TestMasterAddressTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testDeleteIfEquals() throws Exception {
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1772);
        try {
            Assert.assertFalse((String)"shouldn't have deleted wrong master server.", (boolean)MasterAddressTracker.deleteIfEquals((ZooKeeperWatcher)addressTracker.getWatcher(), (String)"some other string."));
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZooKeeperWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    private MasterAddressTracker setupMasterTracker(ServerName sn, int infoPort) throws Exception {
        ZooKeeperWatcher zk = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), this.name.getMethodName(), null);
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)zk, (String)zk.baseZNode);
        MasterAddressTracker addressTracker = new MasterAddressTracker(zk, null);
        addressTracker.start();
        Assert.assertFalse((boolean)addressTracker.hasMaster());
        zk.registerListener((ZooKeeperListener)addressTracker);
        NodeCreationListener listener = new NodeCreationListener(zk, zk.getMasterAddressZNode());
        zk.registerListener((ZooKeeperListener)listener);
        if (sn != null) {
            LOG.info((Object)"Creating master node");
            MasterAddressTracker.setMasterAddress((ZooKeeperWatcher)zk, (String)zk.getMasterAddressZNode(), (ServerName)sn, (int)infoPort);
            LOG.info((Object)"Waiting for master address manager to be notified");
            listener.waitForCreation();
            LOG.info((Object)"Master node created");
        }
        return addressTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterAddressTrackerFromZK() throws Exception {
        int infoPort = 1235;
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1235);
        try {
            Assert.assertTrue((boolean)addressTracker.hasMaster());
            ServerName pulledAddress = addressTracker.getMasterAddress();
            Assert.assertTrue((boolean)pulledAddress.equals((Object)sn));
            Assert.assertEquals((long)1235L, (long)addressTracker.getMasterInfoPort());
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZooKeeperWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    @Test
    public void testParsingNull() throws Exception {
        Assert.assertNull((String)"parse on null data should return null.", (Object)MasterAddressTracker.parse(null));
    }

    @Test
    public void testNoBackups() throws Exception {
        ServerName sn = ServerName.valueOf((String)"localhost", (int)1234, (long)System.currentTimeMillis());
        MasterAddressTracker addressTracker = this.setupMasterTracker(sn, 1772);
        try {
            Assert.assertEquals((String)"Should receive 0 for backup not found.", (long)0L, (long)addressTracker.getBackupMasterInfoPort(ServerName.valueOf((String)"doesnotexist.example.com", (int)1234, (long)System.currentTimeMillis())));
        }
        finally {
            Assert.assertTrue((String)"Couldn't clean up master", (boolean)MasterAddressTracker.deleteIfEquals((ZooKeeperWatcher)addressTracker.getWatcher(), (String)sn.toString()));
        }
    }

    @Test
    public void testNoMaster() throws Exception {
        MasterAddressTracker addressTracker = this.setupMasterTracker(null, 1772);
        Assert.assertFalse((boolean)addressTracker.hasMaster());
        Assert.assertNull((String)"should get null master when none active.", (Object)addressTracker.getMasterAddress());
        Assert.assertEquals((String)"Should receive 0 for backup not found.", (long)0L, (long)addressTracker.getMasterInfoPort());
    }

    public static class NodeCreationListener
    extends ZooKeeperListener {
        private static final Log LOG = LogFactory.getLog(NodeCreationListener.class);
        private Semaphore lock = new Semaphore(0);
        private String node;

        public NodeCreationListener(ZooKeeperWatcher watcher, String node) {
            super(watcher);
            this.node = node;
        }

        public void nodeCreated(String path) {
            if (path.equals(this.node)) {
                LOG.debug((Object)("nodeCreated(" + path + ")"));
                this.lock.release();
            }
        }

        public void waitForCreation() throws InterruptedException {
            this.lock.acquire();
        }
    }
}

