/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.regionserver.MockStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TestCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.DateTieredCompactionRequest;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.Assert;

public class AbstractTestDateTieredCompactionPolicy
extends TestCompactionPolicy {
    protected ArrayList<StoreFile> sfCreate(long[] minTimestamps, long[] maxTimestamps, long[] sizes) throws IOException {
        ManualEnvironmentEdge timeMachine = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)timeMachine);
        timeMachine.setValue(1L);
        ArrayList<Long> ageInDisk = new ArrayList<Long>();
        for (int i = 0; i < sizes.length; ++i) {
            ageInDisk.add(0L);
        }
        ArrayList ret = Lists.newArrayList();
        for (int i = 0; i < sizes.length; ++i) {
            MockStoreFile msf = new MockStoreFile(TEST_UTIL, TEST_FILE, sizes[i], (Long)ageInDisk.get(i), false, i);
            msf.setTimeRangeTracker(new TimeRangeTracker(minTimestamps[i], maxTimestamps[i]));
            ret.add(msf);
        }
        return ret;
    }

    protected void compactEquals(long now, ArrayList<StoreFile> candidates, long[] expectedFileSizes, long[] expectedBoundaries, boolean isMajor, boolean toCompact) throws IOException {
        DateTieredCompactionRequest request;
        ManualEnvironmentEdge timeMachine = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)timeMachine);
        timeMachine.setValue(now);
        DateTieredCompactionPolicy policy = (DateTieredCompactionPolicy)this.store.storeEngine.getCompactionPolicy();
        if (isMajor) {
            for (StoreFile file : candidates) {
                ((MockStoreFile)file).setIsMajor(true);
            }
            Assert.assertEquals((Object)toCompact, (Object)policy.shouldPerformMajorCompaction(candidates));
            request = (DateTieredCompactionRequest)policy.selectMajorCompaction(candidates);
        } else {
            Assert.assertEquals((Object)toCompact, (Object)policy.needsCompaction(candidates, (List)ImmutableList.of()));
            request = (DateTieredCompactionRequest)policy.selectMinorCompaction(candidates, false, false);
        }
        ArrayList actual = Lists.newArrayList((Iterable)request.getFiles());
        Assert.assertEquals((Object)Arrays.toString(expectedFileSizes), (Object)Arrays.toString(this.getSizes(actual)));
        Assert.assertEquals((Object)Arrays.toString(expectedBoundaries), (Object)Arrays.toString(request.getBoundaries().toArray()));
    }
}

