/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestHFileBlockPositionalRead {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testPositionalReadNoExtra() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        boolean ret = HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadShortReadOfNecessaryBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 5)).thenReturn((Object)5);
        boolean ret = HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadExtraSucceeded() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        boolean ret = HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadExtraFailed() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)necessaryLen);
        boolean ret = HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when reading extra bytes fails", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadShortReadCompletesNecessaryAndExtraBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 10)).thenReturn((Object)10);
        boolean ret = HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadPrematureEOF() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)9);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)-1);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("EOF");
        HFileBlock.positionalReadWithExtra((FSDataInputStream)in, (long)position, (byte[])buf, (int)bufOffset, (int)necessaryLen, (int)extraLen);
    }
}

