// Autogenerated Jamon implementation
// /data/jenkins/workspace/ch-1.4.14-mapr-mep-9.4.1-fy25-q3/mapr-hbase-1.4.14/dl/mapr-hbase-1.4.14/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/AssignmentManagerStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 20, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 21, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 22, 1
import org.apache.hadoop.hbase.master.RegionState;
// 23, 1
import org.apache.hadoop.conf.Configuration;
// 24, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 25, 1
import org.apache.hadoop.hbase.HConstants;
// 26, 1
import java.util.SortedSet;
// 27, 1
import java.util.Iterator;
// 28, 1
import java.util.List;
// 29, 1
import java.util.ArrayList;
// 30, 1
import java.util.Set;
// 31, 1
import java.util.HashSet;
// 32, 1
import java.lang.Integer;
// 33, 1
import java.util.Map;
// 34, 1
import java.util.concurrent.atomic.AtomicInteger;

public class AssignmentManagerStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.Intf

{
  private final AssignmentManager assignmentManager;
  private final int limit;
  protected static org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getLimit__IsNotDefault())
    {
      p_implData.setLimit(Integer.MAX_VALUE);
    }
    return p_implData;
  }
  public AssignmentManagerStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    assignmentManager = p_implData.getAssignmentManager();
    limit = p_implData.getLimit();
  }
  
  @Override public void renderNoFlush(final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 41, 1
    SortedSet<RegionState> rit = assignmentManager
  .getRegionStates().getRegionsInTransitionOrderedByTimestamp();
  Map<String, AtomicInteger> failedRegionTracker = assignmentManager.getFailedOpenTracker();
   
    // 46, 1
    if (!rit.isEmpty() )
    {
      // 46, 23
      jamonWriter.write("\n");
      // 47, 1
      
Set<String> ritsOverThreshold = new HashSet<>();
Set<String> ritsTwiceThreshold = new HashSet<>();
// process the map to find region in transition details
Configuration conf = HBaseConfiguration.create();
int ritThreshold = conf.getInt(HConstants.METRICS_RIT_STUCK_WARNING_THRESHOLD, 60000);
int numOfRITOverThreshold = 0;
long currentTime = System.currentTimeMillis();
List<RegionState> ritToDisplay = new ArrayList<>();
int count = 0;
for (RegionState rs : rit) {
  long ritTime = currentTime - rs.getStamp();
  if(ritTime > (ritThreshold * 2)) {
     numOfRITOverThreshold++;
     ritsTwiceThreshold.add(rs.getRegion().getEncodedName());
  } else if (ritTime > ritThreshold) {
     numOfRITOverThreshold++;
     ritsOverThreshold.add(rs.getRegion().getEncodedName());
  }
  if (count++ < limit) {
    ritToDisplay.add(rs);
  }
}
int numOfRITs = rit.size();
int ritsPerPage = Math.min(5, numOfRITs);
int numOfPages = (int) Math.ceil(numOfRITs * 1.0 / ritsPerPage);

      // 74, 5
      jamonWriter.write("<section>\n    <h2>Regions in Transition</h2>\n     <p>");
      // 76, 9
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITs), jamonWriter);
      // 76, 24
      jamonWriter.write(" region(s) in transition.\n     ");
      // 77, 6
      if (!ritsTwiceThreshold.isEmpty()  )
      {
        // 77, 44
        jamonWriter.write("\n         <span class=\"label label-danger\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 79, 6
      else if (!ritsOverThreshold.isEmpty() )
      {
        // 79, 46
        jamonWriter.write("\n         <span class=\"label label-warning\" style=\"font-size:100%;font-weight:normal\">\n     ");
      }
      // 81, 6
      else
      {
        // 81, 13
        jamonWriter.write("\n         <span>\n     ");
      }
      // 83, 12
      jamonWriter.write("\n         ");
      // 84, 10
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(numOfRITOverThreshold), jamonWriter);
      // 84, 37
      jamonWriter.write(" region(s) in transition for\n             more than ");
      // 85, 24
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(ritThreshold), jamonWriter);
      // 85, 42
      jamonWriter.write(" milliseconds.\n         </span>\n     </p>\n     <div class=\"tabbable\">\n         <div class=\"tab-content\">\n         ");
      // 90, 10
      int recordItr = 0; 
      // 91, 13
      for (RegionState rs : ritToDisplay )
      {
        // 91, 51
        jamonWriter.write("\n              ");
        // 92, 15
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 92, 53
          jamonWriter.write("\n                  ");
          // 93, 19
          if (recordItr == 0 )
          {
            // 93, 41
            jamonWriter.write("\n              <div class=\"tab-pane active\" id=\"tab_rits");
            // 94, 56
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 94, 91
            jamonWriter.write("\">\n                  ");
          }
          // 95, 19
          else
          {
            // 95, 26
            jamonWriter.write("\n              <div class=\"tab-pane\" id=\"tab_rits");
            // 96, 49
            org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((recordItr / ritsPerPage) + 1), jamonWriter);
            // 96, 84
            jamonWriter.write("\">\n                  ");
          }
          // 97, 25
          jamonWriter.write("\n                  <table class=\"table table-striped\" style=\"margin-bottom:0px;\"><tr><th>Region</th>\n                      <th>State</th><th>RIT time (ms)</th><th>Retries </th></tr>\n              ");
        }
        // 100, 21
        jamonWriter.write("\n\n              ");
        // 102, 15
        if (ritsOverThreshold.contains(rs.getRegion().getEncodedName()) )
        {
          // 102, 82
          jamonWriter.write("\n                      <tr class=\"alert alert-warning\" role=\"alert\">\n              ");
        }
        // 104, 15
        else if (ritsTwiceThreshold.contains(rs.getRegion().getEncodedName()) )
        {
          // 104, 87
          jamonWriter.write("\n                      <tr class=\"alert alert-danger\" role=\"alert\">\n              ");
        }
        // 106, 15
        else
        {
          // 106, 22
          jamonWriter.write("\n                      <tr>\n              ");
        }
        // 108, 21
        jamonWriter.write("\n               ");
        // 109, 16
        
                  String retryStatus = "0";
                  AtomicInteger numOpenRetries = failedRegionTracker.get(
                      rs.getRegion().getEncodedName());
                  if (numOpenRetries != null ) {
                    retryStatus = Integer.toString(numOpenRetries.get());
                  } else if (rs.getState() ==  RegionState.State.FAILED_OPEN) {
                     retryStatus = "Failed";
                  }
                
        // 119, 15
        jamonWriter.write("<td>");
        // 119, 19
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rs.getRegion().getEncodedName()), jamonWriter);
        // 119, 56
        jamonWriter.write("</td><td>\n              ");
        // 120, 15
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(rs.toDescriptiveString()), jamonWriter);
        // 120, 45
        jamonWriter.write("</td>\n              <td>");
        // 121, 19
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf((currentTime - rs.getStamp())), jamonWriter);
        // 121, 54
        jamonWriter.write(" </td>\n              <td>");
        // 122, 19
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(retryStatus), jamonWriter);
        // 122, 36
        jamonWriter.write(" </td>\n              ");
        // 123, 15
        recordItr++; 
        // 124, 15
        if ((recordItr % ritsPerPage) == 0 )
        {
          // 124, 53
          jamonWriter.write("\n                 </table>\n              </div>\n              ");
        }
        // 127, 21
        jamonWriter.write("\n            ");
      }
      // 128, 20
      jamonWriter.write("\n         ");
      // 129, 10
      if ((recordItr % ritsPerPage) != 0 )
      {
        // 129, 48
        jamonWriter.write("\n             ");
        // 130, 14
        for (; (recordItr % ritsPerPage) != 0 ; recordItr++ )
        {
          // 130, 69
          jamonWriter.write("\n             <tr><td colspan=\"3\" style=\"height:61px\"></td></tr>\n             ");
        }
        // 132, 21
        jamonWriter.write("\n                   </table>\n             </div>\n         ");
      }
      // 135, 16
      jamonWriter.write("\n         </div>\n         <nav>\n             <ul class=\"nav nav-pills pagination\">\n             ");
      // 139, 14
      for (int i = 1 ; i <= numOfPages; i++ )
      {
        // 139, 55
        jamonWriter.write("\n                 ");
        // 140, 18
        if (i == 1 )
        {
          // 140, 32
          jamonWriter.write("\n                 <li class=\"active\">\n                 ");
        }
        // 142, 18
        else
        {
          // 142, 25
          jamonWriter.write("\n                 <li>\n                 ");
        }
        // 144, 24
        jamonWriter.write("\n                 <a href=\"#tab_rits");
        // 145, 36
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(i), jamonWriter);
        // 145, 43
        jamonWriter.write("\">");
        // 145, 45
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(i), jamonWriter);
        // 145, 52
        jamonWriter.write("</a></li>\n             ");
      }
      // 146, 21
      jamonWriter.write("\n             </ul>\n         </nav>\n     </div>\n   </section>\n ");
    }
    // 151, 8
    jamonWriter.write("\n\n");
  }
  
  
}
