/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.ArrayList;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;

@InterfaceAudience.Private
class RSGroupProtobufUtil {
    RSGroupProtobufUtil() {
    }

    static RSGroupInfo toGroupInfo(RSGroupProtos.RSGroupInfo proto) {
        RSGroupInfo RSGroupInfo2 = new RSGroupInfo(proto.getName());
        for (HBaseProtos.ServerName el : proto.getServersList()) {
            RSGroupInfo2.addServer(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        for (TableProtos.TableName pTableName : proto.getTablesList()) {
            RSGroupInfo2.addTable(ProtobufUtil.toTableName((TableProtos.TableName)pTableName));
        }
        return RSGroupInfo2;
    }

    static RSGroupProtos.RSGroupInfo toProtoGroupInfo(RSGroupInfo pojo) {
        ArrayList<TableProtos.TableName> tables = new ArrayList<TableProtos.TableName>(pojo.getTables().size());
        for (TableName arg : pojo.getTables()) {
            tables.add(ProtobufUtil.toProtoTableName((TableName)arg));
        }
        ArrayList<HBaseProtos.ServerName> servers = new ArrayList<HBaseProtos.ServerName>(pojo.getServers().size());
        for (Address el : pojo.getServers()) {
            servers.add(HBaseProtos.ServerName.newBuilder().setHostName(el.getHostname()).setPort(el.getPort()).build());
        }
        return RSGroupProtos.RSGroupInfo.newBuilder().setName(pojo.getName()).addAllServers(servers).addAllTables(tables).build();
    }
}

