/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RSGroupableBalancerTestBase {
    static SecureRandom rand = new SecureRandom();
    static String[] groups = new String[]{"default", "dg2", "dg3", "dg4"};
    static TableName table0 = TableName.valueOf((String)"dt0");
    static TableName[] tables = new TableName[]{TableName.valueOf((String)"dt1"), TableName.valueOf((String)"dt2"), TableName.valueOf((String)"dt3"), TableName.valueOf((String)"dt4")};
    static List<ServerName> servers;
    static Map<String, RSGroupInfo> groupMap;
    static Map<TableName, String> tableMap;
    static List<HTableDescriptor> tableDescs;
    int[] regionAssignment = new int[]{2, 5, 7, 10, 4, 3, 1};
    static int regionId;

    protected void assertClusterAsBalanced(ArrayListMultimap<String, ServerAndLoad> groupLoadMap) {
        for (String gName : groupLoadMap.keySet()) {
            List groupLoad = groupLoadMap.get((Object)gName);
            int numServers = groupLoad.size();
            int numRegions = 0;
            int maxRegions = 0;
            int minRegions = Integer.MAX_VALUE;
            for (ServerAndLoad server : groupLoad) {
                int nr = server.getLoad();
                if (nr > maxRegions) {
                    maxRegions = nr;
                }
                if (nr < minRegions) {
                    minRegions = nr;
                }
                numRegions += nr;
            }
            if (maxRegions - minRegions < 2) {
                return;
            }
            int min = numRegions / numServers;
            int max = numRegions % numServers == 0 ? min : min + 1;
            for (ServerAndLoad server : groupLoad) {
                Assert.assertTrue((server.getLoad() <= max ? 1 : 0) != 0);
                Assert.assertTrue((server.getLoad() >= min ? 1 : 0) != 0);
            }
        }
    }

    protected void assertRetainedAssignment(Map<HRegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<HRegionInfo>> assignment) throws FileNotFoundException, IOException {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<ServerName, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName currentServer = (ServerName)entry.getKey();
            for (HRegionInfo r : (List)entry.getValue()) {
                ServerName oldAssignedServer = existing.get(r);
                TableName tableName = r.getTable();
                String groupName = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)groupName));
                RSGroupInfo gInfo = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(currentServer.getAddress()));
                if (oldAssignedServer == null || !onlineHostNames.contains(oldAssignedServer.getHostname()) || oldAssignedServer.getAddress().equals((Object)currentServer.getAddress())) continue;
                Assert.assertFalse((boolean)gInfo.containsServer(oldAssignedServer.getAddress()));
            }
        }
    }

    protected String printStats(ArrayListMultimap<String, ServerAndLoad> groupBasedLoad) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        for (String groupName : groupBasedLoad.keySet()) {
            sb.append("Stats for group: " + groupName);
            sb.append("\n");
            sb.append(groupMap.get(groupName).getServers());
            sb.append("\n");
            List groupLoad = groupBasedLoad.get((Object)groupName);
            int numServers = groupLoad.size();
            int totalRegions = 0;
            sb.append("Per Server Load: \n");
            for (ServerAndLoad sLoad : groupLoad) {
                sb.append("Server :" + sLoad.getServerName() + " Load : " + sLoad.getLoad() + "\n");
                totalRegions += sLoad.getLoad();
            }
            sb.append(" Group Statistics : \n");
            float average = (float)totalRegions / (float)numServers;
            int max = (int)Math.ceil(average);
            int min = (int)Math.floor(average);
            sb.append("[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]");
            sb.append("\n");
            sb.append("===============================");
            sb.append("\n");
        }
        return sb.toString();
    }

    protected ArrayListMultimap<String, ServerAndLoad> convertToGroupBasedMap(Map<ServerName, List<HRegionInfo>> serversMap) throws IOException {
        ArrayListMultimap loadMap = ArrayListMultimap.create();
        for (RSGroupInfo gInfo : RSGroupableBalancerTestBase.getMockedGroupInfoManager().listRSGroups()) {
            Set groupServers = gInfo.getServers();
            for (Address server : groupServers) {
                ServerName actual = null;
                for (ServerName entry : servers) {
                    if (!entry.getAddress().equals((Object)server)) continue;
                    actual = entry;
                    break;
                }
                List<HRegionInfo> regions = serversMap.get(actual);
                Assert.assertTrue((String)("No load for " + actual), (regions != null ? 1 : 0) != 0);
                loadMap.put((Object)gInfo.getName(), (Object)new ServerAndLoad(actual, regions.size()));
            }
        }
        return loadMap;
    }

    protected ArrayListMultimap<String, ServerAndLoad> reconcile(ArrayListMultimap<String, ServerAndLoad> previousLoad, List<RegionPlan> plans) {
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(previousLoad);
        if (plans != null) {
            for (RegionPlan plan : plans) {
                ServerName source = plan.getSource();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, source, -1);
                ServerName destination = plan.getDestination();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, destination, 1);
            }
        }
        return result;
    }

    protected void updateLoad(ArrayListMultimap<String, ServerAndLoad> previousLoad, ServerName sn, int diff) {
        for (String groupName : previousLoad.keySet()) {
            ServerAndLoad newSAL = null;
            ServerAndLoad oldSAL = null;
            for (ServerAndLoad sal : previousLoad.get((Object)groupName)) {
                if (!ServerName.isSameAddress((ServerName)sn, (ServerName)sal.getServerName())) continue;
                oldSAL = sal;
                newSAL = new ServerAndLoad(sn, sal.getLoad() + diff);
                break;
            }
            if (newSAL == null) continue;
            previousLoad.remove((Object)groupName, oldSAL);
            previousLoad.put((Object)groupName, newSAL);
            break;
        }
    }

    protected Map<ServerName, List<HRegionInfo>> mockClusterServers() throws IOException {
        Assert.assertTrue((servers.size() == this.regionAssignment.length ? 1 : 0) != 0);
        TreeMap<ServerName, List<HRegionInfo>> assignment = new TreeMap<ServerName, List<HRegionInfo>>();
        for (int i = 0; i < servers.size(); ++i) {
            int numRegions = this.regionAssignment[i];
            List<HRegionInfo> regions = this.assignedRegions(numRegions, servers.get(i));
            assignment.put(servers.get(i), regions);
        }
        return assignment;
    }

    protected List<HRegionInfo> randomRegions(int numRegions) {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        rand.nextBytes(start);
        rand.nextBytes(end);
        int regionIdx = rand.nextInt(tables.length);
        for (int i = 0; i < numRegions; ++i) {
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            int tableIndex = (i + regionIdx) % tables.length;
            HRegionInfo hri = new HRegionInfo(tables[tableIndex], start, end, false, (long)regionId++);
            regions.add(hri);
        }
        return regions;
    }

    protected List<HRegionInfo> assignedRegions(int numRegions, ServerName sn) throws IOException {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
        Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
        for (int i = 0; i < numRegions; ++i) {
            TableName tableName = this.getTableName(sn);
            HRegionInfo hri = new HRegionInfo(tableName, start, end, false, (long)regionId++);
            regions.add(hri);
        }
        return regions;
    }

    protected static List<ServerName> generateServers(int numServers) {
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numServers);
        for (int i = 0; i < numServers; ++i) {
            String host = "server" + rand.nextInt(100000);
            int port = rand.nextInt(60000);
            servers.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return servers;
    }

    protected static Map<String, RSGroupInfo> constructGroupInfo(List<ServerName> servers, String[] groups) {
        Assert.assertTrue((servers != null ? 1 : 0) != 0);
        Assert.assertTrue((servers.size() >= groups.length ? 1 : 0) != 0);
        int index = 0;
        HashMap<String, RSGroupInfo> groupMap = new HashMap<String, RSGroupInfo>();
        for (String grpName : groups) {
            RSGroupInfo RSGroupInfo2 = new RSGroupInfo(grpName);
            RSGroupInfo2.addServer(servers.get(index).getAddress());
            groupMap.put(grpName, RSGroupInfo2);
            ++index;
        }
        while (index < servers.size()) {
            int grpIndex = rand.nextInt(groups.length);
            ((RSGroupInfo)groupMap.get(groups[grpIndex])).addServer(servers.get(index).getAddress());
            ++index;
        }
        return groupMap;
    }

    protected static List<HTableDescriptor> constructTableDesc(boolean hasBogusTable) {
        ArrayList tds = Lists.newArrayList();
        int index = rand.nextInt(groups.length);
        for (int i = 0; i < tables.length; ++i) {
            HTableDescriptor htd = new HTableDescriptor(tables[i]);
            int grpIndex = (i + index) % groups.length;
            String groupName = groups[grpIndex];
            tableMap.put(tables[i], groupName);
            tds.add(htd);
        }
        if (hasBogusTable) {
            tableMap.put(table0, "");
            tds.add(new HTableDescriptor(table0));
        }
        return tds;
    }

    protected static MasterServices getMockedMaster() throws IOException {
        TableDescriptors tds = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Mockito.when((Object)tds.get(tables[0])).thenReturn((Object)tableDescs.get(0));
        Mockito.when((Object)tds.get(tables[1])).thenReturn((Object)tableDescs.get(1));
        Mockito.when((Object)tds.get(tables[2])).thenReturn((Object)tableDescs.get(2));
        Mockito.when((Object)tds.get(tables[3])).thenReturn((Object)tableDescs.get(3));
        MasterServices services = (MasterServices)Mockito.mock(HMaster.class);
        Mockito.when((Object)services.getTableDescriptors()).thenReturn((Object)tds);
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        Mockito.when((Object)services.getAssignmentManager()).thenReturn((Object)am);
        return services;
    }

    protected static RSGroupInfoManager getMockedGroupInfoManager() throws IOException {
        RSGroupInfoManager gm = (RSGroupInfoManager)Mockito.mock(RSGroupInfoManager.class);
        Mockito.when((Object)gm.getRSGroup(Mockito.anyString())).thenAnswer((Answer)new Answer<RSGroupInfo>(){

            public RSGroupInfo answer(InvocationOnMock invocation) throws Throwable {
                return groupMap.get(invocation.getArguments()[0]);
            }
        });
        Mockito.when((Object)gm.listRSGroups()).thenReturn((Object)Lists.newLinkedList(groupMap.values()));
        Mockito.when((Object)gm.isOnline()).thenReturn((Object)true);
        Mockito.when((Object)gm.getRSGroupOfTable((TableName)Mockito.any(TableName.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return tableMap.get(invocation.getArguments()[0]);
            }
        });
        return gm;
    }

    protected TableName getTableName(ServerName sn) throws IOException {
        TableName tableName = null;
        RSGroupInfoManager gm = RSGroupableBalancerTestBase.getMockedGroupInfoManager();
        RSGroupInfo groupOfServer = null;
        for (RSGroupInfo gInfo : gm.listRSGroups()) {
            if (!gInfo.containsServer(sn.getAddress())) continue;
            groupOfServer = gInfo;
            break;
        }
        for (HTableDescriptor desc : tableDescs) {
            if (!gm.getRSGroupOfTable(desc.getTableName()).endsWith(groupOfServer.getName())) continue;
            tableName = desc.getTableName();
        }
        return tableName;
    }

    static {
        tableMap = new HashMap<TableName, String>();
        regionId = 0;
    }
}

