/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureInMemoryChore;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureInMemoryChore {
    private static final Log LOG = LogFactory.getLog(TestProcedureInMemoryChore.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private TestProcEnv procEnv;
    private NoopProcedureStore procStore;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private HBaseCommonTestingUtility htu;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.procEnv = new TestProcEnv();
        this.procStore = new NoopProcedureStore();
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)this.procEnv, (ProcedureStore)this.procStore);
        this.procExecutor.testing = new ProcedureExecutor.Testing();
        this.procStore.start(1);
        this.procExecutor.start(1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
    }

    @Test
    public void testChoreAddAndRemove() throws Exception {
        int timeoutMSec = 50;
        int nCountDown = 5;
        CountDownLatch latch = new CountDownLatch(5);
        TestLatchChore chore = new TestLatchChore(50, latch);
        this.procExecutor.addChore((ProcedureInMemoryChore)chore);
        Assert.assertTrue((boolean)chore.isRunnable());
        latch.await();
        Assert.assertTrue((boolean)chore.isRunnable());
        this.procExecutor.removeChore((ProcedureInMemoryChore)chore);
        latch = new CountDownLatch(5);
        chore.setLatch(latch);
        latch.await(250L, TimeUnit.MILLISECONDS);
        LOG.info((Object)("chore latch count=" + latch.getCount()));
        Assert.assertFalse((boolean)chore.isRunnable());
        Assert.assertTrue((String)("latchCount=" + latch.getCount()), (latch.getCount() > 0L ? 1 : 0) != 0);
    }

    private static class TestProcEnv {
        private TestProcEnv() {
        }
    }

    public static class TestLatchChore
    extends ProcedureInMemoryChore<TestProcEnv> {
        private CountDownLatch latch;

        public TestLatchChore(int timeoutMSec, CountDownLatch latch) {
            super(timeoutMSec);
            this.setLatch(latch);
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        protected void periodicExecute(TestProcEnv env) {
            this.latch.countDown();
        }
    }
}

