/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.store.NoopProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;

public class ProcedureTestingUtility {
    private static final Log LOG = LogFactory.getLog(ProcedureTestingUtility.class);

    private ProcedureTestingUtility() {
    }

    public static ProcedureStore createStore(Configuration conf, FileSystem fs, Path baseDir) throws IOException {
        return ProcedureTestingUtility.createWalStore(conf, fs, baseDir);
    }

    public static WALProcedureStore createWalStore(Configuration conf, FileSystem fs, Path walDir) throws IOException {
        return new WALProcedureStore(conf, fs, walDir, new WALProcedureStore.LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, null, true);
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, Runnable beforeStartAction, boolean failOnCorrupted) throws Exception {
        ProcedureStore procStore = procExecutor.getStore();
        int storeThreads = procExecutor.getNumThreads();
        int execThreads = procExecutor.getNumThreads();
        procExecutor.stop();
        procExecutor.join();
        procStore.stop(false);
        if (beforeStartAction != null) {
            beforeStartAction.run();
        }
        procStore.start(storeThreads);
        procExecutor.start(execThreads, failOnCorrupted);
    }

    public static void storeRestart(ProcedureStore procStore, ProcedureStore.ProcedureLoader loader) throws Exception {
        procStore.stop(false);
        procStore.start(procStore.getNumThreads());
        procStore.recoverLease();
        procStore.load(loader);
    }

    public static void storeRestartAndAssert(ProcedureStore procStore, long maxProcId, long runnableCount, int completedCount, int corruptedCount) throws Exception {
        LoadCounter loader = new LoadCounter();
        ProcedureTestingUtility.storeRestart(procStore, loader);
        Assert.assertEquals((long)maxProcId, (long)loader.getMaxProcId());
        Assert.assertEquals((long)runnableCount, (long)loader.getRunnableCount());
        Assert.assertEquals((long)completedCount, (long)loader.getCompletedCount());
        Assert.assertEquals((long)corruptedCount, (long)loader.getCorruptedCount());
    }

    public static <TEnv> void setKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.killBeforeStoreUpdate = value;
        LOG.warn((Object)("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate));
    }

    public static <TEnv> void setToggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.toggleKillBeforeStoreUpdate = value;
    }

    public static <TEnv> void toggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.killBeforeStoreUpdate = !procExecutor.testing.killBeforeStoreUpdate;
        LOG.warn((Object)("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate));
    }

    public static <TEnv> void setKillAndToggleBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExecutor, value);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExecutor, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEnv> long submitAndWait(Configuration conf, TEnv env, Procedure<TEnv> proc) throws IOException {
        NoopProcedureStore procStore = new NoopProcedureStore();
        ProcedureExecutor procExecutor = new ProcedureExecutor(conf, env, (ProcedureStore)procStore);
        procStore.start(1);
        procExecutor.start(1, false);
        try {
            long l = ProcedureTestingUtility.submitAndWait(procExecutor, proc, 0L, 0L);
            return l;
        }
        finally {
            procStore.stop(false);
            procExecutor.stop();
        }
    }

    public static <TEnv> long submitAndWait(ProcedureExecutor<TEnv> procExecutor, Procedure proc) {
        return ProcedureTestingUtility.submitAndWait(procExecutor, proc, 0L, 0L);
    }

    public static <TEnv> long submitAndWait(ProcedureExecutor<TEnv> procExecutor, Procedure proc, long nonceGroup, long nonce) {
        long procId = ProcedureTestingUtility.submitProcedure(procExecutor, proc, nonceGroup, nonce);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        return procId;
    }

    public static <TEnv> long submitProcedure(ProcedureExecutor<TEnv> procExecutor, Procedure proc, long nonceGroup, long nonce) {
        NonceKey nonceKey = procExecutor.createNonceKey(nonceGroup, nonce);
        long procId = procExecutor.registerNonce(nonceKey);
        Assert.assertFalse((procId >= 0L ? 1 : 0) != 0);
        return procExecutor.submitProcedure(proc, nonceKey);
    }

    public static <TEnv> void waitProcedure(ProcedureExecutor<TEnv> procExecutor, Procedure proc) {
        while (proc.getState() == ProcedureProtos.ProcedureState.INITIALIZING) {
            Threads.sleepWithoutInterrupt((long)250L);
        }
        ProcedureTestingUtility.waitProcedure(procExecutor, proc.getProcId());
    }

    public static <TEnv> void waitProcedure(ProcedureExecutor<TEnv> procExecutor, long procId) {
        while (!procExecutor.isFinished(procId) && procExecutor.isRunning()) {
            Threads.sleepWithoutInterrupt((long)250L);
        }
    }

    public static <TEnv> void waitNoProcedureRunning(ProcedureExecutor<TEnv> procExecutor) {
        int stableRuns = 0;
        while (stableRuns < 10) {
            if (procExecutor.getActiveExecutorCount() > 0 || procExecutor.getRunnableSet().size() > 0) {
                stableRuns = 0;
                Threads.sleepWithoutInterrupt((long)100L);
                continue;
            }
            ++stableRuns;
            Threads.sleepWithoutInterrupt((long)25L);
        }
    }

    public static <TEnv> void assertProcNotYetCompleted(ProcedureExecutor<TEnv> procExecutor, long procId) {
        Assert.assertFalse((String)"expected a running proc", (boolean)procExecutor.isFinished(procId));
        Assert.assertEquals(null, (Object)procExecutor.getResult(procId));
    }

    public static <TEnv> void assertProcNotFailed(ProcedureExecutor<TEnv> procExecutor, long procId) {
        ProcedureInfo result = procExecutor.getResult(procId);
        Assert.assertTrue((String)"expected procedure result", (result != null ? 1 : 0) != 0);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    public static void assertProcNotFailed(ProcedureInfo result) {
        ErrorHandlingProtos.ForeignExceptionMessage exception = result.getForeignExceptionMessage();
        String msg = exception != null ? result.getExceptionFullMessage() : "no exception found";
        Assert.assertFalse((String)msg, (boolean)result.isFailed());
    }

    public static Throwable assertProcFailed(ProcedureInfo result) {
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info((Object)("procId=" + result.getProcId() + " exception: " + result.getException().getMessage()));
        return ProcedureTestingUtility.getExceptionCause(result);
    }

    public static void assertIsAbortException(ProcedureInfo result) {
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info((Object)result.getExceptionFullMessage());
        Throwable cause = ProcedureTestingUtility.getExceptionCause(result);
        Assert.assertTrue((String)("expected abort exception, got " + cause), (boolean)(cause instanceof ProcedureAbortedException));
    }

    public static void assertIsTimeoutException(ProcedureInfo result) {
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info((Object)result.getExceptionFullMessage());
        Throwable cause = ProcedureTestingUtility.getExceptionCause(result);
        Assert.assertTrue((String)("expected TimeoutIOException, got " + cause), (boolean)(cause instanceof TimeoutIOException));
    }

    public static void assertIsIllegalArgumentException(ProcedureInfo result) {
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        LOG.info((Object)result.getExceptionFullMessage());
        Throwable cause = ProcedureTestingUtility.getExceptionCause(result);
        Assert.assertTrue((String)("expected IllegalArgumentIOException, got " + cause), (boolean)(cause instanceof IllegalArgumentIOException));
    }

    public static Throwable getExceptionCause(ProcedureInfo procInfo) {
        assert (procInfo.getForeignExceptionMessage() != null);
        return RemoteProcedureException.fromProto((ErrorHandlingProtos.ForeignExceptionMessage)procInfo.getForeignExceptionMessage()).getCause();
    }

    public static class LoadCounter
    implements ProcedureStore.ProcedureLoader {
        private final ArrayList<Procedure> corrupted = new ArrayList();
        private final ArrayList<ProcedureInfo> completed = new ArrayList();
        private final ArrayList<Procedure> runnable = new ArrayList();
        private Set<Long> procIds;
        private long maxProcId = 0L;

        public LoadCounter() {
            this(null);
        }

        public LoadCounter(Set<Long> procIds) {
            this.procIds = procIds;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(Set<Long> procIds) {
            this.corrupted.clear();
            this.completed.clear();
            this.runnable.clear();
            this.procIds = procIds;
            this.maxProcId = 0L;
        }

        public long getMaxProcId() {
            return this.maxProcId;
        }

        public ArrayList<Procedure> getRunnables() {
            return this.runnable;
        }

        public int getRunnableCount() {
            return this.runnable.size();
        }

        public ArrayList<ProcedureInfo> getCompleted() {
            return this.completed;
        }

        public int getCompletedCount() {
            return this.completed.size();
        }

        public int getLoadedCount() {
            return this.runnable.size() + this.completed.size();
        }

        public ArrayList<Procedure> getCorrupted() {
            return this.corrupted;
        }

        public int getCorruptedCount() {
            return this.corrupted.size();
        }

        public void setMaxProcId(long maxProcId) {
            this.maxProcId = maxProcId;
        }

        public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                long procId;
                ProcedureInfo proc;
                if (procIter.isNextCompleted()) {
                    proc = procIter.nextAsProcedureInfo();
                    procId = proc.getProcId();
                    LOG.debug((Object)("loading completed procId=" + procId + ": " + proc));
                    this.completed.add(proc);
                } else {
                    proc = procIter.nextAsProcedure();
                    procId = proc.getProcId();
                    LOG.debug((Object)("loading runnable procId=" + procId + ": " + (Procedure)proc));
                    this.runnable.add((Procedure)proc);
                }
                if (this.procIds == null) continue;
                Assert.assertTrue((String)("procId=" + procId + " unexpected"), (boolean)this.procIds.contains(procId));
            }
        }

        public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                Procedure proc = procIter.nextAsProcedure();
                LOG.debug((Object)("corrupted procId=" + proc.getProcId() + ": " + proc));
                this.corrupted.add(proc);
            }
        }
    }

    public static class TestProcedure
    extends Procedure<Void> {
        private byte[] data = null;

        public TestProcedure() {
        }

        public TestProcedure(long procId) {
            this(procId, 0L);
        }

        public TestProcedure(long procId, long parentId) {
            this(procId, parentId, null);
        }

        public TestProcedure(long procId, long parentId, byte[] data) {
            this.setData(data);
            this.setProcId(procId);
            if (parentId > 0L) {
                this.setParentProcId(parentId);
            }
        }

        public void addStackId(int index) {
            this.addStackIndex(index);
        }

        public void setFinishedState() {
            this.setState(ProcedureProtos.ProcedureState.FINISHED);
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        protected Procedure[] execute(Void env) {
            return null;
        }

        protected void rollback(Void env) {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(OutputStream stream) throws IOException {
            StreamUtils.writeRawVInt32((OutputStream)stream, (int)(this.data != null ? this.data.length : 0));
            if (this.data != null) {
                stream.write(this.data);
            }
        }

        protected void deserializeStateData(InputStream stream) throws IOException {
            int len = StreamUtils.readRawVarint32((InputStream)stream);
            if (len > 0) {
                this.data = new byte[len];
                stream.read(this.data);
            } else {
                this.data = null;
            }
        }
    }
}

