/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.vint.UVIntTool;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestVIntTool {
    @Test
    public void testNumBytes() {
        Assert.assertEquals((long)1L, (long)UVIntTool.numBytes((int)0));
        Assert.assertEquals((long)1L, (long)UVIntTool.numBytes((int)1));
        Assert.assertEquals((long)1L, (long)UVIntTool.numBytes((int)100));
        Assert.assertEquals((long)1L, (long)UVIntTool.numBytes((int)126));
        Assert.assertEquals((long)1L, (long)UVIntTool.numBytes((int)127));
        Assert.assertEquals((long)2L, (long)UVIntTool.numBytes((int)128));
        Assert.assertEquals((long)2L, (long)UVIntTool.numBytes((int)129));
        Assert.assertEquals((long)5L, (long)UVIntTool.numBytes((int)Integer.MAX_VALUE));
    }

    @Test
    public void testWriteBytes() throws IOException {
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])this.bytesViaOutputStream(0));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.bytesViaOutputStream(1));
        Assert.assertArrayEquals((byte[])new byte[]{63}, (byte[])this.bytesViaOutputStream(63));
        Assert.assertArrayEquals((byte[])new byte[]{127}, (byte[])this.bytesViaOutputStream(127));
        Assert.assertArrayEquals((byte[])new byte[]{-128, 1}, (byte[])this.bytesViaOutputStream(128));
        Assert.assertArrayEquals((byte[])new byte[]{-101, 1}, (byte[])this.bytesViaOutputStream(155));
        Assert.assertArrayEquals((byte[])UVIntTool.MAX_VALUE_BYTES, (byte[])this.bytesViaOutputStream(Integer.MAX_VALUE));
    }

    private byte[] bytesViaOutputStream(int value) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        UVIntTool.writeBytes((int)value, (OutputStream)os);
        return os.toByteArray();
    }

    @Test
    public void testToBytes() {
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])UVIntTool.getBytes((int)0));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])UVIntTool.getBytes((int)1));
        Assert.assertArrayEquals((byte[])new byte[]{63}, (byte[])UVIntTool.getBytes((int)63));
        Assert.assertArrayEquals((byte[])new byte[]{127}, (byte[])UVIntTool.getBytes((int)127));
        Assert.assertArrayEquals((byte[])new byte[]{-128, 1}, (byte[])UVIntTool.getBytes((int)128));
        Assert.assertArrayEquals((byte[])new byte[]{-101, 1}, (byte[])UVIntTool.getBytes((int)155));
        Assert.assertArrayEquals((byte[])UVIntTool.MAX_VALUE_BYTES, (byte[])UVIntTool.getBytes((int)Integer.MAX_VALUE));
    }

    @Test
    public void testFromBytes() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)UVIntTool.getInt((byte[])UVIntTool.MAX_VALUE_BYTES));
    }

    @Test
    public void testRoundTrips() {
        Random random = new Random();
        for (int i = 0; i < 10000; ++i) {
            int value = random.nextInt(Integer.MAX_VALUE);
            byte[] bytes = UVIntTool.getBytes((int)value);
            int roundTripped = UVIntTool.getInt((byte[])bytes);
            Assert.assertEquals((long)value, (long)roundTripped);
        }
    }

    @Test
    public void testInputStreams() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{0});
        Assert.assertEquals((long)0L, (long)UVIntTool.getInt((InputStream)is));
        is = new ByteArrayInputStream(new byte[]{5});
        Assert.assertEquals((long)5L, (long)UVIntTool.getInt((InputStream)is));
        is = new ByteArrayInputStream(new byte[]{-101, 1});
        Assert.assertEquals((long)155L, (long)UVIntTool.getInt((InputStream)is));
    }
}

