/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFIntTool {
    @Test
    public void testLeadingZeros() {
        Assert.assertEquals((long)64L, (long)Long.numberOfLeadingZeros(0L));
        Assert.assertEquals((long)63L, (long)Long.numberOfLeadingZeros(1L));
        Assert.assertEquals((long)0L, (long)Long.numberOfLeadingZeros(Long.MIN_VALUE));
        Assert.assertEquals((long)0L, (long)Long.numberOfLeadingZeros(-1L));
        Assert.assertEquals((long)1L, (long)Long.numberOfLeadingZeros(Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)Long.numberOfLeadingZeros(0x7FFFFFFFFFFFFFFEL));
    }

    @Test
    public void testMaxValueForNumBytes() {
        Assert.assertEquals((long)255L, (long)UFIntTool.maxValueForNumBytes((int)1));
        Assert.assertEquals((long)65535L, (long)UFIntTool.maxValueForNumBytes((int)2));
        Assert.assertEquals((long)0xFFFFFFL, (long)UFIntTool.maxValueForNumBytes((int)3));
        Assert.assertEquals((long)0xFFFFFFFFFFFFFFL, (long)UFIntTool.maxValueForNumBytes((int)7));
    }

    @Test
    public void testNumBytes() {
        Assert.assertEquals((long)1L, (long)UFIntTool.numBytes((long)0L));
        Assert.assertEquals((long)1L, (long)UFIntTool.numBytes((long)1L));
        Assert.assertEquals((long)1L, (long)UFIntTool.numBytes((long)255L));
        Assert.assertEquals((long)2L, (long)UFIntTool.numBytes((long)256L));
        Assert.assertEquals((long)2L, (long)UFIntTool.numBytes((long)65535L));
        Assert.assertEquals((long)3L, (long)UFIntTool.numBytes((long)65536L));
        Assert.assertEquals((long)4L, (long)UFIntTool.numBytes((long)0xFFFFFFFFL));
        Assert.assertEquals((long)5L, (long)UFIntTool.numBytes((long)0x100000000L));
        Assert.assertEquals((long)4L, (long)UFIntTool.numBytes((long)Integer.MAX_VALUE));
        Assert.assertEquals((long)8L, (long)UFIntTool.numBytes((long)Long.MAX_VALUE));
        Assert.assertEquals((long)8L, (long)UFIntTool.numBytes((long)0x7FFFFFFFFFFFFFFEL));
    }

    @Test
    public void testGetBytes() {
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])UFIntTool.getBytes((int)1, (long)0L));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])UFIntTool.getBytes((int)1, (long)1L));
        Assert.assertArrayEquals((byte[])new byte[]{-1}, (byte[])UFIntTool.getBytes((int)1, (long)255L));
        Assert.assertArrayEquals((byte[])new byte[]{1, 0}, (byte[])UFIntTool.getBytes((int)2, (long)256L));
        Assert.assertArrayEquals((byte[])new byte[]{1, 3}, (byte[])UFIntTool.getBytes((int)2, (long)259L));
        Assert.assertArrayEquals((byte[])new byte[]{1, -128}, (byte[])UFIntTool.getBytes((int)2, (long)384L));
        Assert.assertArrayEquals((byte[])new byte[]{1, -1}, (byte[])UFIntTool.getBytes((int)2, (long)511L));
        Assert.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1}, (byte[])UFIntTool.getBytes((int)4, (long)Integer.MAX_VALUE));
        Assert.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1, -1, -1, -1, -1}, (byte[])UFIntTool.getBytes((int)8, (long)Long.MAX_VALUE));
    }

    @Test
    public void testFromBytes() {
        Assert.assertEquals((long)0L, (long)UFIntTool.fromBytes((byte[])new byte[]{0}));
        Assert.assertEquals((long)1L, (long)UFIntTool.fromBytes((byte[])new byte[]{1}));
        Assert.assertEquals((long)255L, (long)UFIntTool.fromBytes((byte[])new byte[]{-1}));
        Assert.assertEquals((long)256L, (long)UFIntTool.fromBytes((byte[])new byte[]{1, 0}));
        Assert.assertEquals((long)259L, (long)UFIntTool.fromBytes((byte[])new byte[]{1, 3}));
        Assert.assertEquals((long)384L, (long)UFIntTool.fromBytes((byte[])new byte[]{1, -128}));
        Assert.assertEquals((long)511L, (long)UFIntTool.fromBytes((byte[])new byte[]{1, -1}));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)UFIntTool.fromBytes((byte[])new byte[]{127, -1, -1, -1}));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)UFIntTool.fromBytes((byte[])new byte[]{127, -1, -1, -1, -1, -1, -1, -1}));
    }

    @Test
    public void testRoundTrips() {
        long[] values = new long[]{0L, 1L, 2L, 255L, 256L, 31123L, 65535L, 65536L, 65537L, 0xFFFFFEL, 0xFFFFFFL, 0x1000000L, 0x1000001L, 0x7FFFFFFEL, Integer.MAX_VALUE, 0x80000000L, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE};
        for (int i = 0; i < values.length; ++i) {
            Assert.assertEquals((long)values[i], (long)UFIntTool.fromBytes((byte[])UFIntTool.getBytes((int)8, (long)values[i])));
        }
    }

    @Test
    public void testWriteBytes() throws IOException {
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])this.bytesViaOutputStream(1, 0L));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])this.bytesViaOutputStream(1, 1L));
        Assert.assertArrayEquals((byte[])new byte[]{-1}, (byte[])this.bytesViaOutputStream(1, 255L));
        Assert.assertArrayEquals((byte[])new byte[]{1, 0}, (byte[])this.bytesViaOutputStream(2, 256L));
        Assert.assertArrayEquals((byte[])new byte[]{1, 3}, (byte[])this.bytesViaOutputStream(2, 259L));
        Assert.assertArrayEquals((byte[])new byte[]{1, -128}, (byte[])this.bytesViaOutputStream(2, 384L));
        Assert.assertArrayEquals((byte[])new byte[]{1, -1}, (byte[])this.bytesViaOutputStream(2, 511L));
        Assert.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1}, (byte[])this.bytesViaOutputStream(4, Integer.MAX_VALUE));
        Assert.assertArrayEquals((byte[])new byte[]{127, -1, -1, -1, -1, -1, -1, -1}, (byte[])this.bytesViaOutputStream(8, Long.MAX_VALUE));
    }

    private byte[] bytesViaOutputStream(int outputWidth, long value) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        UFIntTool.writeBytes((int)outputWidth, (long)value, (OutputStream)os);
        return os.toByteArray();
    }
}

