/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.row.TestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataSearchWithPrefix;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestPrefixTreeSearcher {
    protected static int BLOCK_START = 7;
    protected TestRowData rows;
    protected ByteBuffer block;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        new TestRowData.InMemory();
        return TestRowData.InMemory.getAllAsObjectArray();
    }

    public TestPrefixTreeSearcher(TestRowData testRows) throws IOException {
        this.rows = testRows;
        ByteArrayOutputStream os = new ByteArrayOutputStream(0x100000);
        PrefixTreeEncoder kvBuilder = new PrefixTreeEncoder((OutputStream)os, true);
        for (KeyValue kv : this.rows.getInputs()) {
            kvBuilder.write((Cell)kv);
        }
        kvBuilder.flush();
        byte[] outputBytes = os.toByteArray();
        this.block = ByteBuffer.wrap(outputBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanForwards() throws IOException {
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            int i = -1;
            while (searcher.advance()) {
                KeyValue inputCell = this.rows.getInputs().get(++i);
                Cell outputCell = searcher.current();
                Assert.assertEquals((Object)inputCell, (Object)outputCell);
                Assert.assertEquals((Object)outputCell, (Object)inputCell);
                Assert.assertTrue((boolean)CellComparator.equals((Cell)inputCell, (Cell)outputCell));
            }
            Assert.assertEquals((long)this.rows.getInputs().size(), (long)(i + 1));
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScanBackwards() throws IOException {
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            searcher.positionAfterLastCell();
            int i = -1;
            while (searcher.previous()) {
                int oppositeIndex = this.rows.getInputs().size() - ++i - 1;
                KeyValue inputKv = this.rows.getInputs().get(oppositeIndex);
                KeyValue outputKv = KeyValueUtil.copyToNewKeyValue((Cell)searcher.current());
                Assert.assertEquals((Object)inputKv, (Object)outputKv);
            }
            Assert.assertEquals((long)this.rows.getInputs().size(), (long)(i + 1));
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomSeekHits() throws IOException {
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            for (KeyValue kv : this.rows.getInputs()) {
                boolean hit = searcher.positionAt((Cell)kv);
                Assert.assertTrue((boolean)hit);
                Cell foundKv = searcher.current();
                Assert.assertTrue((boolean)CellComparator.equals((Cell)kv, (Cell)foundKv));
            }
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomSeekMisses() throws IOException {
        PrefixTreeArraySearcher searcher = null;
        List<Integer> rowStartIndexes = this.rows.getRowStartIndexes();
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            for (boolean beforeVsAfterOnMiss : new boolean[]{true, false}) {
                for (int i = 0; i < this.rows.getInputs().size(); ++i) {
                    int rowIndex;
                    KeyValue kv = this.rows.getInputs().get(i);
                    KeyValue inputNextRow = KeyValueUtil.createFirstKeyInNextRow((Cell)kv);
                    CellScannerPosition position = beforeVsAfterOnMiss ? searcher.positionAtOrBefore((Cell)inputNextRow) : searcher.positionAtOrAfter((Cell)inputNextRow);
                    boolean isFirstInRow = rowStartIndexes.contains(i);
                    if (isFirstInRow && (rowIndex = rowStartIndexes.indexOf(i)) < rowStartIndexes.size() - 1) {
                        if (beforeVsAfterOnMiss) {
                            Assert.assertEquals((Object)CellScannerPosition.BEFORE, (Object)position);
                        } else {
                            Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)position);
                        }
                        int expectedInputIndex = beforeVsAfterOnMiss ? rowStartIndexes.get(rowIndex + 1) - 1 : rowStartIndexes.get(rowIndex + 1);
                        Assert.assertEquals((Object)this.rows.getInputs().get(expectedInputIndex), (Object)searcher.current());
                    }
                    KeyValue inputPreviousKv = KeyValueUtil.previousKey((KeyValue)kv);
                    boolean hit = searcher.positionAt((Cell)inputPreviousKv);
                    Assert.assertFalse((boolean)hit);
                    position = searcher.positionAtOrAfter((Cell)inputPreviousKv);
                    if (CollectionUtils.isLastIndex(this.rows.getInputs(), (int)i)) {
                        Assert.assertTrue((CellScannerPosition.AFTER_LAST == position ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((CellScannerPosition.AFTER == position ? 1 : 0) != 0);
                    Assert.assertEquals((Object)this.rows.getInputs().get(i + 1), (Object)searcher.current());
                }
            }
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }

    @Test
    public void testRandomSeekIndividualAssertions() throws IOException {
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            this.rows.individualSearcherAssertions((CellSearcher)searcher);
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekWithPrefix() throws IOException {
        if (!(this.rows instanceof TestRowDataSearchWithPrefix)) {
            return;
        }
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut((ByteBuffer)this.block, (boolean)true);
            KeyValue kv = this.rows.getInputs().get(1);
            KeyValue firstKVOnRow = KeyValueUtil.createFirstOnRow((byte[])Arrays.copyOfRange(kv.getRowArray(), kv.getRowOffset(), kv.getRowOffset() + kv.getRowLength() / 2));
            CellScannerPosition position = searcher.positionAtOrAfter((Cell)firstKVOnRow);
            Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)position);
            Assert.assertEquals((Object)kv, (Object)searcher.current());
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn((CellSearcher)searcher);
    }
}

