/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.hbase.metrics.impl.RefCountingMap;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestRefCountingMap {
    private RefCountingMap<String, String> map;

    @Before
    public void setUp() {
        this.map = new RefCountingMap();
    }

    @Test
    public void testPutGet() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        String v = (String)this.map.get((Object)"foo");
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"foovalue", (Object)v);
    }

    @Test
    public void testPutMulti() {
        String v1 = (String)this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        String v2 = (String)this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        String v3 = (String)this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        String v = (String)this.map.get((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        Assert.assertEquals((Object)v, (Object)v1);
        Assert.assertEquals((Object)v, (Object)v2);
        Assert.assertEquals((Object)v, (Object)v3);
    }

    @Test
    public void testPutRemove() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        String v = (String)this.map.remove((Object)"foo");
        Assert.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assert.assertNull((Object)v);
    }

    @Test
    public void testPutRemoveMulti() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        String v = (String)this.map.remove((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assert.assertEquals((Object)"foovalue", (Object)v);
        v = (String)this.map.remove((Object)"foo");
        Assert.assertNull((Object)v);
        v = (String)this.map.get((Object)"foo");
        Assert.assertNull((Object)v);
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)this.map.size());
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        Assert.assertEquals((long)1L, (long)this.map.size());
        this.map.put((Object)"bar", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        Assert.assertEquals((long)2L, (long)this.map.size());
        this.map.put((Object)"bar", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        Assert.assertEquals((long)2L, (long)this.map.size());
    }

    @Test
    public void testClear() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        this.map.put((Object)"bar", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        this.map.put((Object)"baz", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        this.map.clear();
        Assert.assertEquals((long)0L, (long)this.map.size());
    }

    @Test
    public void testKeySet() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        this.map.put((Object)"bar", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        this.map.put((Object)"baz", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        Set keys = this.map.keySet();
        Assert.assertEquals((long)3L, (long)keys.size());
        for (String v : Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"})) {
            Assert.assertTrue((boolean)keys.contains(v));
        }
    }

    @Test
    public void testValues() {
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue";
            }
        });
        this.map.put((Object)"foo", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue2";
            }
        });
        this.map.put((Object)"bar", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue3";
            }
        });
        this.map.put((Object)"baz", (Supplier)new Supplier<String>(){

            public String get() {
                return "foovalue4";
            }
        });
        Collection values = this.map.values();
        Assert.assertEquals((long)3L, (long)values.size());
        for (String v : Lists.newArrayList((Object[])new String[]{"foovalue", "foovalue3", "foovalue4"})) {
            Assert.assertTrue((boolean)values.contains(v));
        }
    }
}

