/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.test.IntegrationTestTimeBoundedRequestsWithRegionReplicas;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestTimeBoundedMultiGetRequestsWithRegionReplicas
extends IntegrationTestTimeBoundedRequestsWithRegionReplicas {
    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        ArrayList args = Lists.newArrayList((Object[])super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys));
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        args.add("-multiget_batchsize");
        args.add(this.conf.get(String.format("%s.%s", clazz, "multiget_batchsize"), "100"));
        args.add("-num_regions_per_server");
        args.add(this.conf.get(String.format("%s.%s", clazz, "num_regions_per_server"), Integer.toString(LoadTestTool.DEFAULT_NUM_REGIONS_PER_SERVER)));
        return args.toArray(new String[args.size()]);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestTimeBoundedMultiGetRequestsWithRegionReplicas(), (String[])args);
        System.exit(ret);
    }
}

