/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.util;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class ChaosMonkeyRunner
extends AbstractHBaseTool {
    private static final Log LOG = LogFactory.getLog(ChaosMonkeyRunner.class);
    public static final String MONKEY_LONG_OPT = "monkey";
    public static final String CHAOS_MONKEY_PROPS = "monkeyProps";
    public static final String TABLE_NAME_OPT = "tableName";
    public static final String FAMILY_NAME_OPT = "familyName";
    protected IntegrationTestingUtility util;
    protected ChaosMonkey monkey;
    protected String monkeyToUse;
    protected Properties monkeyProps;
    protected boolean noClusterCleanUp = false;
    private String tableName = "ChaosMonkeyRunner.tableName";
    private String familyName = "ChaosMonkeyRunner.familyName";

    public void addOptions() {
        this.addOptWithArg("m", MONKEY_LONG_OPT, "Which chaos monkey to run");
        this.addOptWithArg(CHAOS_MONKEY_PROPS, "The properties file for specifying chaos monkey properties.");
        this.addOptWithArg(TABLE_NAME_OPT, "Table name in the test to run chaos monkey against");
        this.addOptWithArg(FAMILY_NAME_OPT, "Family name in the test to run chaos monkey against");
    }

    protected void processOptions(CommandLine cmd) {
        String chaosMonkeyPropsFile;
        if (cmd.hasOption(MONKEY_LONG_OPT)) {
            this.monkeyToUse = cmd.getOptionValue(MONKEY_LONG_OPT);
        }
        this.monkeyProps = new Properties();
        if (cmd.hasOption(CHAOS_MONKEY_PROPS) && StringUtils.isNotEmpty((String)(chaosMonkeyPropsFile = cmd.getOptionValue(CHAOS_MONKEY_PROPS)))) {
            try {
                this.monkeyProps.load(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(chaosMonkeyPropsFile));
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                System.exit(1);
            }
        }
        if (cmd.hasOption(TABLE_NAME_OPT)) {
            this.tableName = cmd.getOptionValue(TABLE_NAME_OPT);
        }
        if (cmd.hasOption(FAMILY_NAME_OPT)) {
            this.familyName = cmd.getOptionValue(FAMILY_NAME_OPT);
        }
    }

    protected int doWork() throws Exception {
        this.setUpCluster();
        this.getAndStartMonkey();
        while (true) {
            Thread.sleep(10000L);
        }
    }

    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        boolean isDistributed = this.isDistributedCluster(this.getConf());
        if (!isDistributed) {
            throw new RuntimeException("ChaosMonkeyRunner must run againt a distributed cluster, please check and point to the right configuration dir");
        }
        this.util.createDistributedHBaseCluster();
        this.util.checkNodeCount(1);
        this.setConf(this.util.getConfiguration());
    }

    private boolean isDistributedCluster(Configuration conf) {
        return conf.getBoolean("hbase.cluster.distributed", false);
    }

    public void getAndStartMonkey() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        MonkeyFactory fact = MonkeyFactory.getFactory(this.monkeyToUse);
        if (fact == null) {
            fact = this.getDefaultMonkeyFactory();
        }
        this.monkey = fact.setUtil(this.util).setTableName(this.getTablename()).setProperties(this.monkeyProps).setColumnFamilies(this.getColumnFamilies()).build();
        this.monkey.start();
    }

    protected IntegrationTestingUtility getTestingUtil(Configuration conf) {
        if (this.util == null) {
            if (conf == null) {
                this.util = new IntegrationTestingUtility();
                this.setConf(this.util.getConfiguration());
            } else {
                this.util = new IntegrationTestingUtility(conf);
            }
        }
        return this.util;
    }

    protected MonkeyFactory getDefaultMonkeyFactory() {
        return MonkeyFactory.getFactory("slowDeterministic");
    }

    public TableName getTablename() {
        return TableName.valueOf((String)this.tableName);
    }

    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{this.familyName});
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new ChaosMonkeyRunner(), (String[])args);
        System.exit(ret);
    }
}

