/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactRandomRegionOfTableAction
extends Action {
    private final int majorRatio;
    private final long sleepTime;
    private final TableName tableName;
    private static final Logger LOG = LoggerFactory.getLogger(CompactRandomRegionOfTableAction.class);

    public CompactRandomRegionOfTableAction(TableName tableName, float majorRatio) {
        this(-1, tableName, majorRatio);
    }

    public CompactRandomRegionOfTableAction(int sleepTime, TableName tableName, float majorRatio) {
        this.majorRatio = (int)(100.0f * majorRatio);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        boolean major = RandomUtils.nextInt((int)100) < this.majorRatio;
        LOG.info("Performing action: Compact random region of table " + this.tableName + ", major=" + major);
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            LOG.info("Table " + this.tableName + " doesn't have regions to compact");
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        try {
            if (major) {
                LOG.debug("Major compacting region " + region.getRegionNameAsString());
                admin.majorCompactRegion(region.getRegionName());
            } else {
                LOG.debug("Compacting region " + region.getRegionNameAsString());
                admin.compactRegion(region.getRegionName());
            }
        }
        catch (Exception ex) {
            LOG.warn("Compaction failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

