/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(FlushTableAction.class);
    private final long sleepTime;
    private final TableName tableName;

    public FlushTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public FlushTableAction(int sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        if (this.context.isStopping()) {
            return;
        }
        LOG.info("Performing action: Flush table " + this.tableName);
        try {
            admin.flush(this.tableName);
        }
        catch (Exception ex) {
            LOG.warn("Flush failed, might be caused by other chaos: " + ex.getMessage());
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

