/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.factories;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.factories.CalmMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.MasterKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.NoKillMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ServerAndDependenciesKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.ServerKillingMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.SlowDeterministicMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.StressAssignmentManagerMonkeyFactory;
import org.apache.hadoop.hbase.chaos.factories.UnbalanceMonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.util.ReflectionUtils;

public abstract class MonkeyFactory {
    private static final Log LOG = LogFactory.getLog(MonkeyFactory.class);
    protected TableName tableName;
    protected Set<String> columnFamilies;
    protected IntegrationTestingUtility util;
    protected Properties properties = new Properties();
    public static final String CALM = "calm";
    public static final String SLOW_DETERMINISTIC = "slowDeterministic";
    public static final String UNBALANCE = "unbalance";
    public static final String SERVER_KILLING = "serverKilling";
    public static final String STRESS_AM = "stressAM";
    public static final String NO_KILL = "noKill";
    public static final String MASTER_KILLING = "masterKilling";
    public static final String SERVER_AND_DEPENDENCIES_KILLING = "serverAndDependenciesKilling";
    public static Map<String, MonkeyFactory> FACTORIES = ImmutableMap.builder().put((Object)"calm", (Object)new CalmMonkeyFactory()).put((Object)"slowDeterministic", (Object)new SlowDeterministicMonkeyFactory()).put((Object)"unbalance", (Object)new UnbalanceMonkeyFactory()).put((Object)"serverKilling", (Object)new ServerKillingMonkeyFactory()).put((Object)"serverAndDependenciesKilling", (Object)new ServerAndDependenciesKillingMonkeyFactory()).put((Object)"stressAM", (Object)new StressAssignmentManagerMonkeyFactory()).put((Object)"noKill", (Object)new NoKillMonkeyFactory()).put((Object)"masterKilling", (Object)new MasterKillingMonkeyFactory()).build();

    public MonkeyFactory setTableName(TableName tableName) {
        this.tableName = tableName;
        return this;
    }

    public MonkeyFactory setColumnFamilies(Set<String> columnFamilies) {
        this.columnFamilies = columnFamilies;
        return this;
    }

    public MonkeyFactory setUtil(IntegrationTestingUtility util) {
        this.util = util;
        return this;
    }

    public MonkeyFactory setProperties(Properties props) {
        if (props != null) {
            this.properties = props;
        }
        return this;
    }

    public abstract ChaosMonkey build();

    public static MonkeyFactory getFactory(String factoryName) {
        MonkeyFactory fact = FACTORIES.get(factoryName);
        if (fact == null && factoryName != null && !factoryName.isEmpty()) {
            Class<?> klass = null;
            try {
                klass = Class.forName(factoryName);
                if (klass != null) {
                    fact = (MonkeyFactory)ReflectionUtils.newInstance(klass, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error trying to create " + factoryName + " could not load it by class name"));
                return null;
            }
        }
        return fact;
    }
}

