/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestLazyCfLoading {
    private static final TableName TABLE_NAME = TableName.valueOf((String)IntegrationTestLazyCfLoading.class.getSimpleName());
    private static final String TIMEOUT_KEY = "hbase.%s.timeout";
    private static final String ENCODING_KEY = "hbase.%s.datablock.encoding";
    private static final int DEFAULT_TIMEOUT_MINUTES = 10;
    private static final int NUM_SERVERS = 1;
    private static final int REGIONS_PER_SERVER = 3;
    private static final int KEYS_TO_WRITE_PER_SERVER = 20000;
    private static final int WRITER_THREADS = 10;
    private static final int WAIT_BETWEEN_SCANS_MS = 1000;
    private static final Log LOG = LogFactory.getLog(IntegrationTestLazyCfLoading.class);
    private IntegrationTestingUtility util = new IntegrationTestingUtility();
    private final DataGenerator dataGen = new DataGenerator();

    @Before
    public void setUp() throws Exception {
        LOG.info((Object)"Initializing cluster with 1 servers");
        this.util.initializeCluster(1);
        LOG.info((Object)"Done initializing cluster");
        this.createTable();
        Thread.sleep(3000L);
    }

    private void createTable() throws Exception {
        this.deleteTable();
        LOG.info((Object)"Creating table");
        Configuration conf = this.util.getConfiguration();
        String encodingKey = String.format(ENCODING_KEY, this.getClass().getSimpleName());
        DataBlockEncoding blockEncoding = DataBlockEncoding.valueOf((String)conf.get(encodingKey, "FAST_DIFF"));
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        for (byte[] cf : this.dataGen.getColumnFamilies()) {
            HColumnDescriptor hcd = new HColumnDescriptor(cf);
            hcd.setDataBlockEncoding(blockEncoding);
            htd.addFamily(hcd);
        }
        int serverCount = this.util.getHBaseClusterInterface().getClusterStatus().getServersSize();
        byte[][] splits = new RegionSplitter.HexStringSplit().split(serverCount * 3);
        this.util.getHBaseAdmin().createTable(htd, splits);
        LOG.info((Object)"Created table");
    }

    private void deleteTable() throws Exception {
        if (this.util.getHBaseAdmin().tableExists(TABLE_NAME)) {
            LOG.info((Object)"Deleting table");
            this.util.deleteTable(TABLE_NAME);
            LOG.info((Object)"Deleted table");
        }
    }

    @After
    public void tearDown() throws Exception {
        this.deleteTable();
        LOG.info((Object)"Restoring the cluster");
        this.util.restoreCluster();
        LOG.info((Object)"Done restoring the cluster");
    }

    @Test
    public void testReadersAndWriters() throws Exception {
        Configuration conf = this.util.getConfiguration();
        String timeoutKey = String.format(TIMEOUT_KEY, this.getClass().getSimpleName());
        long maxRuntime = conf.getLong(timeoutKey, 10L);
        long serverCount = this.util.getHBaseClusterInterface().getClusterStatus().getServersSize();
        long keysToWrite = serverCount * 20000L;
        HTable table = new HTable(conf, TABLE_NAME);
        MultiThreadedWriter writer = new MultiThreadedWriter((LoadTestDataGenerator)this.dataGen, conf, TABLE_NAME);
        writer.setMultiPut(true);
        LOG.info((Object)("Starting writer; the number of keys to write is " + keysToWrite));
        writer.start(1L, keysToWrite, 10);
        long now = EnvironmentEdgeManager.currentTime();
        long timeLimit = now + maxRuntime * 60000L;
        boolean isWriterDone = false;
        while (now < timeLimit && !isWriterDone) {
            LOG.info((Object)("Starting the scan; wrote approximately " + this.dataGen.getTotalNumberOfKeys() + " keys"));
            isWriterDone = writer.isDone();
            if (isWriterDone) {
                LOG.info((Object)"Scanning full result, writer is done");
            }
            Scan scan = new Scan();
            for (byte[] cf : this.dataGen.getColumnFamilies()) {
                scan.addFamily(cf);
            }
            scan.setFilter(this.dataGen.getScanFilter());
            scan.setLoadColumnFamiliesOnDemand(true);
            long onesGennedBeforeScan = this.dataGen.getExpectedNumberOfKeys();
            long startTs = EnvironmentEdgeManager.currentTime();
            ResultScanner results = table.getScanner(scan);
            long resultCount = 0L;
            Result result = null;
            while ((result = results.next()) != null) {
                boolean isOk = writer.verifyResultAgainstDataGenerator(result, true, true);
                Assert.assertTrue((String)("Failed to verify [" + Bytes.toString((byte[])result.getRow()) + "]"), (boolean)isOk);
                ++resultCount;
            }
            long timeTaken = EnvironmentEdgeManager.currentTime() - startTs;
            long onesGennedAfterScan = this.dataGen.getExpectedNumberOfKeys();
            Assert.assertTrue((String)("Read " + resultCount + " keys when at most " + onesGennedAfterScan + " were generated "), (onesGennedAfterScan >= resultCount ? 1 : 0) != 0);
            if (isWriterDone) {
                Assert.assertTrue((String)("Read " + resultCount + " keys; the writer is done and " + onesGennedAfterScan + " keys were generated"), (onesGennedAfterScan == resultCount ? 1 : 0) != 0);
            } else if ((double)onesGennedBeforeScan * 0.9 > (double)resultCount) {
                LOG.warn((Object)("Read way too few keys (" + resultCount + "/" + onesGennedBeforeScan + ") - there might be a problem, or the writer might just be slow"));
            }
            LOG.info((Object)("Scan took " + timeTaken + "ms"));
            if (isWriterDone) continue;
            Thread.sleep(1000L);
            now = EnvironmentEdgeManager.currentTime();
        }
        Assert.assertEquals((String)"There are write failures", (long)0L, (long)writer.getNumWriteFailures());
        Assert.assertTrue((String)"Writer is not done", (boolean)isWriterDone);
    }

    private static class DataGenerator
    extends LoadTestDataGenerator {
        private static final int MIN_DATA_SIZE = 4096;
        private static final int MAX_DATA_SIZE = 65536;
        public static final byte[] ESSENTIAL_CF = Bytes.toBytes((String)"essential");
        public static final byte[] JOINED_CF1 = Bytes.toBytes((String)"joined");
        public static final byte[] JOINED_CF2 = Bytes.toBytes((String)"joined2");
        public static final byte[] FILTER_COLUMN = Bytes.toBytes((String)"filter");
        public static final byte[] VALUE_COLUMN = Bytes.toBytes((String)"val");
        public static final long ACCEPTED_VALUE = 1L;
        private static final Map<byte[], byte[][]> columnMap = new TreeMap<byte[], byte[][]>(Bytes.BYTES_COMPARATOR);
        private final AtomicLong expectedNumberOfKeys = new AtomicLong(0L);
        private final AtomicLong totalNumberOfKeys = new AtomicLong(0L);

        public DataGenerator() {
            super(4096, 65536);
            columnMap.put(ESSENTIAL_CF, new byte[][]{FILTER_COLUMN});
            columnMap.put(JOINED_CF1, new byte[][]{FILTER_COLUMN, VALUE_COLUMN});
            columnMap.put(JOINED_CF2, new byte[][]{VALUE_COLUMN});
        }

        public long getExpectedNumberOfKeys() {
            return this.expectedNumberOfKeys.get();
        }

        public long getTotalNumberOfKeys() {
            return this.totalNumberOfKeys.get();
        }

        public byte[] getDeterministicUniqueKey(long keyBase) {
            return LoadTestKVGenerator.md5PrefixedKey((long)keyBase).getBytes();
        }

        public byte[][] getColumnFamilies() {
            return (byte[][])columnMap.keySet().toArray((T[])new byte[columnMap.size()][]);
        }

        public byte[][] generateColumnsForCf(byte[] rowKey, byte[] cf) {
            return columnMap.get(cf);
        }

        public byte[] generateValue(byte[] rowKey, byte[] cf, byte[] column) {
            if (Bytes.BYTES_COMPARATOR.compare(column, FILTER_COLUMN) == 0) {
                long value = Long.parseLong(Bytes.toString((byte[])rowKey, (int)0, (int)4), 16) & 1L;
                if (Bytes.BYTES_COMPARATOR.compare(cf, ESSENTIAL_CF) == 0) {
                    this.totalNumberOfKeys.incrementAndGet();
                    if (value == 1L) {
                        this.expectedNumberOfKeys.incrementAndGet();
                    }
                }
                return Bytes.toBytes((long)value);
            }
            if (Bytes.BYTES_COMPARATOR.compare(column, VALUE_COLUMN) == 0) {
                return this.kvGenerator.generateRandomSizeValue((byte[][])new byte[][]{rowKey, cf, column});
            }
            String error = "Unknown column " + Bytes.toString((byte[])column);
            assert (false) : error;
            throw new InvalidParameterException(error);
        }

        public boolean verify(byte[] rowKey, byte[] cf, byte[] column, byte[] value) {
            if (Bytes.BYTES_COMPARATOR.compare(column, FILTER_COLUMN) == 0) {
                return Bytes.toLong((byte[])value) == 1L;
            }
            if (Bytes.BYTES_COMPARATOR.compare(column, VALUE_COLUMN) == 0) {
                return LoadTestKVGenerator.verify((byte[])value, (byte[][])new byte[][]{rowKey, cf, column});
            }
            return false;
        }

        public boolean verify(byte[] rowKey, byte[] cf, Set<byte[]> columnSet) {
            return columnMap.get(cf).length == columnSet.size();
        }

        public Filter getScanFilter() {
            SingleColumnValueFilter scf = new SingleColumnValueFilter(ESSENTIAL_CF, FILTER_COLUMN, CompareFilter.CompareOp.EQUAL, Bytes.toBytes((long)1L));
            scf.setFilterIfMissing(true);
            return scf;
        }
    }
}

