/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.field;

import java.util.TreeSet;
import org.apache.hadoop.hbase.hbtop.field.Size;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestSize {
    @Test
    public void testConversion() {
        Size kbSize = new Size(1024.0, Size.Unit.MEGABYTE);
        Assert.assertEquals((double)1.0, (double)kbSize.get(Size.Unit.GIGABYTE), (double)0.0);
        Assert.assertEquals((double)1024.0, (double)kbSize.get(), (double)0.0);
        Assert.assertEquals((double)1048576.0, (double)kbSize.get(Size.Unit.KILOBYTE), (double)0.0);
        Assert.assertEquals((double)1.073741824E9, (double)kbSize.get(Size.Unit.BYTE), (double)0.0);
    }

    @Test
    public void testCompare() {
        Size size00 = new Size(100.0, Size.Unit.GIGABYTE);
        Size size01 = new Size(100.0, Size.Unit.MEGABYTE);
        Size size02 = new Size(100.0, Size.Unit.BYTE);
        TreeSet<Size> sizes = new TreeSet<Size>();
        sizes.add(size00);
        sizes.add(size01);
        sizes.add(size02);
        int count = 0;
        block4: for (Size s : sizes) {
            switch (count++) {
                case 0: {
                    Assert.assertEquals((Object)size02, (Object)s);
                    continue block4;
                }
                case 1: {
                    Assert.assertEquals((Object)size01, (Object)s);
                    continue block4;
                }
            }
            Assert.assertEquals((Object)size00, (Object)s);
        }
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testEqual() {
        Assert.assertEquals((Object)new Size(1024.0, Size.Unit.TERABYTE), (Object)new Size(1.0, Size.Unit.PETABYTE));
        Assert.assertEquals((Object)new Size(1024.0, Size.Unit.GIGABYTE), (Object)new Size(1.0, Size.Unit.TERABYTE));
        Assert.assertEquals((Object)new Size(1024.0, Size.Unit.MEGABYTE), (Object)new Size(1.0, Size.Unit.GIGABYTE));
        Assert.assertEquals((Object)new Size(1024.0, Size.Unit.KILOBYTE), (Object)new Size(1.0, Size.Unit.MEGABYTE));
        Assert.assertEquals((Object)new Size(1024.0, Size.Unit.BYTE), (Object)new Size(1.0, Size.Unit.KILOBYTE));
    }
}

